/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinParamType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasCallableType;
import com.intellij.database.types.DasCompositeType;
import com.intellij.database.types.DasSetofType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002*+B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(H\u0016R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionImpl;", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "Lcom/intellij/navigation/NavigationItem;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "getNameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getCallableExpression", "Lcom/intellij/sql/psi/SqlExpression;", "getParameterList", "Lcom/intellij/sql/psi/SqlExpressionList;", "prototypeForReturnType", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "getPrototypeForReturnType", "()Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "computeDasType", "Lcom/intellij/database/types/DasType;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getFunctionDefinition", "Lcom/intellij/sql/dialects/BuiltinFunction;", "getExpectedReferenceTargetType", "Lcom/intellij/database/model/ObjectKind;", "referenceElement", "Lcom/intellij/sql/psi/SqlElement;", "isFunctionWithColumnQualifier", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "processImplicitContextDeclarations", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "FakeParameter", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlFunctionCallExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFunctionCallExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,516:1\n275#2:517\n*S KotlinDebug\n*F\n+ 1 SqlFunctionCallExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl\n*L\n45#1:517\n*E\n"})
public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlFunctionCallExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        SqlExpression sqlExpression = this.getCallableExpression();
        return sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null;
    }

    @Nullable
    public SqlExpression getCallableExpression() {
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlExpression.class);
    }

    @Nullable
    public SqlExpressionList getParameterList() {
        for (PsiElement c : SqlImplUtil.sqlRevChildren((PsiElement)this)) {
            if (!(c instanceof SqlExpressionList)) continue;
            return (SqlExpressionList)c;
        }
        return null;
    }

    private final BuiltinFunction.Prototype getPrototypeForReturnType() {
        DasSymbol callableSymbol;
        BuiltinFunction.Prototype prototype;
        BuiltinFunction.Prototype prototype2 = prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        if (prototype2 != null) {
            return prototype2;
        }
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement != null && (callableSymbol = nameElement.resolveSymbol()) instanceof BuiltinFunction) {
            BuiltinFunction.Prototype[] prototypeArray = ((BuiltinFunction)callableSymbol).getPrototypes();
            Intrinsics.checkNotNullExpressionValue((Object)prototypeArray, (String)"getPrototypes(...)");
            return (BuiltinFunction.Prototype)ArraysKt.singleOrNull((Object[])prototypeArray);
        }
        return null;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        SqlReferenceExpression nameElement = this.getNameElement();
        BuiltinFunction.Prototype prototype = this.getPrototypeForReturnType();
        if (prototype != null) {
            return Companion.createBuiltinFunctionReturnType(prototype, nameElement, (PsiElement)this.getParameterList(), (PsiElement)this);
        }
        if (nameElement == null) {
            SqlExpression sqlExpression = this.getCallableExpression();
            DasType dasType = sqlExpression != null ? sqlExpression.getDasType() : null;
            DasTableType dasTableType = dasType instanceof DasTableType ? (DasTableType)dasType : null;
            return dasTableType != null ? (DasType)dasTableType : (DasType)DasTypeSystemBase.UNKNOWN;
        }
        return Companion.createFunctionReturnType(nameElement, (PsiElement)this);
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(this){
            final /* synthetic */ SqlFunctionCallExpressionImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public String getPresentableText() {
                SqlReferenceExpression sqlReferenceExpression = this.this$0.getNameElement();
                return sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null;
            }

            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public BuiltinFunction getFunctionDefinition() {
        if (this.getParent() instanceof SqlScopingExpression) {
            return null;
        }
        SqlReferenceExpression sqlReferenceExpression = this.getNameElement();
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression nameElement = sqlReferenceExpression;
        String string = nameElement.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String functionName = string;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)this);
        BuiltinFunction definition = dialect.getSupportedFunctions().get(functionName);
        if (definition != null && SqlImplUtil.hasLocationOf(definition, dialect.getExpectedFunctionLocations((SqlExpression)nameElement))) {
            return definition;
        }
        return null;
    }

    @Override
    @Nullable
    public ObjectKind getExpectedReferenceTargetType(@Nullable SqlElement referenceElement) {
        if (Intrinsics.areEqual((Object)referenceElement, (Object)this.getNameElement()) && !Intrinsics.areEqual((Object)this.getFirstChild(), (Object)this.getLastChild())) {
            return ObjectKind.ROUTINE;
        }
        return super.getExpectedReferenceTargetType(referenceElement);
    }

    private final boolean isFunctionWithColumnQualifier(SqlScopeProcessor processor) {
        if (!processor.getDialect().getDbms().isMicrosoft()) {
            return false;
        }
        BuiltinFunction builtinFunction = this.getFunctionDefinition();
        if (builtinFunction == null) {
            return false;
        }
        BuiltinFunction funDef = builtinFunction;
        String string = funDef.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        return StringsKt.equals((String)name, (String)"CONTAINSTABLE", (boolean)true) || StringsKt.equals((String)name, (String)"FREETEXTTABLE", (boolean)true);
    }

    @Override
    public boolean processImplicitContextDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @Nullable PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ObjectKind[] objectKindArray = new ObjectKind[]{ObjectKind.ARGUMENT};
        if (!SqlImplUtil.isProcessingOneOf(processor, objectKindArray)) {
            return true;
        }
        if (!Companion.processNamedArgument(this.getNameElement(), place, (Processor<? super DasSymbol>)((Processor)arg_0 -> SqlFunctionCallExpressionImpl.processImplicitContextDeclarations$lambda$1(arg_0 -> SqlFunctionCallExpressionImpl.processImplicitContextDeclarations$lambda$0(processor, state, arg_0), arg_0)))) {
            return false;
        }
        if (processor.mayAccept(ObjectKind.COLUMN) && this.isFunctionWithColumnQualifier(processor)) {
            Object object = this.getParameterList();
            if (object == null || (object = object.getExpressionList()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object expressions = object;
            Iterator iterator = expressions.iterator();
            while (iterator.hasNext()) {
                SqlExpression expression = (SqlExpression)iterator.next();
                if (!(expression instanceof SqlReferenceExpression) || !Intrinsics.areEqual((Object)((SqlReferenceExpression)expression).getKind(), (Object)ObjectKind.TABLE) || SqlImplUtil.processFromReferences(processor, state, expression, place, lastParent)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    private static final boolean processImplicitContextDeclarations$lambda$0(SqlScopeProcessor $processor, ResolveState $state, DasSymbol it) {
        return $processor.execute(it, $state);
    }

    private static final boolean processImplicitContextDeclarations$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final DasType createFunctionReturnType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
        return Companion.createFunctionReturnType(nameElement, routineElement);
    }

    @JvmStatic
    @NotNull
    public static final DasType createBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        return Companion.createBuiltinFunctionReturnType(prototype, nameElement, params, routineElement);
    }

    @JvmStatic
    @NotNull
    public static final DasType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
        return Companion.createRoutineType(resolve, target, ensureTable, qualifier);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J%\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0016\"\n\b\u0000\u0010\u0019\u0018\u0001*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0086\bJ(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0007J\u0012\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001e\u0010&\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(2\u0006\u0010\"\u001a\u00020\tH\u0002J*\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J\u0018\u00101\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J*\u00102\u001a\u00020!2\b\u00103\u001a\u0004\u0018\u00010\u00072\b\u00104\u001a\u0004\u0018\u00010\t2\u000e\u00105\u001a\n\u0012\u0006\b\u0000\u0012\u00020706J \u00108\u001a\u00020!2\b\u00109\u001a\u0004\u0018\u00010\u00072\u000e\u00105\u001a\n\u0012\u0006\b\u0000\u0012\u00020706J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020;0(2\u0006\u0010<\u001a\u00020;H\u0002\u00a8\u0006="}, d2={"Lcom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$Companion;", "", "<init>", "()V", "createFunctionReturnType", "Lcom/intellij/database/types/DasType;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "routineElement", "Lcom/intellij/psi/PsiElement;", "createReturnTypeForCallWithColumns", "Lcom/intellij/sql/psi/SqlTableType;", "params", "createBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "resolveBuiltinDasType", "dasType", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getP0Type", "parameters", "", "Lcom/intellij/sql/psi/SqlCompositeElement;", "collectColumnDefs", "T", "Lcom/intellij/database/model/DasTypedObject;", "container", "createRoutineType", "resolve", "target", "Lcom/intellij/database/model/DasRoutine;", "ensureTable", "", "qualifier", "getParamType", "element", "Lcom/intellij/sql/psi/SqlElement;", "createTypeFromColumns", "args", "", "createType", "routine", "retArg", "Lcom/intellij/database/model/DasArgument;", "getReturnType", "trimSetOf", "Lcom/intellij/database/model/DataType;", "dataType", "getDasType", "processNamedArgument", "ref", "place", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/database/symbols/DasSymbol;", "processParameters", "fooRef", "getParameters", "Lcom/intellij/sql/dialects/BuiltinFunction$Parameter;", "p", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlFunctionCallExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFunctionCallExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,516:1\n340#1,4:517\n339#1:521\n340#1,4:522\n339#1:526\n455#2:527\n1849#3,3:528\n1586#3:532\n1661#3,3:533\n275#4:531\n*S KotlinDebug\n*F\n+ 1 SqlFunctionCallExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$Companion\n*L\n229#1:517,4\n229#1:521\n231#1:522,4\n231#1:526\n311#1:527\n326#1:528,3\n391#1:532\n391#1:533,3\n368#1:531\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DasType createFunctionReturnType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
            DasType dasType;
            Object target;
            Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
            SqlReferenceExpression sqlReferenceExpression = nameElement;
            PsiElement resolve = sqlReferenceExpression != null && (sqlReferenceExpression = sqlReferenceExpression.getReference()) != null ? sqlReferenceExpression.resolve() : null;
            Object object = target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
            if (target instanceof DasSynonym) {
                target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)target));
            }
            if (target instanceof SqlFileImpl.GroupImpl) {
                target = ((SqlFileImpl.GroupImpl)((Object)target)).delegates().first();
            }
            if (target instanceof DasRoutine) {
                PsiElement psiElement = resolve;
                Intrinsics.checkNotNull((Object)psiElement);
                return this.createRoutineType(psiElement, (DasRoutine)target, false, routineElement);
            }
            if (target instanceof SqlCreateTypeStatement) {
                DasType dasType2 = ((SqlCreateTypeStatement)target).getSelfDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getSelfDasType(...)");
                return dasType2;
            }
            Object object2 = target;
            DasType dasType3 = object2 instanceof DasUserDefinedType ? ((DasUserDefinedType)target).getSelfDasType() : (object2 instanceof DasTypedObject ? ((DasTypedObject)target).getDasType() : (DasType)DasTypeSystemBase.UNKNOWN);
            Intrinsics.checkNotNull((Object)dasType3);
            DasType dasType4 = DasTypeUtilsKt.unwrap$default((DasType)dasType3, (boolean)false, null, (int)3, null);
            if (dasType4 instanceof DasCallableType) {
                DasType dasType5 = ((DasCallableType)dasType4).getReturnType();
                dasType = dasType5;
                Intrinsics.checkNotNullExpressionValue((Object)dasType5, (String)"getReturnType(...)");
            } else {
                dasType = dasType4;
            }
            return dasType;
        }

        private final SqlTableType createReturnTypeForCallWithColumns(SqlReferenceExpression nameElement, PsiElement params, PsiElement routineElement) {
            if (params instanceof SqlExpressionList) {
                Companion companion = this;
                PsiElement container$iv = params;
                boolean $i$f$collectColumnDefs = false;
                Function1 function1 = (Function1)new Function1<PsiElement, Boolean>(container$iv){
                    final /* synthetic */ PsiElement $container;
                    {
                        this.$container = $container;
                    }

                    public final Boolean invoke(PsiElement it) {
                        return Intrinsics.areEqual((Object)it, (Object)this.$container) || it instanceof SqlClause;
                    }
                };
                List list = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(container$iv).expandAndSkip(new Condition(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })).filter(SqlColumnDefinition.class).toList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
                List columns = list;
                if (columns.isEmpty()) {
                    Companion this_$iv = this;
                    container$iv = routineElement;
                    $i$f$collectColumnDefs = false;
                    function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                    list = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(container$iv).expandAndSkip(new /* invalid duplicate definition of identical inner class */)).filter(SqlColumnDefinition.class).toList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
                    columns = list;
                }
                if (!columns.isEmpty()) {
                    SqlReferenceExpression sqlReferenceExpression = nameElement;
                    return new TableBasedSqlTableTypeImpl(columns, sqlReferenceExpression != null ? (PsiElement)sqlReferenceExpression : routineElement);
                }
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final DasType createBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
            DasType dasType;
            SqlTableType typeWithColumns;
            DasType typeFromDialect;
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect(routineElement);
            DasType dasType2 = typeFromDialect = dialect.getTypeSystem().getBuiltinFunctionReturnType(prototype, nameElement, params, routineElement);
            if (dasType2 != null) {
                return dasType2;
            }
            BuiltinFunction.Type returnType = prototype.getReturnType();
            if (Intrinsics.areEqual((Object)returnType, (Object)SqlFunctionsUtil.UNNEST)) {
                List cols;
                if (nameElement == null) {
                    SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                    return (DasType)sqlTableType;
                }
                PsiElement psiElement = params;
                if (psiElement instanceof SqlExpressionList) {
                    List list = ((SqlExpressionList)params).getExpressionList();
                    v3 = list;
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
                } else {
                    v3 = cols = psiElement instanceof SqlExpression ? CollectionsKt.listOf((Object)params) : CollectionsKt.emptyList();
                }
                if (cols.isEmpty()) {
                    SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
                    return (DasType)sqlTableType;
                }
                if (cols.size() == 1 && dialect.getDbms().isPostgres()) {
                    DasType dasType3 = ((SqlExpression)CollectionsKt.first((List)cols)).getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
                    DasType dasType4 = dasType3;
                    if (dasType4 instanceof DasArrayType) {
                        DasType dasType5 = ((DasArrayType)dasType4).getComponentType();
                        Intrinsics.checkNotNullExpressionValue((Object)dasType5, (String)"getComponentType(...)");
                        dasType4 = dasType5;
                    }
                    return dasType4;
                }
                StringBuilder builder2 = new StringBuilder();
                for (SqlExpression col : cols) {
                    if (!(((CharSequence)builder2).length() == 0)) {
                        builder2.append(", ");
                    }
                    builder2.append(prototype.getFunction().getName()).append(" ").append(SqlImplUtil.getArrayElement(col.getDasType()).getSpecification());
                }
                DasTypeSystemBase dasTypeSystemBase = dialect.getTypeSystem();
                String string = builder2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String spec = dasTypeSystemBase.getTableTypeSpecification(string);
                DataType dataType = DataTypeFactory.of((String)spec);
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                return this.getDasType(routineElement, DasUnresolvedTypeReference.Companion.of(dataType));
            }
            SqlTableType sqlTableType = typeWithColumns = this.createReturnTypeForCallWithColumns(nameElement, params, routineElement);
            if (sqlTableType != null) {
                return (DasType)sqlTableType;
            }
            BuiltinFunction.Type type = returnType;
            Object object = dasType = type != null ? type.getDasType() : null;
            if (dasType != null) {
                dasType = this.resolveBuiltinDasType(dasType, params, dialect);
                if ((dasType = SqlImplUtil.rebuildDasType(dasType, dialect, routineElement)) instanceof DasTableType && ((DasTableType)dasType).getColumnCount() == 1 && dialect.getDbms().isPostgres()) {
                    DasType dasType6 = ((DasTableType)dasType).getColumnDasType(0);
                    Intrinsics.checkNotNullExpressionValue((Object)dasType6, (String)"getColumnDasType(...)");
                    return dasType6;
                }
                return dasType;
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }

        private final DasType resolveBuiltinDasType(DasType dasType, PsiElement params, SqlLanguageDialectEx dialect) {
            if (!(dasType instanceof DasBuiltinParamType) && !(dasType instanceof DasCompositeType)) {
                return dasType;
            }
            if (params == null) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            PsiElement $this$childrenOfType$iv = params;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlCompositeElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            List parameters = list;
            DasType dasType2 = DasTypeFacade.transform((DasType)dasType, arg_0 -> Companion.resolveBuiltinDasType$lambda$0(parameters, dialect, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"transform(...)");
            return dasType2;
        }

        /*
         * WARNING - void declaration
         */
        private final DasType getP0Type(SqlLanguageDialectEx dialect, List<? extends SqlCompositeElement> parameters) {
            void $this$fold$iv;
            Iterable iterable = parameters;
            DasBuiltinType initial$iv = DasTypeSystemBase.UNKNOWN;
            boolean $i$f$fold = false;
            DasBuiltinType accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void param;
                SqlCompositeElement sqlCompositeElement = (SqlCompositeElement)element$iv;
                DasType curType = (DasType)accumulator$iv;
                boolean bl = false;
                DasType type = Companion.getParamType((SqlElement)param);
                accumulator$iv = Intrinsics.areEqual((Object)curType, (Object)DasTypeSystemBase.UNKNOWN) || DasTypeUtilsKt.is((DasType)type, (DasTypeCategory)DasTypeCategory.REAL) ? type : (DasTypeUtilsKt.is((DasType)curType, (DasTypeCategory)DasTypeCategory.INTEGER) ? dialect.getTypeSystem().getRealType() : curType);
            }
            return (DasType)accumulator$iv;
        }

        public final /* synthetic */ <T extends DasTypedObject> List<T> collectColumnDefs(PsiElement container) {
            boolean $i$f$collectColumnDefs = false;
            Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser(container).expandAndSkip(new /* invalid duplicate definition of identical inner class */);
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            List list = syntaxTraverser.filter(DasTypedObject.class).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            return list;
        }

        @JvmStatic
        @NotNull
        public final DasType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
            Intrinsics.checkNotNullParameter((Object)resolve, (String)"resolve");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect(qualifier);
            Dbms dbms = dialect.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            DasArgument retArg = target.getReturnArgument();
            if (dbms2.isPostgres()) {
                DataType retType;
                DasArgument dasArgument = retArg;
                DataType dataType = dasArgument != null && (dasArgument = dasArgument.getDasType()) != null ? dasArgument.toDataType() : (retType = null);
                if (retType == null || StringsKt.equals((String)retType.typeName, (String)"record", (boolean)true) || Intrinsics.areEqual((Object)retType.typeName, (Object)"setof") && StringsKt.equals((String)"record", (String)retType.suffix, (boolean)true)) {
                    JBIterable jBIterable = JBIterable.from((Iterable)target.getArguments()).filter(arg_0 -> Companion.createRoutineType$lambda$1(Companion::createRoutineType$lambda$0, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    JBIterable args = jBIterable;
                    if (!args.isEmpty()) {
                        return this.createTypeFromColumns((Iterable)args, qualifier);
                    }
                } else if (Intrinsics.areEqual((Object)retType.typeName, (Object)"setof") && retType.suffix != null) {
                    if (retArg instanceof SqlReturnsClause) {
                        SqlTypeElement typeElement;
                        SqlTypeElement sqlTypeElement = ((SqlReturnsClause)retArg).getTypeElement();
                        if (sqlTypeElement != null) {
                            PsiElement $this$child$iv = (PsiElement)sqlTypeElement;
                            boolean $i$f$child = false;
                            v5 = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlTypeElement.class);
                        } else {
                            v5 = typeElement = null;
                        }
                        if (typeElement != null) {
                            DasType dasType = typeElement.getDasType();
                            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                            return dasType;
                        }
                    }
                    String string = retType.suffix;
                    Intrinsics.checkNotNull((Object)string);
                    DataType dataType2 = DataTypeFactory.of((String)string);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
                    DasType dasType = SqlImplUtil.rebuildDasType(DasUnresolvedTypeReference.Companion.of(dataType2), dialect, qualifier);
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"rebuildDasType(...)");
                    return dasType;
                }
            } else if (dbms2.isMicrosoft() && target.getRoutineKind() == DasRoutine.Kind.FUNCTION && retArg == null) {
                JBIterable jBIterable = target.getDasChildren(ObjectKind.NONE).filter(DasTypedObject.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                return this.createTypeFromColumns((Iterable)jBIterable, qualifier);
            }
            if (retArg == null) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            DasType dasType = this.createType(resolve, retArg, ensureTable, qualifier);
            Intrinsics.checkNotNull((Object)dasType);
            return dasType;
        }

        private final DasType getParamType(SqlElement element) {
            DasType dasType;
            if (element instanceof DasTypeAwareObject) {
                DasType dasType2 = ((DasTypeAwareObject)element).getDasType();
                dasType = dasType2;
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
            } else {
                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            return dasType;
        }

        /*
         * WARNING - void declaration
         */
        private final DasType createTypeFromColumns(Iterable<? extends DasTypedObject> args, PsiElement qualifier) {
            void $this$mapTo$iv$iv;
            Iterable<? extends DasTypedObject> $this$map$iv = args;
            boolean $i$f$map = false;
            Iterable<? extends DasTypedObject> iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p2;
                DasTypedObject dasTypedObject = (DasTypedObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SqlImplUtil.Column(p2.getName(), p2.getDasType(), p2 instanceof PsiElement ? (PsiElement)p2 : (PsiElement)new FakeParameter(qualifier, (DasTypedObject)p2), null));
            }
            List columns = (List)destination$iv$iv;
            SqlTableType sqlTableType = SqlImplUtil.createType(columns, qualifier);
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
            return (DasType)sqlTableType;
        }

        private final DasType createType(PsiElement routine, DasArgument retArg, boolean ensureTable, PsiElement qualifier) {
            DasType dasType = this.getReturnType(routine, retArg);
            if (!Intrinsics.areEqual((Object)dasType, (Object)DasTypeSystemBase.UNKNOWN) && retArg instanceof SqlElement) {
                DasType res;
                DasType dasType2 = res = ensureTable ? (DasType)SqlTableTypeBase.ensureTableType(dasType, (PsiElement)((SqlElement)retArg), qualifier) : dasType;
                if (dasType instanceof SqlTableType) {
                    PsiElement psiElement = routine;
                    String name = psiElement instanceof DasObject ? ((DasNamed)routine).getName() : (psiElement instanceof SqlExpression ? ((SqlExpression)routine).getName() : null);
                    DasType dasType3 = res;
                    Intrinsics.checkNotNull((Object)dasType3, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlTableType");
                    res = (DasType)((SqlTableType)dasType3).alias(name, qualifier, CollectionsKt.emptyList());
                }
                return res;
            }
            if (!ensureTable) {
                return dasType;
            }
            List columns = CollectionsKt.listOf((Object)new SqlImplUtil.Column(retArg.getName(), dasType, (PsiElement)(retArg instanceof PsiElement ? retArg : new FakeParameter(qualifier, (DasTypedObject)retArg)), null));
            return (DasType)SqlImplUtil.createType(columns, qualifier);
        }

        private final DasType getReturnType(PsiElement routine, DasArgument retArg) {
            DasType dasType;
            DasType dasType2 = null;
            Dbms dbms = SqlPsiUtilKt.getSqlDialect(routine).getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if (retArg instanceof SqlTypedDefinition) {
                dasType2 = ((SqlTypedDefinition)retArg).getDasType();
                if (dbms2.isPostgres() && dasType2 instanceof DasSetofType) {
                    return ((DasSetofType)dasType2).getInnerType();
                }
            }
            DataType dataType = retArg.getDasType().toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dataType2 = dataType;
            if (dbms2.isPostgres()) {
                dataType2 = this.trimSetOf(dataType2);
            }
            if ((dasType = dasType2) == null) {
                dasType = this.getDasType(routine, DasUnresolvedTypeReference.Companion.of(dataType2));
            }
            return dasType;
        }

        private final DataType trimSetOf(DataType dataType) {
            DataType dataType2;
            if (Intrinsics.areEqual((Object)dataType.typeName, (Object)"setof") && dataType.suffix != null) {
                String string = dataType.suffix;
                Intrinsics.checkNotNull((Object)string);
                DataType dataType3 = DataTypeFactory.of((String)string);
                dataType2 = dataType3;
                Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"of(...)");
            } else {
                dataType2 = dataType;
            }
            return dataType2;
        }

        private final DasType getDasType(PsiElement routine, DasType dasType) {
            if (Intrinsics.areEqual((Object)dasType, (Object)DasTypeSystemBase.UNKNOWN)) {
                return dasType;
            }
            DasType dasType2 = SqlImplUtil.rebuildDasType(dasType, SqlPsiUtilKt.getSqlDialect(routine), routine);
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"rebuildDasType(...)");
            return dasType2;
        }

        public final boolean processNamedArgument(@Nullable SqlReferenceExpression ref, @Nullable PsiElement place, @NotNull Processor<? super DasSymbol> processor) {
            SqlNamedParameterValueExpression expr;
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            PsiElement psiElement = place;
            PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
            SqlNamedParameterValueExpression sqlNamedParameterValueExpression = expr = psiElement2 instanceof SqlNamedParameterValueExpression ? (SqlNamedParameterValueExpression)psiElement2 : null;
            if (expr != null && Intrinsics.areEqual((Object)place, (Object)expr.getLOperand())) {
                this.processParameters(ref, processor);
                return false;
            }
            return true;
        }

        public final boolean processParameters(@Nullable SqlReferenceExpression fooRef, @NotNull Processor<? super DasSymbol> processor) {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            if (fooRef == null) {
                return true;
            }
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)fooRef);
            Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
            BuiltinFunction definition = dialect.getSupportedFunctions().get(fooRef.getName());
            if (definition != null) {
                BuiltinFunction.Prototype[] prototypeArray = definition.getPrototypes();
                JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> Companion.processParameters$lambda$1(Companion::processParameters$lambda$0, arg_0)).withRoots((Iterable)JBIterable.of((Object[])Arrays.copyOf(prototypeArray, prototypeArray.length)))).filter(BuiltinFunction.SimpleParameter.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                JBIterable params = jBIterable;
                for (BuiltinFunction.SimpleParameter param : params) {
                    String name = casing.apply(param.getName());
                    DasType dasType = param.getType().getDasType();
                    if (dasType == null || processor.process((Object)DasSymbolUtil.createSimpleVariable((SqlElement)fooRef, name, dasType))) continue;
                    return false;
                }
            }
            for (ResolveResult res : fooRef.multiResolve(false)) {
                if (dialect.processNamedArgumentCandidates(DasSymbolUtil.getSymbol(res), processor, fooRef.getProject())) continue;
                return false;
            }
            return true;
        }

        private final Iterable<BuiltinFunction.Parameter> getParameters(BuiltinFunction.Parameter p2) {
            Iterable iterable;
            if (p2 instanceof BuiltinFunction.ParameterBlock) {
                BuiltinFunction.Parameter[] parameterArray = ((BuiltinFunction.ParameterBlock)p2).getParams();
                JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(parameterArray, parameterArray.length));
                Intrinsics.checkNotNull((Object)jBIterable);
                iterable = (Iterable)jBIterable;
            } else {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNull((Object)jBIterable);
                iterable = (Iterable)jBIterable;
            }
            return iterable;
        }

        private static final DasType resolveBuiltinDasType$lambda$0(List $parameters, SqlLanguageDialectEx $dialect, DasType it) {
            if (!(it instanceof DasBuiltinParamType)) {
                return it;
            }
            int index = ((DasBuiltinParamType)it).getIndex();
            if (index > 0 && index <= $parameters.size()) {
                return Companion.getParamType((SqlElement)$parameters.get(index - 1));
            }
            if (index == 0) {
                return Companion.getP0Type($dialect, $parameters);
            }
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }

        private static final boolean createRoutineType$lambda$0(DasArgument it) {
            return it.getArgumentDirection().isOut();
        }

        private static final boolean createRoutineType$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Iterable processParameters$lambda$0(BuiltinFunction.Parameter it) {
            Intrinsics.checkNotNull((Object)it);
            return Companion.getParameters(it);
        }

        private static final Iterable processParameters$lambda$1(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter;", "Lcom/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition;", "Lcom/intellij/database/model/DasTypedObject;", "myParent", "Lcom/intellij/psi/PsiElement;", "name", "", "myDelegate", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/database/model/DasTypedObject;)V", "parent", "parameter", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/database/model/DasTypedObject;)V", "getDasType", "Lcom/intellij/database/types/DasType;", "isNotNull", "", "getDefault", "isNameQuoted", "getTextOffset", "", "getKind", "Lcom/intellij/database/model/ObjectKind;", "getTypeName", "getIcon", "Ljavax/swing/Icon;", "intellij.database.sql.core.impl"})
    public static final class FakeParameter
    extends SqlFileImpl.FakeDefinition
    implements DasTypedObject {
        @NotNull
        private final PsiElement myParent;
        @Nullable
        private final DasTypedObject myDelegate;

        public FakeParameter(@NotNull PsiElement myParent, @NotNull String name, @Nullable DasTypedObject myDelegate) {
            Intrinsics.checkNotNullParameter((Object)myParent, (String)"myParent");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(myParent, name);
            this.myParent = myParent;
            this.myDelegate = myDelegate;
        }

        public FakeParameter(@NotNull PsiElement parent, @NotNull DasTypedObject parameter) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            String string = parameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this(parent, string, parameter);
        }

        @NotNull
        public DasType getDasType() {
            DasTypedObject dasTypedObject = this.myDelegate;
            if (dasTypedObject == null || (dasTypedObject = dasTypedObject.getDasType()) == null) {
                dasTypedObject = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            return dasTypedObject;
        }

        public boolean isNotNull() {
            return this.myDelegate != null && this.myDelegate.isNotNull();
        }

        @Nullable
        public String getDefault() {
            DasTypedObject dasTypedObject = this.myDelegate;
            return dasTypedObject != null ? dasTypedObject.getDefault() : null;
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted((DasObject)((DasObject)this.myDelegate));
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ARGUMENT");
            return objectKind;
        }

        @Override
        @Nullable
        public String getTypeName() {
            if (this.myDelegate != null) {
                SqlLanguageDialectEx sqlDialect = SqlPsiUtilKt.getSqlDialect(this.getParent());
                DatabaseDialectEx databaseDialectEx = sqlDialect.getDatabaseDialect();
                Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
                DatabaseDialectEx dbDialect = databaseDialectEx;
                return new DdlBuilder().applyCodeStyle(this.getProject(), (SqlLanguageDialect)sqlDialect).withDialect(dbDialect).type(this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = DatabaseIcons.Col;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Col");
            return icon;
        }
    }
}

