/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPivotColumnDefinition;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0014J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0014J%\u0010\u0010\u001a\u00020\n2\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u0012\"\u0004\u0018\u00010\fH\u0004\u00a2\u0006\u0002\u0010\u0013J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0002H\u0014J\u001a\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010'H\u0014J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0002H\u0002R\u0014\u0010\u0014\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0016\u0010#\u001a\u0004\u0018\u00010\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lcom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionImpl;", "Lcom/intellij/sql/psi/SqlExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "computeDasType", "Lcom/intellij/database/types/DasType;", "getPivotedType", "Lcom/intellij/sql/psi/SqlTableType;", "columnsClause", "Lcom/intellij/sql/psi/SqlClause;", "forClause", "inClause", "getRestType", "getRestTypeImpl", "clauses", "", "([Lcom/intellij/sql/psi/SqlClause;)Lcom/intellij/sql/psi/SqlTableType;", "pivotedExpressionType", "getPivotedExpressionType", "()Lcom/intellij/sql/psi/SqlTableType;", "getColumnsClause", "()Lcom/intellij/sql/psi/SqlClause;", "getInClause", "processDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "pivotedExpression", "getPivotedExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "getSimpleFakeColumnName", "", "column", "getFullFakeColumnName", "columnName", "valueName", "createFakeColumnDefinition", "Lcom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$MyFakeDefinition;", "parent", "value", "MyFakeDefinition", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlPivotedQueryExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlPivotedQueryExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,178:1\n279#2:179\n275#2:182\n281#2:183\n275#2:184\n455#3:180\n455#3:181\n*S KotlinDebug\n*F\n+ 1 SqlPivotedQueryExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl\n*L\n26#1:179\n89#1:182\n95#1:183\n113#1:184\n39#1:180\n40#1:181\n*E\n"})
public class SqlPivotedQueryExpressionImpl
extends SqlExpressionImpl
implements SqlExpression {
    public SqlPivotedQueryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        SqlClause sqlClause;
        SqlClause columnsClause;
        SqlClause sqlClause2 = columnsClause = this.getColumnsClause();
        if (sqlClause2 != null) {
            PsiElement $this$nextSibling$iv = (PsiElement)sqlClause2;
            boolean $i$f$nextSibling = false;
            sqlClause = (SqlClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSibling$iv, SqlClause.class);
        } else {
            sqlClause = null;
        }
        SqlClause forClause = sqlClause;
        SqlClause inClause = this.getInClause();
        if (forClause == null || inClause == null) {
            return (DasType)this.getPivotedExpressionType();
        }
        SqlTableType pivotedType = this.getPivotedType(columnsClause, forClause, inClause);
        SqlTableType restType = this.getRestType(columnsClause, forClause, inClause).alias(null, (PsiElement)this, CollectionsKt.emptyList());
        SqlTableType sqlTableType = restType.add(pivotedType);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"add(...)");
        return (DasType)sqlTableType;
    }

    @NotNull
    protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        Intrinsics.checkNotNullParameter((Object)columnsClause, (String)"columnsClause");
        Intrinsics.checkNotNullParameter((Object)forClause, (String)"forClause");
        Intrinsics.checkNotNullParameter((Object)inClause, (String)"inClause");
        PsiElement $this$childrenOfType$iv = (PsiElement)columnsClause;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        List values = list;
        PsiElement $this$childrenOfType$iv2 = (PsiElement)inClause;
        boolean $i$f$childrenOfType2 = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv2, SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        List columns = list2;
        if (values.isEmpty()) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return sqlTableType;
        }
        ArrayList<Object> result = new ArrayList<Object>(values.size() * columns.size());
        for (PsiElement element : SqlImplUtil.sqlChildren((PsiElement)inClause)) {
            PsiElement psiElement = element;
            if (psiElement instanceof SqlPivotColumnDefinition) {
                result.add(element);
                continue;
            }
            if (!(psiElement instanceof SqlExpression)) continue;
            for (SqlExpression value : values) {
                result.add((Object)this.createFakeColumnDefinition((PsiElement)this, value, (SqlExpression)element));
            }
        }
        if (result.isEmpty()) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return sqlTableType;
        }
        return new TableBasedSqlTableTypeImpl((List)result, (PsiElement)this);
    }

    @NotNull
    protected SqlTableType getRestType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        Intrinsics.checkNotNullParameter((Object)columnsClause, (String)"columnsClause");
        Intrinsics.checkNotNullParameter((Object)forClause, (String)"forClause");
        Intrinsics.checkNotNullParameter((Object)inClause, (String)"inClause");
        SqlClause[] sqlClauseArray = new SqlClause[]{columnsClause, forClause};
        return this.getRestTypeImpl(sqlClauseArray);
    }

    @NotNull
    protected final SqlTableType getRestTypeImpl(SqlClause ... clauses) {
        Intrinsics.checkNotNullParameter((Object)clauses, (String)"clauses");
        SqlTableType pivotedType = this.getPivotedExpressionType();
        if (Intrinsics.areEqual((Object)pivotedType, (Object)SqlTableTypeBase.EMPTY_TABLE)) {
            return pivotedType;
        }
        LinkedHashSet toSubtract = new LinkedHashSet();
        for (SqlReferenceExpression ref : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)JBIterable.of((Object[])Arrays.copyOf(clauses, clauses.length)))).filter(SqlReferenceExpression.class)) {
            if (SqlImplUtil.isAsteriskRef((PsiElement)ref) || !Intrinsics.areEqual((Object)ref.getReferenceElementType().getTargetKind(), (Object)ObjectKind.COLUMN)) continue;
            for (ResolveResult result : ref.multiResolve(false)) {
                ContainerUtil.addIfNotNull((Collection)toSubtract, (Object)result.getElement());
            }
        }
        Iterator iterator = toSubtract.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PsiElement element = (PsiElement)e;
            Intrinsics.checkNotNullExpressionValue((Object)pivotedType.subtract(element), (String)"subtract(...)");
        }
        return pivotedType;
    }

    private final SqlTableType getPivotedExpressionType() {
        SqlExpression sqlExpression = this.getPivotedExpression();
        if (sqlExpression == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return sqlTableType;
        }
        SqlExpression expression = sqlExpression;
        DasType dasType = expression.getDasType();
        SqlTableType sqlTableType = dasType instanceof SqlTableType ? (SqlTableType)dasType : null;
        if (sqlTableType == null) {
            SqlTableType sqlTableType2 = SqlTableTypeBase.EMPTY_TABLE;
            sqlTableType = sqlTableType2;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType2, (String)"EMPTY_TABLE");
        }
        return sqlTableType;
    }

    @Nullable
    public final SqlClause getColumnsClause() {
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        return (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlClause.class);
    }

    @Nullable
    public final SqlClause getInClause() {
        PsiElement child = this.getLastChild();
        if (child == null || child instanceof SqlClause) {
            return (SqlClause)child;
        }
        PsiElement $this$prevSibling$iv = child;
        boolean $i$f$prevSibling = false;
        return (SqlClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)$this$prevSibling$iv, SqlClause.class);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        SqlExpression expression = this.getPivotedExpression();
        if ((lastParent == null || Intrinsics.areEqual((Object)lastParent.getContext(), (Object)((Object)this)) && !PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)expression), (PsiElement)place, (boolean)false)) && expression != null && !SqlImplUtil.processDeclarationsInType(expression, processor, state, place)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private final SqlExpression getPivotedExpression() {
        PsiElement $this$child$iv = (PsiElement)this;
        boolean $i$f$child = false;
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlExpression.class);
    }

    @Nullable
    protected String getSimpleFakeColumnName(@NotNull SqlExpression column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return column.getName();
    }

    @NotNull
    protected String getFullFakeColumnName(@NotNull String columnName, @Nullable String valueName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        String string = valueName;
        return string != null ? columnName + "_" + string : columnName;
    }

    private final MyFakeDefinition createFakeColumnDefinition(PsiElement parent, SqlExpression value, SqlExpression column) {
        String vName;
        boolean columnQuoted = DbSqlUtilCore.isQuoted((DasObject)(column instanceof DasObject ? (DasObject)column : null));
        boolean valueQuoted = DbSqlUtilCore.isQuoted((DasObject)(value instanceof DasObject ? (DasObject)value : null));
        String cName = this.getSimpleFakeColumnName(column);
        String string = vName = value instanceof DasObject ? ((DasNamed)value).getName() : null;
        if (valueQuoted != columnQuoted) {
            Casing casing = SqlPsiUtilKt.getSqlDialect(parent).getCasing(ObjectKind.COLUMN, null);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
            Casing casing2 = casing;
            if (casing2.quoted == Case.EXACT) {
                if (!columnQuoted) {
                    cName = casing2.plain.apply(cName);
                }
                if (!valueQuoted) {
                    vName = casing2.plain.apply(vName);
                }
            }
        }
        String string2 = cName;
        String name = string2 == null ? cName : this.getFullFakeColumnName(string2, vName);
        return new MyFakeDefinition(parent, name, columnQuoted || valueQuoted, value, column);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$MyFakeDefinition;", "Lcom/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition;", "Lcom/intellij/sql/psi/SqlTypedDefinition;", "parent", "Lcom/intellij/psi/PsiElement;", "name", "", "myQuoted", "", "myValue", "Lcom/intellij/sql/psi/SqlExpression;", "myColumn", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;ZLcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlExpression;)V", "getDbms", "Lcom/intellij/database/Dbms;", "isNameQuoted", "getKind", "Lcom/intellij/database/model/ObjectKind;", "getNavigationElement", "getTypeElement", "Lcom/intellij/sql/psi/SqlTypeElement;", "getDasType", "Lcom/intellij/database/types/DasType;", "isNotNull", "getDefault", "intellij.database.sql.core.impl"})
    private static final class MyFakeDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        private final boolean myQuoted;
        @NotNull
        private final SqlExpression myValue;
        @NotNull
        private final SqlExpression myColumn;

        public MyFakeDefinition(@NotNull PsiElement parent, @Nullable String name, boolean myQuoted, @NotNull SqlExpression myValue, @NotNull SqlExpression myColumn) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)myValue, (String)"myValue");
            Intrinsics.checkNotNullParameter((Object)myColumn, (String)"myColumn");
            String string = name;
            if (string == null) {
                string = "";
            }
            super(parent, string);
            this.myQuoted = myQuoted;
            this.myValue = myValue;
            this.myColumn = myColumn;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = super.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            return dbms;
        }

        public boolean isNameQuoted() {
            return this.myQuoted;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            return objectKind;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return (PsiElement)this.myColumn;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myValue.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }
    }
}

