/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.icons.CustomIconUtilKt;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H$J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH$J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH$J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J*\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/intellij/ui/icons/HoledIcon;", "Lcom/intellij/util/ui/JBScalableIcon;", "Lcom/intellij/ui/icons/ReplaceableIcon;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "copyWith", "createHole", "Ljava/awt/Shape;", "width", "", "height", "paintHole", "", "g", "Ljava/awt/Graphics2D;", "getScale", "", "scale", "factor", "getIconWidth", "getIconHeight", "paintIcon", "c", "Ljava/awt/Component;", "graphics", "Ljava/awt/Graphics;", "x", "y", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public abstract class HoledIcon
extends JBScalableIcon
implements ReplaceableIcon {
    @NotNull
    private final Icon icon;

    public HoledIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.icon = icon;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected abstract Icon copyWith(@NotNull Icon var1);

    @Nullable
    protected abstract Shape createHole(int var1, int var2);

    protected abstract void paintHole(@NotNull Graphics2D var1, int var2, int var3);

    public float getScale() {
        Icon icon = this.icon;
        ScalableIcon scalableIcon = icon instanceof ScalableIcon ? (ScalableIcon)icon : null;
        return scalableIcon != null ? scalableIcon.getScale() : 1.0f;
    }

    @NotNull
    public Icon scale(float factor) {
        return this.copyWith(CustomIconUtilKt.scaleIconOrLoadCustomVersion(this.icon, factor));
    }

    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(@Nullable Component c, @NotNull Graphics graphics, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        Graphics g = graphics.create(x, y, width, height);
        try {
            Shape hole = this.createHole(width, height);
            if (hole != null) {
                Shape area = g.getClip();
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    ((Graphics2D)g).setClip(hole);
                    this.paintHole((Graphics2D)g, width, height);
                    ((Graphics2D)g).clip(hole);
                }
                Path2D.Float path = new Path2D.Float(0);
                path.append(area, false);
                path.append(hole, false);
                g.setClip(path);
            }
            this.icon.paintIcon(c, g, 0, 0);
        }
        finally {
            g.dispose();
        }
    }
}

