/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplocatorSettingsDialog
extends DialogWrapper {
    private final Map<String, DuplocatorSettingsEditor> myEditors;
    private JPanel myLangDependentSettingsPanel;
    private JPanel myContentPanel;
    private JPanel myLangListPanel;
    private final CheckBoxList myLangList;
    private final List<Pair<Language, DuplicatesProfile>> myLanguagesAndProfiles;

    DuplocatorSettingsDialog(@NotNull Project project, @NotNull List<DuplicatesProfile> profiles, @NotNull AnalysisScope scope) {
        Set<String> set;
        if (project == null) {
            DuplocatorSettingsDialog.h(0);
        }
        if (profiles == null) {
            DuplocatorSettingsDialog.h(1);
        }
        if (scope == null) {
            DuplocatorSettingsDialog.h(2);
        }
        super(project, true);
        this.h();
        this.myEditors = new HashMap<String, DuplocatorSettingsEditor>();
        this.myLanguagesAndProfiles = new ArrayList<Pair<Language, DuplicatesProfile>>();
        assert (!profiles.isEmpty());
        this.setTitle(DupLocatorBundle.message((String)"duplicate.dialog.title", (Object[])new Object[0]));
        this.myLangList = new CheckBoxList();
        this.myLangList.setBorder((Border)JBUI.Borders.empty());
        DuplocatorSettings duplocatorSettings = DuplocatorSettings.getInstance();
        DefaultListModel defaultListModel = (DefaultListModel)this.myLangList.getModel();
        int n2 = -1;
        int n3 = 0;
        this.myLangList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                DuplocatorSettingsDialog.this.b();
            }
        });
        this.myLangList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                DuplocatorSettingsDialog.this.B();
            }
        });
        ArrayList<Language> arrayList = new ArrayList<Language>(DuplocatorSettingsDialog.getLanguages());
        arrayList.sort(LanguageUtil.LANGUAGE_COMPARATOR);
        List<Pair<Language, DuplicatesPresentation>> list = DuplocatorSettingsDialog.h(arrayList);
        Set<Object> object2 = new HashSet<String>();
        for (Pair<Language, DuplicatesPresentation> object3 : list) {
            String string = ((Language)object3.getFirst()).getDisplayName();
            if (!duplocatorSettings.SELECTED_PROFILES.contains(string)) continue;
            object2.add(string);
        }
        SearchScope searchScope = scope.toSearchScope();
        if (searchScope instanceof LocalSearchScope && SetUtil.intersect(object2, set = DuplocatorSettingsDialog.h((LocalSearchScope)searchScope)).isEmpty()) {
            object2 = set;
        }
        for (Pair<Language, DuplicatesPresentation> pair : list) {
            Language language = (Language)pair.getFirst();
            DuplicatesPresentation duplicatesPresentation = (DuplicatesPresentation)pair.getSecond();
            String string = language.getDisplayName();
            DuplocatorSettingsEditor duplocatorSettingsEditor = duplicatesPresentation.createEditor(duplicatesPresentation.getProfile().getDuplocatorState(language));
            this.h(string, duplocatorSettingsEditor);
            boolean bl2 = object2.contains(string);
            this.myLanguagesAndProfiles.add((Pair<Language, DuplicatesProfile>)Pair.create((Object)language, (Object)duplicatesPresentation.getProfile()));
            JCheckBox jCheckBox = new JCheckBox(string, bl2);
            defaultListModel.addElement(jCheckBox);
            if (bl2 && (n2 == -1 || string.equals(duplocatorSettings.LAST_SELECTED_LANGUAGE))) {
                n2 = n3;
            }
            ++n3;
        }
        this.myLangListPanel.add((Component)new JBScrollPane((Component)this.myLangList));
        if (n2 == -1) {
            n2 = 0;
        }
        this.myLangList.setSelectedIndex(n2);
        UIUtil.scrollListToVisibleIfNeeded((JList)this.myLangList);
        if (profiles.size() == 1) {
            this.myLangListPanel.setVisible(false);
        }
        this.b();
        this.B();
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLangList;
    }

    @NotNull
    public static Set<Language> getLanguages() {
        HashSet<Language> hashSet = new HashSet<Language>();
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType)) continue;
            Language language = ((LanguageFileType)fileType).getLanguage();
            hashSet.add(language);
        }
        HashSet<Language> hashSet2 = hashSet;
        if (hashSet2 == null) {
            DuplocatorSettingsDialog.h(3);
        }
        return hashSet2;
    }

    @NotNull
    private static List<Pair<Language, DuplicatesPresentation>> h(@NotNull Collection<Language> collection) {
        if (collection == null) {
            DuplocatorSettingsDialog.h(4);
        }
        ArrayList<Pair<Language, DuplicatesPresentation>> arrayList = new ArrayList<Pair<Language, DuplicatesPresentation>>();
        for (Language language : collection) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentation.Service.findPresentationForLanguage(language);
            if (duplicatesPresentation == null) continue;
            arrayList.add((Pair<Language, DuplicatesPresentation>)Pair.create((Object)language, (Object)duplicatesPresentation));
        }
        ArrayList<Pair<Language, DuplicatesPresentation>> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DuplocatorSettingsDialog.h(5);
        }
        return arrayList2;
    }

    @NotNull
    private static Set<String> h(@NotNull LocalSearchScope localSearchScope) {
        if (localSearchScope == null) {
            DuplocatorSettingsDialog.h(6);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PsiElement psiElement : localSearchScope.getScope()) {
            hashSet.add(psiElement.getLanguage().getDisplayName());
        }
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            DuplocatorSettingsDialog.h(7);
        }
        return hashSet2;
    }

    private void B() {
        this.setOKActionEnabled(!this.getAllSelectedLanguages().isEmpty());
    }

    private void b() {
        DuplocatorSettingsEditor duplocatorSettingsEditor;
        String string;
        JCheckBox jCheckBox = (JCheckBox)this.myLangList.getSelectedValue();
        if (jCheckBox != null && (string = jCheckBox.getText()) != null && (duplocatorSettingsEditor = this.myEditors.get(string)) != null) {
            this.myLangDependentSettingsPanel.setVisible(true);
            CardLayout cardLayout = (CardLayout)this.myLangDependentSettingsPanel.getLayout();
            cardLayout.show(this.myLangDependentSettingsPanel, string);
            return;
        }
        this.myLangDependentSettingsPanel.setVisible(false);
    }

    private void h(@NlsContexts.BorderTitle String string, DuplocatorSettingsEditor duplocatorSettingsEditor) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.myEditors.put(string, duplocatorSettingsEditor);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)string, (boolean)false));
        jPanel.add(duplocatorSettingsEditor.getComponent());
        this.myLangDependentSettingsPanel.add((Component)jPanel, string);
    }

    @NotNull
    public List<DuplicatesProfile> getAllSelectedProfiles() {
        ArrayList<DuplicatesProfile> arrayList = new ArrayList<DuplicatesProfile>();
        for (int i10 = 0; i10 < this.myLanguagesAndProfiles.size(); ++i10) {
            if (!this.myLangList.isItemSelected(i10)) continue;
            arrayList.add((DuplicatesProfile)this.myLanguagesAndProfiles.get((int)i10).second);
        }
        ArrayList<DuplicatesProfile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DuplocatorSettingsDialog.h(8);
        }
        return arrayList2;
    }

    public List<Language> getAllSelectedLanguages() {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        for (int i10 = 0; i10 < this.myLanguagesAndProfiles.size(); ++i10) {
            if (!this.myLangList.isItemSelected(i10)) continue;
            arrayList.add((Language)this.myLanguagesAndProfiles.get((int)i10).first);
        }
        return arrayList;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        Language language;
        DuplocatorSettings duplocatorSettings = DuplocatorSettings.getInstance();
        duplocatorSettings.SELECTED_PROFILES.clear();
        for (Language object2 : this.getAllSelectedLanguages()) {
            duplocatorSettings.SELECTED_PROFILES.add(object2.getDisplayName());
        }
        int n2 = this.myLangList.getSelectedIndex();
        if (n2 >= 0 && n2 < this.myLanguagesAndProfiles.size() && (language = (Language)this.myLanguagesAndProfiles.get((int)n2).first) != null) {
            duplocatorSettings.LAST_SELECTED_LANGUAGE = language.getDisplayName();
        }
        for (DuplocatorSettingsEditor duplocatorSettingsEditor : this.myEditors.values()) {
            duplocatorSettingsEditor.apply();
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "reference.dialogs.locateDuplicates.settings";
    }

    private static /* synthetic */ void h(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 5, 7, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplocatorSettingsDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplocatorSettingsDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationsForSupportedLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesFromScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSelectedProfiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationsForSupportedLanguages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesFromScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void h() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLangListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, null, null));
        this.myLangDependentSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

