/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.core;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.Stack;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.LighterAstNodeHashCache;
import com.jetbrains.clones.core.NodeInfo;
import com.jetbrains.clones.core.NodeState;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.structures.CodeFragment;
import com.jetbrains.clones.structures.HashFragment;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/clones/core/HashFragmentCollector;", "", "ast", "Lcom/intellij/lang/LighterAST;", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "HashFragmentCollector", "(Lcom/intellij/lang/LighterAST;Lcom/jetbrains/clones/languagescope/DuplicateScope;)V", "getAst", "()Lcom/intellij/lang/LighterAST;", "getScope", "()Lcom/jetbrains/clones/languagescope/DuplicateScope;", "stack", "Lcom/intellij/util/containers/Stack;", "Lcom/jetbrains/clones/core/NodeState;", "collector", "", "Lcom/jetbrains/clones/structures/HashFragment;", "cache", "Lcom/jetbrains/clones/core/LighterAstNodeHashCache;", "windowSize", "", "nextNodeId", "h", "h", "", "nodeInfo", "Lcom/jetbrains/clones/core/NodeInfo;", "children", "", "h", "node", "Lcom/intellij/lang/LighterASTNode;", "h", "traverse", "getCollectedFragments", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nHashFragmentCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashFragmentCollector.kt\ncom/jetbrains/clones/core/HashFragmentCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1915#2:110\n1915#2,2:111\n1916#2:113\n1915#2,2:114\n1#3:116\n*S KotlinDebug\n*F\n+ 1 HashFragmentCollector.kt\ncom/jetbrains/clones/core/HashFragmentCollector\n*L\n50#1:110\n52#1:111,2\n50#1:113\n66#1:114,2\n*E\n"})
final class HashFragmentCollector {
    @NotNull
    private final LighterAST ast;
    @NotNull
    private final DuplicateScope scope;
    @NotNull
    private final Stack<NodeState> stack;
    @NotNull
    private final List<HashFragment> collector;
    @NotNull
    private final LighterAstNodeHashCache cache;
    private final int windowSize;
    private int nextNodeId;

    public HashFragmentCollector(@NotNull LighterAST ast, @NotNull DuplicateScope scope) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.ast = ast;
        this.scope = scope;
        this.stack = new Stack();
        this.collector = new ArrayList();
        this.cache = new LighterAstNodeHashCache();
        this.windowSize = this.scope.getIndexConfiguration().getWindowSize();
        this.nextNodeId = 1;
    }

    @NotNull
    public final LighterAST getAst() {
        return this.ast;
    }

    @NotNull
    public final DuplicateScope getScope() {
        return this.scope;
    }

    private final int h() {
        int n2 = this.nextNodeId;
        this.nextNodeId = n2 + 1;
        return n2;
    }

    private final void h(NodeInfo nodeInfo, List<NodeInfo> list) {
        LighterASTNode lighterASTNode = nodeInfo.getNode();
        if (nodeInfo.getWeight() >= this.windowSize) {
            Object object;
            if (!this.scope.isIgnoredAsDuplicate(this.ast, lighterASTNode)) {
                TextRange textRange = new TextRange(lighterASTNode.getStartOffset(), lighterASTNode.getEndOffset());
                object = new HashFragment(nodeInfo.getHash(), CodeFragment.Companion.of(textRange));
                this.collector.add((HashFragment)object);
            }
            if (this.scope.shouldAnalyzeChildSubsequences(this.ast, lighterASTNode)) {
                int n2 = this.h();
                object = CollectionsKt.toList((Iterable)CollectionsKt.withIndex((Iterable)list));
                List list2 = CommonUtilsKt.weightedWindow(object, this.windowSize, HashFragmentCollector::h);
                Iterable iterable = list2;
                boolean bl2 = false;
                for (Object t2 : iterable) {
                    Object object22;
                    List list3 = (List)t2;
                    boolean bl3 = false;
                    long l2 = 0L;
                    Iterable iterable2 = list3;
                    boolean bl4 = false;
                    for (Object object22 : iterable2) {
                        IndexedValue indexedValue = (IndexedValue)object22;
                        boolean bl5 = false;
                        l2 = (long)37 * l2 + ((NodeInfo)indexedValue.getValue()).getHash();
                    }
                    iterable2 = (IndexedValue)CollectionsKt.first((List)list3);
                    IndexedValue indexedValue = (IndexedValue)CollectionsKt.last((List)list3);
                    TextRange textRange = new TextRange(((NodeInfo)iterable2.getValue()).getNode().getStartOffset(), ((NodeInfo)indexedValue.getValue()).getNode().getEndOffset());
                    object22 = CodeFragment.Companion.of(n2, new IntRange(iterable2.getIndex(), indexedValue.getIndex()), textRange);
                    this.collector.add(new HashFragment(l2, (CodeFragment)object22));
                }
            }
        }
    }

    private final NodeState h(LighterASTNode lighterASTNode) {
        List list = this.ast.getChildren(lighterASTNode);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        List list2 = list;
        ArrayDeque<LighterASTNode> arrayDeque = new ArrayDeque<LighterASTNode>(list2.size());
        Iterable iterable = list2;
        boolean bl2 = false;
        for (Object t2 : iterable) {
            LighterASTNode lighterASTNode2 = (LighterASTNode)t2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)lighterASTNode2);
            if (this.scope.isNoise(this.ast, lighterASTNode2)) continue;
            arrayDeque.addLast(lighterASTNode2);
        }
        return new NodeState(lighterASTNode, new ArrayList(list2.size()), (Deque<LighterASTNode>)arrayDeque);
    }

    private final void h() {
        NodeState nodeState = (NodeState)this.stack.pop();
        if (!nodeState.getUnprocessedChildren().isEmpty()) {
            LighterASTNode lighterASTNode = nodeState.getUnprocessedChildren().removeFirst();
            if (lighterASTNode instanceof LighterASTTokenNode) {
                long l2 = this.scope.hashOf(this.cache, this.ast, lighterASTNode, CollectionsKt.emptyList());
                int n2 = this.scope.weightOf(this.ast, lighterASTNode);
                nodeState.getProcessedChildren().add(new NodeInfo(lighterASTNode, l2, n2));
                this.stack.push((Object)nodeState);
            } else {
                this.stack.push((Object)nodeState);
                Intrinsics.checkNotNull((Object)lighterASTNode);
                this.stack.push((Object)this.h(lighterASTNode));
            }
        } else {
            int n3;
            long l3 = this.scope.hashOf(this.cache, this.ast, nodeState.getNode(), nodeState.getProcessedChildren());
            Object object = nodeState.getProcessedChildren();
            int n4 = this.scope.weightOf(this.ast, nodeState.getNode());
            int n5 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                NodeInfo nodeInfo = (NodeInfo)t2;
                n3 = n5;
                boolean bl2 = false;
                int n6 = nodeInfo.getWeight();
                n5 = n3 + n6;
            }
            n3 = n5;
            int n7 = n4 + n3;
            object = new NodeInfo(nodeState.getNode(), l3, n7);
            this.h((NodeInfo)object, nodeState.getProcessedChildren());
            if (!((Collection)this.stack).isEmpty()) {
                NodeState nodeState2 = (NodeState)this.stack.pop();
                nodeState2.getProcessedChildren().add((NodeInfo)object);
                this.stack.push((Object)nodeState2);
            }
        }
    }

    public final void traverse(@NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.stack.push((Object)this.h(node));
        while (!((Collection)this.stack).isEmpty()) {
            this.h();
        }
    }

    @NotNull
    public final List<HashFragment> getCollectedFragments() {
        return this.collector;
    }

    private static final int h(IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"it");
        return ((NodeInfo)indexedValue.getValue()).getWeight();
    }
}

