/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.structures.TextFragment;
import com.jetbrains.clones.toolwindow.DiffController;
import com.jetbrains.clones.toolwindow.DuplicateInfo;
import com.jetbrains.clones.toolwindow.DuplicateNavigator;
import com.jetbrains.clones.toolwindow.RowPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/clones/toolwindow/DuplicatesList;", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/clones/toolwindow/DuplicateInfo;", "Lcom/intellij/openapi/Disposable;", "duplicates", "", "Lcom/jetbrains/clones/structures/TextFragment;", "diffController", "Lcom/jetbrains/clones/toolwindow/DiffController;", "DuplicatesList", "(Ljava/util/List;Lcom/jetbrains/clones/toolwindow/DiffController;)V", "rowPanel", "Lcom/jetbrains/clones/toolwindow/RowPanel;", "mouseRow", "", "Ljava/lang/Integer;", "mouseRowPosition", "Ljava/awt/Point;", "mainFragmentHighlighter", "Lcom/jetbrains/clones/toolwindow/DuplicateNavigator;", "navigatedFragmentHighlighter", "h", "duplicate", "showFullPath", "", "h", "", "basePath", "path", "h", "point", "row", "getCellRenderer", "Ljavax/swing/ListCellRenderer;", "dispose", "", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicatesList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1696#2,8:213\n1696#2,8:221\n1642#2,10:229\n1915#2:239\n1916#2:241\n1652#2:242\n1#3:240\n1#3:243\n*S KotlinDebug\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicatesList\n*L\n97#1:213,8\n98#1:221,8\n100#1:229,10\n100#1:239\n100#1:241\n100#1:242\n100#1:240\n*E\n"})
public final class DuplicatesList
extends JBList<DuplicateInfo>
implements Disposable {
    @NotNull
    private final DiffController diffController;
    @NotNull
    private final RowPanel rowPanel;
    @Nullable
    private Integer mouseRow;
    @Nullable
    private Point mouseRowPosition;
    @NotNull
    private final DuplicateNavigator mainFragmentHighlighter;
    @NotNull
    private final DuplicateNavigator navigatedFragmentHighlighter;

    public DuplicatesList(@NotNull List<TextFragment> duplicates, @NotNull DiffController diffController) {
        Object object3;
        Object object22;
        Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
        Intrinsics.checkNotNullParameter((Object)diffController, (String)"diffController");
        this.diffController = diffController;
        this.rowPanel = new RowPanel();
        this.mainFragmentHighlighter = new DuplicateNavigator(this.diffController.getProject());
        this.navigatedFragmentHighlighter = new DuplicateNavigator(this.diffController.getProject());
        Iterable iterable = duplicates;
        boolean bl2 = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterable iterable2 = new ArrayList();
        for (Object object22 : iterable) {
            object3 = (TextFragment)object22;
            boolean bl3 = false;
            if (!hashSet.add(object3 = ((TextFragment)object3).getFile().getPath())) continue;
            iterable2.add(object22);
        }
        int n2 = ((Collection)iterable2).size();
        Iterable iterable3 = duplicates;
        boolean bl4 = false;
        iterable2 = new HashSet();
        ArrayList arrayList = new ArrayList();
        for (Object object3 : iterable3) {
            Object object4 = (TextFragment)object3;
            boolean bl5 = false;
            if (!((HashSet)iterable2).add(object4 = ((TextFragment)object4).getFile().getPresentableName())) continue;
            arrayList.add(object3);
        }
        int n3 = ((Collection)arrayList).size();
        boolean bl6 = n2 != n3;
        iterable2 = duplicates;
        boolean bl7 = false;
        object22 = iterable2;
        object3 = new ArrayList();
        boolean bl8 = false;
        Object object5 = object22;
        boolean bl9 = false;
        Iterator iterator = object5.iterator();
        while (iterator.hasNext()) {
            DuplicateInfo duplicateInfo;
            Object t2;
            Object t3 = t2 = iterator.next();
            boolean bl10 = false;
            TextFragment textFragment = (TextFragment)t3;
            boolean bl11 = false;
            if (this.h(textFragment, bl6) == null) continue;
            boolean bl12 = false;
            object3.add(duplicateInfo);
        }
        List list = (List)object3;
        this.setModel(JBList.createDefaultListModel((Iterable)list));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                int n2 = this.locationToIndex(e10.getPoint());
                if (e10.getClickCount() == 2) {
                    navigatedFragmentHighlighter.highlightAndNavigate(((DuplicateInfo)this.getModel().getElementAt(n2)).getRange());
                } else {
                    Point point = e10.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    Point point2 = this.h(point, n2);
                    DuplicateInfo duplicateInfo = (DuplicateInfo)this.getModel().getElementAt(n2);
                    if (rowPanel.getLeftButton().getBounds().contains(point2)) {
                        diffController.setLeft(duplicateInfo.getRange(), duplicateInfo.getDescription());
                    }
                    if (rowPanel.getRightButton().getBounds().contains(point2)) {
                        diffController.setRight(duplicateInfo.getRange(), duplicateInfo.getDescription());
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e10) {
                mouseRow = null;
                mouseRowPosition = null;
                this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                int n2 = this.locationToIndex(e10.getPoint());
                mouseRow = n2;
                Point point = e10.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                mouseRowPosition = this.h(point, n2);
                this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                if (e10.getKeyCode() == 10) {
                    DuplicateInfo duplicateInfo = (DuplicateInfo)this.getSelectedValue();
                    navigatedFragmentHighlighter.highlightAndNavigate((RangeMarker)(duplicateInfo != null ? duplicateInfo.getRange() : null));
                }
            }
        });
        this.setSelectionMode(0);
        if (this.getModel().getSize() >= 2) {
            this.setSelectedIndex(0);
            DuplicateInfo duplicateInfo = (DuplicateInfo)this.getModel().getElementAt(0);
            boolean bl13 = false;
            this.mainFragmentHighlighter.highlightAndNavigate(duplicateInfo.getRange());
            this.diffController.setLeft(duplicateInfo.getRange(), duplicateInfo.getDescription());
            duplicateInfo = (DuplicateInfo)this.getModel().getElementAt(1);
            bl13 = false;
            this.diffController.setRight(duplicateInfo.getRange(), duplicateInfo.getDescription());
        }
    }

    private final DuplicateInfo h(TextFragment textFragment, boolean bl2) {
        Document document = FileDocumentManager.getInstance().getDocument(textFragment.getFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(textFragment.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker rangeMarker2 = rangeMarker;
        int n2 = document2.getLineNumber(textFragment.getRange().getStartOffset());
        int n3 = document2.getLineNumber(textFragment.getRange().getEndOffset());
        String string = bl2 ? this.h(this.diffController.getProject().getBasePath(), textFragment.getFile().getPath()) : textFragment.getFile().getPresentableName();
        Object object = new Object[]{n2 + 1, n3 + 1, string};
        String string2 = DuplicatesBundle.INSTANCE.message("duplicate.toolwindow.duplicate", object);
        Object object2 = object = new DuplicateInfo(rangeMarker2, string2);
        boolean bl3 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)object2));
        return object;
    }

    private final String h(String string, String string2) {
        if (string == null || string2 == null) {
            return string2;
        }
        String string3 = FileUtil.getRelativePath((File)new File(string), (File)new File(string2));
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private final Point h(Point point, int n2) {
        Point point2 = this.indexToLocation(n2);
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    @NotNull
    public ListCellRenderer<? super DuplicateInfo> getCellRenderer() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4) -> DuplicatesList.h(this, arg_0, arg_1, arg_2, arg_3, arg_4);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.mainFragmentHighlighter);
        Disposer.dispose((Disposable)this.navigatedFragmentHighlighter);
    }

    private static final Component h(DuplicatesList duplicatesList, JList jList, DuplicateInfo duplicateInfo, int n2, boolean bl2, boolean bl3) {
        RowPanel rowPanel;
        RowPanel rowPanel2 = rowPanel = duplicatesList.rowPanel;
        boolean bl4 = false;
        rowPanel2.getLabel().setText(duplicateInfo.getDescription());
        rowPanel2.getLeftButton().setIcon(Intrinsics.areEqual((Object)duplicatesList.diffController.getLeftRange(), (Object)duplicateInfo.getRange()) ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
        rowPanel2.getRightButton().setIcon(Intrinsics.areEqual((Object)duplicatesList.diffController.getRightRange(), (Object)duplicateInfo.getRange()) ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
        Point point = duplicatesList.mouseRowPosition;
        Integer n3 = duplicatesList.mouseRow;
        int n4 = n2;
        if (n3 != null && n3 == n4 && point != null) {
            if (rowPanel2.getLeftButton().getBounds().contains(point)) {
                rowPanel2.getLeftButton().setIcon(AllIcons.Duplicates.SendToTheLeft);
            }
            if (rowPanel2.getRightButton().getBounds().contains(point)) {
                rowPanel2.getRightButton().setIcon(AllIcons.Duplicates.SendToTheRight);
            }
        }
        UIUtil.changeBackGround((Component)rowPanel2, (Color)UIUtil.getListBackground((boolean)bl2, (boolean)bl3));
        rowPanel2.getLabel().setForeground(UIUtil.getListForeground((boolean)bl2, (boolean)bl3));
        return rowPanel;
    }
}

