/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.testRunner;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.util.PresentableTestNameKt;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerConsoleProperties;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSetting;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfigurationEditor;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunProfileState;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunSettings;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTsKt;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoader;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerUtils;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\b\u00105\u001a\u00020\u000bH\u0016J\b\u00106\u001a\u000201H\u0016J\b\u00107\u001a\u000201H\u0016J\u0012\u00108\u001a\u0002012\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?H\u0002J.\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u0002012\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010F\u001a\u0002012\b\u00109\u001a\u0004\u0018\u00010:H\u0002R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006G"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfiguration;", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "Lcom/intellij/javascript/nodejs/debug/NodeDebugRunConfiguration;", "Lcom/intellij/javascript/testFramework/PreferableRunConfiguration;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lcom/intellij/execution/testframework/sm/runner/SMRunnerConsolePropertiesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "settings", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "getSettings", "()Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "setSettings", "(Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;)V", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "createConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "configuredDebugPort", "", "getConfiguredDebugPort", "()I", "createTestConsoleProperties", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerConsoleProperties;", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "isPreferredOver", "", "otherRc", "Lcom/intellij/execution/configurations/RunConfiguration;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "writeExternal", "", "element", "Lorg/jdom/Element;", "readExternal", "suggestedName", "onNewConfigurationCreated", "checkConfiguration", "checkNodeJsTestRunnerAvailableForNodeVersion", "nodeJsVersion", "Lcom/intellij/util/text/SemVer;", "getScopeContextDirOrFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "workingDir", "scope", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "findScopeContextNodePackages", "", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "packageDescriptor", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "checkTsRunSettings", "checkNodeJsTestRunnerFiltrationIssues", "intellij.nodeJS"})
public final class NodeJsTestRunnerRunConfiguration
extends AbstractNodeTargetRunProfile
implements NodeDebugRunConfiguration,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
SMRunnerConsolePropertiesProvider {
    @NotNull
    private NodeJsTestRunnerRunSettings settings;

    public NodeJsTestRunnerRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.settings = new NodeJsTestRunnerRunSettings.Builder(null, null, null, null, null, null, null, 127, null).build();
    }

    @NotNull
    public final NodeJsTestRunnerRunSettings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull NodeJsTestRunnerRunSettings nodeJsTestRunnerRunSettings) {
        Intrinsics.checkNotNullParameter((Object)nodeJsTestRunnerRunSettings, (String)"<set-?>");
        this.settings = nodeJsTestRunnerRunSettings;
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.settings.getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public SettingsEditor<? extends AbstractNodeTargetRunProfile> createConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new NodeJsTestRunnerRunConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return (RunProfileState)new NodeJsTestRunnerRunProfileState(this, environment);
    }

    public int getConfiguredDebugPort() {
        return NodeCommandLineUtil.findDebugPort((String)this.settings.getNodeOptions());
    }

    @NotNull
    public NodeJsTestRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new NodeJsTestRunnerConsoleProperties(this, executor);
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        return this.settings.getEnvData();
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)otherRc, (String)"otherRc");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        return false;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        NodeJsTestRunnerUtils.INSTANCE.writeXml(element, this.settings);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.settings = NodeJsTestRunnerUtils.INSTANCE.readXml(element);
    }

    @NotNull
    public String suggestedName() {
        JsTestRunScope scope = this.settings.getScope();
        if (scope.getKind() == JsTestRunScopeKind.DIRECTORY) {
            Object[] objectArray = new Object[]{PathUtil.getFileName((String)scope.getTestDirectoryPath()) + File.separator};
            String string = JavaScriptBundle.message((String)"rc.testDirectory.presentable.name", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (scope.getKind() == JsTestRunScopeKind.TEST_FILE) {
            String string = PathUtil.getFileName((String)scope.getTestFilePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            return string;
        }
        if (scope.getKind() == JsTestRunScopeKind.SUITE || scope.getKind() == JsTestRunScopeKind.TEST) {
            return PresentableTestNameKt.createPresentableTestName((List)scope.getTestNames());
        }
        String string = TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void onNewConfigurationCreated() {
        block1: {
            if (!StringsKt.isBlank((CharSequence)this.settings.getWorkingDir())) break block1;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                NodeJsTestRunnerRunSettings.Builder builder = this.settings.builder();
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.settings = builder.workingDir(string).build();
            }
        }
    }

    public void checkConfiguration() {
        NodeJsInterpreter nodeJsInterpreter;
        NodeJsInterpreter nodeJsInterpreter2 = this.settings.getInterpreterRef().resolve(this.getProject());
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)nodeJsInterpreter2);
        NodeJsInterpreter nodeJsInterpreter3 = nodeJsInterpreter2;
        if (nodeJsInterpreter3 != null) {
            nodeJsInterpreter3.fetchVersion(arg_0 -> NodeJsTestRunnerRunConfiguration.checkConfiguration$lambda$1(NodeJsTestRunnerRunConfiguration::checkConfiguration$lambda$0, arg_0));
        }
        SemVer nodeJsVersion = (nodeJsInterpreter = nodeJsInterpreter2) != null && (nodeJsInterpreter = nodeJsInterpreter.getCachedVersion()) != null ? (SemVer)nodeJsInterpreter.get() : null;
        this.checkNodeJsTestRunnerAvailableForNodeVersion(nodeJsVersion);
        String workingDir = this.settings.getWorkingDir();
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", workingDir);
        this.checkTsRunSettings(workingDir, this.settings);
        this.settings.getScope().validateForRunConfiguration(false);
        this.checkNodeJsTestRunnerFiltrationIssues(nodeJsVersion);
    }

    private final void checkNodeJsTestRunnerAvailableForNodeVersion(SemVer nodeJsVersion) throws RuntimeConfigurationError {
        if (nodeJsVersion != null && !nodeJsVersion.isGreaterOrEqualThan(18, 0, 0)) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.test.runner.node_js_version_does_not_support_test_runner", new Object[0]));
        }
    }

    private final VirtualFile getScopeContextDirOrFile(String workingDir, JsTestRunScope scope) {
        String path = switch (WhenMappings.$EnumSwitchMapping$0[scope.getKind().ordinal()]) {
            case 1 -> workingDir;
            case 2 -> scope.getTestDirectoryPath();
            case 3, 4, 5 -> scope.getTestFilePath();
            default -> throw new NoWhenBranchMatchedException();
        };
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private final List<NodePackage> findScopeContextNodePackages(Project project, String workingDir, NodeJsTestRunnerRunSettings settings, NodePackageDescriptor packageDescriptor) {
        VirtualFile localContext = this.getScopeContextDirOrFile(workingDir, settings.getScope());
        return NodeJsTestRunnerTsKt.findNodejsLoaderPackagesForContext(project, packageDescriptor, localContext);
    }

    private final void checkTsRunSettings(String workingDir, NodeJsTestRunnerRunSettings settings) throws RuntimeConfigurationWarning {
        if (settings.getLanguage() == NodeJsTestRunnerLanguageSetting.TYPE_SCRIPT) {
            switch (WhenMappings.$EnumSwitchMapping$1[settings.getTypeScriptLoader().ordinal()]) {
                case 1: {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (!this.findScopeContextNodePackages(project, workingDir, settings, NodeJsTestRunnerTsKt.getTS_NODE_PACKAGE_DESCRIPTOR()).isEmpty()) break;
                    throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.type_script_loader.could_not_find_ts_node_package", new Object[0]));
                }
                case 2: {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (!this.findScopeContextNodePackages(project, workingDir, settings, NodeJsTestRunnerTsKt.getTSX_PACKAGE_DESCRIPTOR()).isEmpty()) break;
                    throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.type_script_loader.could_not_find_tsx_package", new Object[0]));
                }
                case 3: {
                    if (NodeJsTestRunnerTypeScriptLoader.Companion.hasLoaderInNodeOptions(settings.getNodeOptions())) break;
                    throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.type_script_loader.manual_set_loader_should_be_set_in_node_options", new Object[0]));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void checkNodeJsTestRunnerFiltrationIssues(SemVer nodeJsVersion) throws RuntimeConfigurationWarning {
        if (nodeJsVersion == null) {
            return;
        }
        if (this.settings.getScope().getKind() == JsTestRunScopeKind.TEST || this.settings.getScope().getKind() == JsTestRunScopeKind.SUITE) {
            if (!nodeJsVersion.isGreaterOrEqualThan(19, 0, 0)) {
                throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.node_js_version_has_experimental_support", new Object[0]));
            }
            if (!nodeJsVersion.isGreaterOrEqualThan(20, 4, 0)) {
                throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.node_js_version_does_not_support_nested_tests_execution", new Object[0]));
            }
            if (nodeJsVersion.getMajor() < 22) {
                throw new RuntimeConfigurationWarning(NodeJSBundle.message("rc.nodejs.test.runner.node_js_version_does_not_support_correct_tests_filtration", new Object[0]));
            }
        }
    }

    private static final Unit checkConfiguration$lambda$0(SemVer it) {
        return Unit.INSTANCE;
    }

    private static final void checkConfiguration$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JsTestRunScopeKind.values().length];
            try {
                nArray[JsTestRunScopeKind.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.TEST_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.SUITE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.TEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NodeJsTestRunnerTypeScriptLoader.values().length];
            try {
                nArray[NodeJsTestRunnerTypeScriptLoader.TS_NODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeJsTestRunnerTypeScriptLoader.TSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeJsTestRunnerTypeScriptLoader.MANUAL_SETUP_IN_NODE_OPTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

