/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.ide.FixedProjectAvatarPresentation;
import com.intellij.ide.FullProjectAvatarPresentation;
import com.intellij.ide.LocalProjectIconKey;
import com.intellij.ide.NonLocalProjectIconKey;
import com.intellij.ide.ProjectAvatarPresentation;
import com.intellij.ide.ProjectFileIcon;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.AvatarIcon;
import com.intellij.util.ui.AvatarPresentation;
import com.intellij.util.ui.JBScalableIcon;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ*\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper;", "", "<init>", "()V", "getProjectIcon", "Ljavax/swing/Icon;", "path", "Ljava/nio/file/Path;", "isProjectValid", "", "iconSize", "", "name", "", "getNonLocalProjectIcon", "id", "hasCustomIcon", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRecentProjectIconHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectIconHelper.kt\ncom/intellij/ide/RecentProjectIconHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,514:1\n1#2:515\n*E\n"})
public final class RecentProjectIconHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Icon getProjectIcon(@NotNull Path path, boolean isProjectValid, int iconSize, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return RecentProjectIconHelperKt.access$createDeferredIcon(new LocalProjectIconKey(RecentProjectIconHelperKt.access$getCacheEpoch$p().get(), path, isProjectValid, iconSize, name2));
    }

    public static /* synthetic */ Icon getProjectIcon$default(RecentProjectIconHelper recentProjectIconHelper, Path path, boolean bl, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = RecentProjectIconHelperKt.unscaledProjectIconSize();
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        return recentProjectIconHelper.getProjectIcon(path, bl, n, string);
    }

    @NotNull
    public final Icon getNonLocalProjectIcon(@NotNull String id2, boolean isProjectValid, int iconSize, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return RecentProjectIconHelperKt.access$createDeferredIcon(new NonLocalProjectIconKey(RecentProjectIconHelperKt.access$getCacheEpoch$p().get(), id2, isProjectValid, iconSize, name2));
    }

    public static /* synthetic */ Icon getNonLocalProjectIcon$default(RecentProjectIconHelper recentProjectIconHelper, String string, boolean bl, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = RecentProjectIconHelperKt.unscaledProjectIconSize();
        }
        return recentProjectIconHelper.getNonLocalProjectIcon(string, bl, n, string2);
    }

    public final boolean hasCustomIcon(@NotNull Project project2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path = RecentProjectsManagerBase.Companion.getInstanceEx().getProjectPath(project2);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            pair = RecentProjectIconHelperKt.access$getCustomIconFileInfo(it);
        } else {
            pair = null;
        }
        return pair != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\nJ\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\nJ \u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J9\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper$Companion;", "", "<init>", "()V", "getDotIdeaPath", "Ljava/nio/file/Path;", "file", "getDotIdeaPath$intellij_platform_ide_impl", "createIcon", "Ljavax/swing/Icon;", "createIcon$intellij_platform_ide_impl", "size", "", "data", "", "svg", "", "refreshProjectIcon", "", "path", "getProjectName", "", "recentProjectManager", "Lcom/intellij/ide/RecentProjectsManagerBase;", "generateNewProjectIcon", "isProjectValid", "projectName", "colorIndex", "(Ljava/nio/file/Path;ZLjava/lang/String;Ljava/lang/Integer;I)Ljavax/swing/Icon;", "createNewProjectIcon", "presentation", "Lcom/intellij/util/ui/AvatarPresentation;", "createNewProjectIcon$intellij_platform_ide_impl", "iconTextForCommaSeparatedName", "name", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nRecentProjectIconHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectIconHelper.kt\ncom/intellij/ide/RecentProjectIconHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,514:1\n777#2:515\n873#2,2:516\n1915#2,2:518\n1586#2:520\n1661#2,2:521\n1663#2:525\n131#3,2:523\n*S KotlinDebug\n*F\n+ 1 RecentProjectIconHelper.kt\ncom/intellij/ide/RecentProjectIconHelper$Companion\n*L\n88#1:515\n88#1:516,2\n89#1:518,2\n136#1:520\n136#1:521,2\n136#1:525\n136#1:523,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getDotIdeaPath$intellij_platform_ide_impl(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            try {
                if (Files.isDirectory(file2, new LinkOption[0]) || file2.getParent() == null) {
                    Path path = ProjectStorePathManager.Companion.getInstance().getStoreDescriptor(file2).getDotIdea();
                    Intrinsics.checkNotNull((Object)path);
                    return path;
                }
                String fileName = ((Object)file2.getFileName()).toString();
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
                String fileNameWithoutExt = dotIndex == -1 ? fileName : StringsKt.take((String)fileName, (int)dotIndex);
                return file2.getParent().resolve(".idea/.idea." + fileNameWithoutExt + "/.idea");
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
        }

        @NotNull
        public final Icon createIcon$intellij_platform_ide_impl(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return (Icon)((Object)new ProjectFileIcon(RecentProjectIconHelperKt.loadIconFile$default(file2, 0, 2, null)));
        }

        @NotNull
        public final Icon createIcon$intellij_platform_ide_impl(@NotNull Path file2, int size2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return (Icon)((Object)new ProjectFileIcon(RecentProjectIconHelperKt.access$loadIconFile(file2, size2)));
        }

        @ApiStatus.Internal
        @NotNull
        public final Icon createIcon(@NotNull byte[] data2, boolean svg, int size2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return (Icon)((Object)new ProjectFileIcon(RecentProjectIconHelperKt.access$loadIcon(data2, svg, size2)));
        }

        @NotNull
        public final Icon createIcon(@NotNull byte[] data2, boolean svg) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return this.createIcon(data2, svg, RecentProjectIconHelperKt.unscaledProjectIconSize());
        }

        /*
         * WARNING - void declaration
         */
        public final void refreshProjectIcon(@NotNull Path path) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            RecentProjectIconHelperKt.access$getCacheEpoch$p().incrementAndGet();
            Iterable $this$filter$iv = RecentProjectIconHelperKt.access$getProjectIconCache$p().keySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)path)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                RecentProjectIconHelperKt.access$getProjectIconCache$p().remove(it);
            }
        }

        @NotNull
        public final String getProjectName(@NotNull Path path, @NotNull RecentProjectsManagerBase recentProjectManager) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)recentProjectManager, (String)"recentProjectManager");
            String displayName = recentProjectManager.getDisplayName(path);
            return displayName == null ? recentProjectManager.getProjectName(path) : (StringsKt.contains$default((CharSequence)displayName, (char)',', (boolean)false, (int)2, null) ? this.iconTextForCommaSeparatedName(displayName) : displayName);
        }

        @NotNull
        public final Icon generateNewProjectIcon(@NotNull Path path, boolean isProjectValid, @Nullable String projectName, @Nullable Integer colorIndex, int size2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = projectName;
            if (string == null) {
                string = this.getProjectName(path, RecentProjectsManagerBase.Companion.getInstanceEx());
            }
            String name2 = string;
            ProjectAvatarPresentation presentation2 = colorIndex != null ? (ProjectAvatarPresentation)new FixedProjectAvatarPresentation(name2, colorIndex) : (ProjectAvatarPresentation)new FullProjectAvatarPresentation(name2, path);
            return this.createNewProjectIcon$intellij_platform_ide_impl(presentation2, size2, isProjectValid);
        }

        public static /* synthetic */ Icon generateNewProjectIcon$default(Companion companion, Path path, boolean bl, String string, Integer n, int n2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n2 = RecentProjectIconHelperKt.unscaledProjectIconSize();
            }
            return companion.generateNewProjectIcon(path, bl, string, n, n2);
        }

        @NotNull
        public final Icon createNewProjectIcon$intellij_platform_ide_impl(@NotNull AvatarPresentation presentation2, int size2, boolean isProjectValid) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            JBScalableIcon jBScalableIcon = new AvatarIcon(size2, 0.4, presentation2).withIconPreScaled(false);
            Intrinsics.checkNotNullExpressionValue((Object)jBScalableIcon, (String)"withIconPreScaled(...)");
            Icon generatedProjectIcon = (Icon)jBScalableIcon;
            if (!isProjectValid) {
                generatedProjectIcon = IconUtil.desaturate((Icon)generatedProjectIcon);
            }
            return generatedProjectIcon;
        }

        /*
         * WARNING - void declaration
         */
        private final String iconTextForCommaSeparatedName(String name2) {
            void $this$mapTo$iv$iv;
            Object object = new char[]{','};
            Iterable $this$map$iv = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)name2, (char[])object, (boolean)false, (int)0, (int)6, null), (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                Object object2;
                Collection collection;
                block3: {
                    void word;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    CharSequence $this$firstOrNull$iv = (CharSequence)word;
                    boolean $i$f$firstOrNull = false;
                    for (int j = 0; j < $this$firstOrNull$iv.length(); ++j) {
                        char element$iv;
                        char it = element$iv = $this$firstOrNull$iv.charAt(j);
                        boolean bl2 = false;
                        if (!(!CharsKt.isWhitespace((char)it))) continue;
                        object2 = Character.valueOf(element$iv);
                        break block3;
                    }
                    object2 = string = null;
                }
                if (object2 == null) {
                    string = "";
                }
                collection.add(string);
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = object.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

