/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ProjectColorInfoManager;
import com.intellij.ide.ProjectColorStorage;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/intellij/ide/WorkspaceProjectColorStorage;", "Lcom/intellij/ide/ProjectColorStorage;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "customColor", "getCustomColor", "()Ljava/lang/String;", "setCustomColor", "(Ljava/lang/String;)V", "", "associatedIndex", "getAssociatedIndex", "()Ljava/lang/Integer;", "setAssociatedIndex", "(Ljava/lang/Integer;)V", "isMigrating", "", "projectPath", "Ljava/nio/file/Path;", "getProjectPath", "()Ljava/nio/file/Path;", "manager", "Lcom/intellij/ide/ProjectColorInfoManager;", "getManager", "()Lcom/intellij/ide/ProjectColorInfoManager;", "getDataFrom", "", "storage", "intellij.platform.ide.impl"})
final class WorkspaceProjectColorStorage
implements ProjectColorStorage {
    @NotNull
    private final Project project;
    private boolean isMigrating;

    public WorkspaceProjectColorStorage(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String getCustomColor() {
        return this.getManager().getCustomColor();
    }

    @Override
    public void setCustomColor(@Nullable String value) {
        this.getManager().setCustomColor(value);
        if (!this.isMigrating) {
            RecentProjectsManagerBase.Companion.getInstanceEx().updateProjectColor(this.project);
        }
    }

    @Override
    @Nullable
    public Integer getAssociatedIndex() {
        return this.getManager().getAssociatedIndex();
    }

    @Override
    public void setAssociatedIndex(@Nullable Integer value) {
        this.getManager().setAssociatedIndex(value);
        if (!this.isMigrating) {
            RecentProjectsManagerBase.Companion.getInstanceEx().updateProjectColor(this.project);
        }
    }

    @Override
    @Nullable
    public Path getProjectPath() {
        return ProjectWindowCustomizerService.Companion.projectPath(this.project);
    }

    private final ProjectColorInfoManager getManager() {
        return ProjectColorInfoManager.Companion.getInstance(this.project);
    }

    public final void getDataFrom(@NotNull ProjectColorStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.isMigrating = true;
        this.setCustomColor(storage.getCustomColor());
        this.setAssociatedIndex(storage.getAssociatedIndex());
        this.isMigrating = false;
    }
}

