/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditDropHandler;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class LightEditorManagerImpl
implements LightEditorManager,
Disposable {
    static final Key<Boolean> NO_IMPLICIT_SAVE = Key.create((String)"light.edit.no.implicit.save");
    private static final Logger LOG = Logger.getInstance(LightEditorManagerImpl.class);
    private static final String DEFAULT_FILE_NAME = "untitled_";
    private final List<LightEditorInfo> editors = new CopyOnWriteArrayList<LightEditorInfo>();
    private final EventDispatcher<LightEditorListener> eventDispatcher = EventDispatcher.create(LightEditorListener.class);
    private final LightEditServiceImpl lightEditService;

    public LightEditorManagerImpl(LightEditServiceImpl service) {
        this.lightEditService = service;
    }

    @Nullable
    private LightEditorInfo doCreateEditor(@NotNull VirtualFile file2) {
        Editor editor2;
        Project project2;
        Pair<FileEditorProvider, FileEditor> pair;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(0);
        }
        if ((pair = LightEditorManagerImpl.createFileEditor(project2 = LightEditUtil.requireLightEditProject(this.lightEditService.getProject()), file2)) == null) {
            return null;
        }
        FileEditor fileEditor = (FileEditor)pair.second;
        LightEditorInfoImpl editorInfo = new LightEditorInfoImpl((FileEditorProvider)pair.first, fileEditor, file2);
        FileEditorState state2 = EditorHistoryManager.getInstance(project2).getState(file2, (FileEditorProvider)pair.first);
        if (state2 != null) {
            fileEditor.getComponent();
            fileEditor.setState(state2);
        }
        if ((editor2 = LightEditorInfoImpl.getEditor(editorInfo)) instanceof EditorImpl) {
            EditorImpl editor3 = (EditorImpl)editor2;
            editor3.setDropHandler(new LightEditDropHandler());
        }
        this.editors.add(editorInfo);
        this.installListener(editorInfo);
        return editorInfo;
    }

    private void installListener(@NotNull LightEditorInfo editorInfo) {
        TextEditor te;
        Editor editor2;
        FileEditor fileEditor;
        if (editorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(1);
        }
        if ((fileEditor = editorInfo.getFileEditor()) instanceof TextEditor && (editor2 = (te = (TextEditor)fileEditor).getEditor()) instanceof EditorEx) {
            EditorEx ex = (EditorEx)editor2;
            ex.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor2) {
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    WriteIntentReadAction.run(() -> LightEditorManagerImpl.this.checkUpdate(editor2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/lightEdit/LightEditorManagerImpl$1", "focusGained"));
                }
            }, this);
        }
    }

    @NotNull
    public LightEditorInfo createEmptyEditor(@Nullable String preferredName) {
        String name2 = preferredName != null ? preferredName : this.getUniqueName();
        LightVirtualFile file2 = new LightVirtualFile(name2);
        file2.setFileType(LightEditorManagerImpl.getFileType(preferredName));
        LightEditorInfo lightEditorInfo = Objects.requireNonNull(this.doCreateEditor((VirtualFile)file2));
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return lightEditorInfo;
    }

    @Nullable
    public LightEditorInfo createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(3);
        }
        LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        LightEditorManagerImpl.setImplicitSaveEnabled(file2, false);
        LightEditorInfo editorInfo = this.doCreateEditor(file2);
        Editor editor2 = LightEditorInfoImpl.getEditor(editorInfo);
        if (editor2 instanceof EditorEx) {
            ((EditorEx)editor2).setHighlighter(LightEditorManagerImpl.getHighlighter(file2, editor2));
        }
        return editorInfo;
    }

    public void dispose() {
        this.releaseEditors();
    }

    public void releaseEditors() {
        this.editors.forEach(editorInfo -> ((LightEditorInfoImpl)editorInfo).disposeEditor());
        this.editors.clear();
    }

    public void closeAllEditors() {
        this.editors.forEach(editorInfo -> this.closeEditor((LightEditorInfo)editorInfo));
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(4);
        }
        EditorHistoryManager.getInstance(this.lightEditService.getOrCreateProject()).updateHistoryEntry(editorInfo.getFile(), false);
        this.editors.remove(editorInfo);
        LightEditorManagerImpl.setImplicitSaveEnabled(editorInfo.getFile(), true);
        ((LightEditorInfoImpl)editorInfo).disposeEditor();
        ((LightEditorListener)this.eventDispatcher.getMulticaster()).afterClose(editorInfo);
    }

    public void addListener(@NotNull LightEditorListener listener2) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(5);
        }
        this.eventDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LightEditorListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(7);
        }
        this.eventDispatcher.addListener((EventListener)listener2, parent);
    }

    void fireEditorSelected(@Nullable LightEditorInfo editorInfo) {
        ((LightEditorListener)this.eventDispatcher.getMulticaster()).afterSelect(editorInfo);
    }

    void fireAutosaveModeChanged(boolean autosaveMode) {
        ((LightEditorListener)this.eventDispatcher.getMulticaster()).autosaveModeChanged(autosaveMode);
    }

    void fireFileStatusChanged(@NotNull Collection<? extends LightEditorInfo> editorInfos) {
        if (editorInfos == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(8);
        }
        ((LightEditorListener)this.eventDispatcher.getMulticaster()).fileStatusChanged(editorInfos);
    }

    int getEditorCount() {
        return this.editors.size();
    }

    @Nullable
    public LightEditorInfo findOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(9);
        }
        return (LightEditorInfo)ContainerUtil.find(this.editors, editorInfo -> file2.getPath().equals(editorInfo.getFile().getPath()));
    }

    public boolean isImplicitSaveAllowed(@NotNull Document document2) {
        if (document2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(10);
        }
        return LightEditService.getInstance().isAutosaveMode() || (Boolean)ObjectUtils.notNull((Object)((Boolean)document2.getUserData(NO_IMPLICIT_SAVE)), (Object)false) == false;
    }

    @NotNull
    public @Unmodifiable Collection<VirtualFile> getOpenFiles() {
        Collection collection = this.editors.stream().map(info -> info.getFile()).collect(Collectors.toUnmodifiableSet());
        if (collection == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public @Unmodifiable @NotNull Collection<LightEditorInfo> getEditors(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.filter(this.editors, editorInfo -> virtualFile2.equals(editorInfo.getFile()));
        if (list2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(14);
        }
        return this.editors.stream().anyMatch(editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public boolean containsUnsavedDocuments() {
        return this.editors.stream().anyMatch(editorInfo -> editorInfo.isSaveRequired());
    }

    @NotNull
    @NotNull @Unmodifiable List<@NotNull LightEditorInfo> getUnsavedEditors() {
        List list2 = ContainerUtil.filter(this.editors, editorInfo -> editorInfo.isSaveRequired());
        if (list2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private String getUniqueName() {
        int i2 = 1;
        String candidate;
        while (ContainerUtil.exists(this.editors, arg_0 -> LightEditorManagerImpl.lambda$getUniqueName$8(candidate = DEFAULT_FILE_NAME + i2, arg_0))) {
            ++i2;
        }
        return candidate;
    }

    @NotNull
    public LightEditorInfo saveAs(@NotNull LightEditorInfo info, @NotNull VirtualFile targetFile) {
        LightEditorInfo newInfo;
        if (info == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(16);
        }
        if (targetFile == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(17);
        }
        if ((newInfo = this.createEditor(targetFile)) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager manager2 = FileDocumentManager.getInstance();
                Document source = manager2.getDocument(info.getFile());
                Document target = manager2.getDocument(targetFile);
                if (source == null) {
                    LOG.error("Cannot save to " + String.valueOf(targetFile) + ": no document found for " + String.valueOf(info.getFile()));
                    return;
                }
                if (target == null) {
                    LOG.error("Cannot save to " + String.valueOf(targetFile) + ": no document found for " + String.valueOf(targetFile));
                    return;
                }
                targetFile.refresh(false, false);
                target.setText(source.getCharsSequence());
                manager2.saveDocument(target);
            });
            LightEditorInfo lightEditorInfo = newInfo;
            if (lightEditorInfo == null) {
                LightEditorManagerImpl.$$$reportNull$$$0(18);
            }
            return lightEditorInfo;
        }
        LightEditorInfo lightEditorInfo = info;
        if (lightEditorInfo == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(19);
        }
        return lightEditorInfo;
    }

    @Nullable
    public LightEditorInfo getEditorInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(20);
        }
        return (LightEditorInfo)ContainerUtil.find(this.editors, editorInfo -> file2.equals(editorInfo.getFile()));
    }

    public void reloadFile(@NotNull VirtualFile file2) {
        LightEditorInfo editorInfo;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(21);
        }
        if ((editorInfo = this.getEditorInfo(file2)) != null) {
            file2.refresh(false, false);
            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file2});
        }
    }

    private void checkUpdate(@NotNull Editor editor2) {
        LightEditorInfo editorInfo;
        if (editor2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(22);
        }
        if ((editorInfo = this.findEditor(editor2)) != null && !editorInfo.isUnsaved()) {
            this.reloadFile(editorInfo.getFile());
        }
    }

    @Nullable
    private LightEditorInfo findEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(23);
        }
        for (LightEditorInfo editorInfo : this.editors) {
            TextEditor te;
            FileEditor fileEditor = editorInfo.getFileEditor();
            if (!(fileEditor instanceof TextEditor) || editor2 != (te = (TextEditor)fileEditor).getEditor()) continue;
            return editorInfo;
        }
        return null;
    }

    @Nullable
    private static Pair<FileEditorProvider, FileEditor> createFileEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Iterator<FileEditorProvider> iterator2;
        if (project2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if ((iterator2 = FileEditorProviderManager.getInstance().getProviderList(project2, file2).iterator()).hasNext()) {
            FileEditorProvider provider = iterator2.next();
            FileEditor editor2 = provider.createEditor(project2, file2);
            return Pair.create((Object)provider, (Object)editor2);
        }
        return null;
    }

    @NotNull
    private static FileType getFileType(@Nullable String preferredName) {
        int extOffset;
        if (preferredName != null && (extOffset = preferredName.lastIndexOf(".")) >= 0 && preferredName.length() > extOffset + 1) {
            String extension = preferredName.substring(extOffset + 1);
            FileType fileType2 = FileTypeManager.getInstance().getFileTypeByExtension(extension);
            if (!(fileType2 instanceof UnknownFileType) && !fileType2.isBinary()) {
                FileType fileType3 = fileType2;
                if (fileType3 == null) {
                    LightEditorManagerImpl.$$$reportNull$$$0(26);
                }
                return fileType3;
            }
        }
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(27);
        }
        return plainTextFileType;
    }

    private static void setImplicitSaveEnabled(@NotNull VirtualFile file2, boolean isEnabled) {
        Document document2;
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(28);
        }
        if ((document2 = FileDocumentManager.getInstance().getDocument(file2)) != null) {
            document2.putUserData(NO_IMPLICIT_SAVE, (Object)(isEnabled ? null : Boolean.valueOf(true)));
        }
    }

    @NotNull
    private static EditorHighlighter getHighlighter(@NotNull VirtualFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(29);
        }
        if (editor2 == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(30);
        }
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, editor2.getColorsScheme(), null);
        if (editorHighlighter == null) {
            LightEditorManagerImpl.$$$reportNull$$$0(31);
        }
        return editorHighlighter;
    }

    private static /* synthetic */ boolean lambda$getUniqueName$8(String candidate, LightEditorInfo editorInfo) {
        return editorInfo.getFile().getName().equals(candidate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11, 13, 15, 18, 19, 26, 27, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 22: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditorManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedEditors";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "saveAs";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installListener";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "closeEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireFileStatusChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOpen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitSaveAllowed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveAs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEditorInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reloadFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkUpdate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findEditor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFileEditor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setImplicitSaveEnabled";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11, 13, 15, 18, 19, 26, 27, 31 -> new IllegalStateException(string);
        };
    }
}

