/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.CreateInstalledPanelModel;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.PluginManagerConfigurablePanel;
import com.intellij.ide.plugins.PluginManagerPanelFactory;
import com.intellij.ide.plugins.PluginsGroupType;
import com.intellij.ide.plugins.marketplace.CheckErrorsResult;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelKt;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class InstalledPluginsTab
extends PluginsTab {
    private final DefaultActionGroup myInstalledSearchGroup;
    private boolean myInstalledSearchSetState;
    @NotNull
    private final PluginModelFacade myPluginModelFacade;
    @NotNull
    private final PluginUpdatesService myPluginUpdatesService;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    @Nullable
    private final Consumer<String> mySearchInMarketplaceTabHandler;
    @Nullable
    private PluginsGroupComponentWithProgress myInstalledPanel;
    @Nullable
    private SearchResultPanel myInstalledSearchPanel;
    private final PluginsGroup myBundledUpdateGroup;
    private final LinkLabel<Object> myUpdateAll;
    private final LinkLabel<Object> myUpdateAllBundled;
    private final JLabel myUpdateCounter;
    private final JLabel myUpdateCounterBundled;

    InstalledPluginsTab(@NotNull PluginModelFacade facade2, @NotNull PluginUpdatesService service, @NotNull CoroutineScope scope, @Nullable Consumer<String> handler2) {
        if (facade2 == null) {
            InstalledPluginsTab.$$$reportNull$$$0(0);
        }
        if (service == null) {
            InstalledPluginsTab.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            InstalledPluginsTab.$$$reportNull$$$0(2);
        }
        this.myInstalledSearchSetState = true;
        this.myInstalledPanel = null;
        this.myInstalledSearchPanel = null;
        this.myBundledUpdateGroup = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.bundled.updates", (Object[])new Object[0]), PluginsGroupType.BUNDLED_UPDATE);
        this.myUpdateAll = new PluginManagerConfigurablePanel.LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
        this.myUpdateAllBundled = new PluginManagerConfigurablePanel.LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
        this.myUpdateCounter = new CountComponent();
        this.myUpdateCounterBundled = new CountComponent();
        this.myPluginModelFacade = facade2;
        this.myPluginUpdatesService = service;
        this.myCoroutineScope = scope;
        this.mySearchInMarketplaceTabHandler = handler2;
        this.myInstalledSearchGroup = new DefaultActionGroup();
        for (InstalledSearchOption option2 : InstalledSearchOption.values()) {
            this.myInstalledSearchGroup.add((AnAction)new InstalledSearchOptionAction(option2));
        }
    }

    @Override
    protected void createSearchTextField(int flyDelay) {
        super.createSearchTextField(flyDelay);
        JBTextField textField2 = this.searchTextField.getTextEditor();
        ExtendableTextComponent.Extension searchFieldExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.Filter, (Icon)AllIcons.General.Filter, (String)IdeBundle.message((String)"plugins.configurable.search.options", (Object[])new Object[0]), (boolean)true, () -> PluginManagerConfigurablePanel.showRightBottomPopup((Component)textField2, IdeBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), (ActionGroup)this.myInstalledSearchGroup));
        textField2.putClientProperty((Object)"search.extension", (Object)searchFieldExtension);
        textField2.putClientProperty((Object)"JTextField.variant", null);
        textField2.putClientProperty((Object)"JTextField.variant", (Object)"search");
        this.searchTextField.setHistoryPropertyName("InstalledPluginsSearchHistory");
    }

    @Nullable
    public PluginsGroupComponentWithProgress getInstalledPanel() {
        return this.myInstalledPanel;
    }

    @Nullable
    public SearchResultPanel getInstalledSearchPanel() {
        return this.myInstalledSearchPanel;
    }

    @Nullable
    public List<UIPluginGroup> getInstalledGroups() {
        return this.getInstalledPanel() != null ? this.getInstalledPanel().getGroups() : null;
    }

    @Override
    @NotNull
    protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
        if (searchListener == null) {
            InstalledPluginsTab.$$$reportNull$$$0(3);
        }
        PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(this.myPluginModelFacade, searchListener, false);
        this.myPluginModelFacade.getModel().addDetailPanel(detailPanel);
        PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
        if (pluginDetailsPageComponent == null) {
            InstalledPluginsTab.$$$reportNull$$$0(4);
        }
        return pluginDetailsPageComponent;
    }

    @Override
    @NotNull
    protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            InstalledPluginsTab.$$$reportNull$$$0(5);
        }
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myInstalledPanel = new PluginsGroupComponentWithProgress(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (group2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (listPluginModel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new ListPluginComponent(InstalledPluginsTab.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)InstalledPluginsTab.this.searchListener, InstalledPluginsTab.this.myCoroutineScope, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listPluginModel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/InstalledPluginsTab$1";
                objectArray[2] = "createListComponent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myInstalledPanel.setSelectionListener(selectionListener2);
        this.myInstalledPanel.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugin.manager.installed.panel.accessible.name", (Object[])new Object[0]));
        PluginManagerConfigurablePanel.registerCopyProvider(this.myInstalledPanel);
        ((SearchUpDownPopupController)this.myInstalledSearchPanel.controller).setEventHandler(eventHandler);
        this.myInstalledPanel.startLoading();
        PluginsGroup downloaded = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.downloaded", (Object[])new Object[0]), PluginsGroupType.INSTALLED);
        PluginsGroup installing = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.installing", (Object[])new Object[0]), PluginsGroupType.INSTALLING);
        PluginManagerPanelFactory.INSTANCE.createInstalledPanel(this.myCoroutineScope, this.myPluginModelFacade.getModel(), (Function1<? super CreateInstalledPanelModel, Unit>)((Function1)model2 -> {
            try {
                this.myPluginModelFacade.getModel().setDownloadedGroup(this.myInstalledPanel, downloaded, installing);
                installing.getPreloadedModel().setErrors(model2.getErrors());
                installing.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                installing.addModels(MyPluginModel.getInstallingPlugins());
                if (!installing.getModels().isEmpty()) {
                    installing.sortByName();
                    installing.titleWithCount();
                    this.myInstalledPanel.addGroup(installing);
                }
                downloaded.getPreloadedModel().setErrors(model2.getErrors());
                downloaded.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                downloaded.addModels(model2.getInstalledPlugins());
                this.myBundledUpdateGroup.getPreloadedModel().setErrors(model2.getErrors());
                this.myBundledUpdateGroup.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                Map<Boolean, List<PluginUiModel>> visiblePlugins = model2.getVisiblePlugins().stream().collect(Collectors.partitioningBy(plugin -> plugin.isBundled() || plugin.isBundledUpdate()));
                List<PluginUiModel> visibleNonBundledPlugins = visiblePlugins.get(Boolean.FALSE);
                List<PluginUiModel> visibleBundledPlugins = visiblePlugins.get(Boolean.TRUE);
                List installedPluginIds = ContainerUtil.map(model2.getInstalledPlugins(), it -> it.getPluginId());
                List nonBundledPlugins = ContainerUtil.filter(visibleNonBundledPlugins, it -> !installedPluginIds.contains(it.getPluginId()));
                downloaded.addModels(nonBundledPlugins);
                LinkListener<Object> updateAllListener = new LinkListener<Object>(){

                    public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                        InstalledPluginsTab.this.myUpdateAll.setEnabled(false);
                        InstalledPluginsTab.this.myUpdateAllBundled.setEnabled(false);
                        for (UIPluginGroup group2 : InstalledPluginsTab.this.getInstalledGroups()) {
                            if (group2.excluded) continue;
                            for (ListPluginComponent plugin : group2.plugins) {
                                plugin.updatePlugin();
                            }
                        }
                    }
                };
                this.myUpdateAll.setVisible(false);
                this.myUpdateAllBundled.setVisible(false);
                this.myUpdateCounter.setVisible(false);
                this.myUpdateCounterBundled.setVisible(false);
                this.myUpdateAll.setListener((LinkListener)updateAllListener, null);
                downloaded.addRightAction((JComponent)this.myUpdateAll);
                downloaded.addRightAction(this.myUpdateCounter);
                if (!downloaded.getModels().isEmpty()) {
                    downloaded.sortByName();
                    long enabledNonBundledCount = nonBundledPlugins.stream().filter(descriptor2 -> !this.myPluginModelFacade.getModel().isDisabled(descriptor2.getPluginId())).count();
                    downloaded.titleWithCount(Math.toIntExact(enabledNonBundledCount));
                    if (downloaded.ui == null) {
                        this.myInstalledPanel.addGroup(downloaded);
                    }
                    this.myPluginModelFacade.getModel().addEnabledGroup(downloaded);
                }
                String defaultCategory = IdeBundle.message((String)"plugins.configurable.other.bundled", (Object[])new Object[0]);
                visibleBundledPlugins.stream().collect(Collectors.groupingBy(descriptor2 -> StringUtil.defaultIfEmpty((String)descriptor2.getDisplayCategory(), (String)defaultCategory))).entrySet().stream().map(entry -> new ComparablePluginsGroup((String)entry.getKey(), (List)entry.getValue(), model2.getVisiblePluginsRequiresUltimate())).sorted((o1, o2) -> defaultCategory.equals(o1.title) ? 1 : (defaultCategory.equals(o2.title) ? -1 : o1.compareTo((ComparablePluginsGroup)o2))).forEachOrdered(group2 -> {
                    group2.getPreloadedModel().setErrors(model2.getErrors());
                    group2.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                    this.myInstalledPanel.addGroup((PluginsGroup)group2);
                    this.myPluginModelFacade.getModel().addEnabledGroup((PluginsGroup)group2);
                });
                this.myUpdateAllBundled.setListener((LinkListener)updateAllListener, null);
                this.myBundledUpdateGroup.addRightAction((JComponent)this.myUpdateAllBundled);
                this.myBundledUpdateGroup.addRightAction(this.myUpdateCounterBundled);
                this.myPluginUpdatesService.calculateUpdates(updates -> {
                    if (ContainerUtil.isEmpty((Collection)updates)) {
                        PluginManagerConfigurablePanel.clearUpdates(this.myInstalledPanel);
                        PluginManagerConfigurablePanel.clearUpdates(this.myInstalledSearchPanel.getPanel());
                    } else {
                        PluginManagerConfigurablePanel.applyUpdates(this.myInstalledPanel, updates);
                        PluginManagerConfigurablePanel.applyUpdates(this.myInstalledSearchPanel.getPanel(), updates);
                    }
                    this.applyBundledUpdates((Collection<? extends PluginUiModel>)updates);
                    selectionListener2.accept(this.myInstalledPanel);
                    selectionListener2.accept(this.myInstalledSearchPanel.getPanel());
                });
            }
            finally {
                this.myInstalledPanel.stopLoading();
            }
            return null;
        }));
        JComponent jComponent = PluginManagerConfigurablePanel.createScrollPane(this.myInstalledPanel, true);
        if (jComponent == null) {
            InstalledPluginsTab.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Override
    protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            InstalledPluginsTab.$$$reportNull$$$0(7);
        }
        selectionListener2.accept(this.myInstalledPanel);
    }

    @Override
    public void hideSearchPanel() {
        super.hideSearchPanel();
        if (this.myInstalledSearchSetState) {
            for (AnAction action2 : this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                ((InstalledSearchOptionAction)action2).setState(null);
            }
        }
        this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
    }

    @Override
    protected void onSearchReset() {
        PluginManagerUsageCollector.INSTANCE.searchReset();
    }

    @Override
    @NotNull
    protected SearchResultPanel createSearchPanel(final @NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
        if (selectionListener2 == null) {
            InstalledPluginsTab.$$$reportNull$$$0(8);
        }
        SearchUpDownPopupController installedController = new SearchUpDownPopupController(this.searchTextField){

            @Override
            @NotNull
            @NonNls
            protected List<String> getAttributes() {
                List<String> list2 = Arrays.asList("/downloaded", "/outdated", "/enabled", "/disabled", "/invalid", "/bundled", SearchWords.VENDOR.getValue(), SearchWords.TAG.getValue());
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Nullable
            protected SortedSet<String> getValues(@NotNull String attribute) {
                if (attribute == null) {
                    3.$$$reportNull$$$0(1);
                }
                return SearchWords.VENDOR.getValue().equals(attribute) ? InstalledPluginsTab.this.myPluginModelFacade.getModel().getVendors() : (SearchWords.TAG.getValue().equals(attribute) ? InstalledPluginsTab.this.myPluginModelFacade.getModel().getTags() : null);
            }

            @Override
            protected void showPopupForQuery() {
                InstalledPluginsTab.this.showSearchPanel(InstalledPluginsTab.this.searchTextField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTab$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAttributes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getValues";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        installedController.setSearchResultEventHandler(eventHandler);
        PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                if (model2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (group2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (listPluginModel == null) {
                    4.$$$reportNull$$$0(2);
                }
                return new ListPluginComponent(InstalledPluginsTab.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)InstalledPluginsTab.this.searchListener, InstalledPluginsTab.this.myCoroutineScope, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "group";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "listPluginModel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/InstalledPluginsTab$4";
                objectArray[2] = "createListComponent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        panel2.setSelectionListener(selectionListener2);
        PluginManagerConfigurablePanel.registerCopyProvider(panel2);
        SearchResultPanel searchResultPanel = this.myInstalledSearchPanel = new SearchResultPanel(installedController, panel2, false, 0, 0){

            @Override
            protected void setEmptyText(@NotNull String query) {
                if (query == null) {
                    5.$$$reportNull$$$0(0);
                }
                this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.nothing.found", (Object[])new Object[0]));
                if (query.contains("/downloaded") || query.contains("/outdated") || query.contains("/enabled") || query.contains("/disabled") || query.contains("/invalid") || query.contains("/bundled")) {
                    return;
                }
                if (InstalledPluginsTab.this.mySearchInMarketplaceTabHandler != null) {
                    this.myPanel.getEmptyText().appendSecondaryText(IdeBundle.message((String)"plugins.configurable.search.in.marketplace", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> InstalledPluginsTab.this.mySearchInMarketplaceTabHandler.accept(query));
                }
            }

            @Override
            protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2, AtomicBoolean runQuery) {
                if (query == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    5.$$$reportNull$$$0(2);
                }
                int searchIndex = PluginManagerUsageCollector.updateAndGetSearchIndex();
                InstalledPluginsTab.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query);
                if (InstalledPluginsTab.this.myInstalledSearchSetState) {
                    for (AnAction action2 : InstalledPluginsTab.this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                        ((InstalledSearchOptionAction)action2).setState(parser);
                    }
                }
                List<PluginUiModel> descriptors2 = InstalledPluginsTab.this.myPluginModelFacade.getModel().getInstalledDescriptors();
                if (!parser.vendors.isEmpty()) {
                    Iterator<PluginUiModel> I = descriptors2.iterator();
                    while (I.hasNext()) {
                        if (MyPluginModel.isVendor(I.next(), parser.vendors)) continue;
                        I.remove();
                    }
                }
                if (!parser.tags.isEmpty()) {
                    String sessionId = InstalledPluginsTab.this.myPluginModelFacade.getModel().getSessionId();
                    Iterator<PluginUiModel> I = descriptors2.iterator();
                    while (I.hasNext()) {
                        if (ContainerUtil.intersects(PluginUiModelKt.calculateTags(I.next(), sessionId), parser.tags)) continue;
                        I.remove();
                    }
                }
                Iterator<PluginUiModel> I = descriptors2.iterator();
                while (I.hasNext()) {
                    PluginUiModel descriptor2 = I.next();
                    if (parser.attributes) {
                        if (!(!parser.enabled || InstalledPluginsTab.this.myPluginModelFacade.isEnabled(descriptor2) && InstalledPluginsTab.this.myPluginModelFacade.getErrors(descriptor2).isEmpty())) {
                            I.remove();
                            continue;
                        }
                        if (parser.disabled && (InstalledPluginsTab.this.myPluginModelFacade.isEnabled(descriptor2) || !InstalledPluginsTab.this.myPluginModelFacade.getErrors(descriptor2).isEmpty())) {
                            I.remove();
                            continue;
                        }
                        if (parser.bundled && !descriptor2.isBundled()) {
                            I.remove();
                            continue;
                        }
                        if (parser.downloaded && descriptor2.isBundled()) {
                            I.remove();
                            continue;
                        }
                        if (parser.invalid && InstalledPluginsTab.this.myPluginModelFacade.getErrors(descriptor2).isEmpty()) {
                            I.remove();
                            continue;
                        }
                        if (parser.needUpdate && !UiPluginManager.getInstance().isNeedUpdate(descriptor2.getPluginId())) {
                            I.remove();
                            continue;
                        }
                    }
                    if (parser.searchQuery == null || PluginManagerConfigurablePanel.containsQuery(descriptor2, parser.searchQuery)) continue;
                    I.remove();
                }
                result2.addModels(descriptors2);
                Map<PluginId, CheckErrorsResult> errors = UiPluginManager.getInstance().loadErrors(InstalledPluginsTab.this.myPluginModelFacade.getModel().mySessionId.toString(), ContainerUtil.map(descriptors2, PluginUiModel::getPluginId));
                result2.getPreloadedModel().setErrors(MyPluginModel.getErrors(errors));
                result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                PluginManagerUsageCollector.performInstalledTabSearch(ProjectUtil.getActiveProject(), parser, result2.getModels(), searchIndex, null);
                if (!result2.getModels().isEmpty()) {
                    if (parser.invalid) {
                        InstalledPluginsTab.this.myPluginModelFacade.getModel().setInvalidFixCallback(() -> {
                            PluginsGroup group2 = InstalledPluginsTab.this.myInstalledSearchPanel.getGroup();
                            if (group2.ui == null) {
                                InstalledPluginsTab.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                                return;
                            }
                            PluginsGroupComponent resultPanel = InstalledPluginsTab.this.myInstalledSearchPanel.getPanel();
                            for (PluginUiModel descriptor2 : new ArrayList<PluginUiModel>(group2.getModels())) {
                                if (!InstalledPluginsTab.this.myPluginModelFacade.getErrors(descriptor2).isEmpty()) continue;
                                resultPanel.removeFromGroup(group2, descriptor2);
                            }
                            group2.titleWithCount();
                            InstalledPluginsTab.this.myInstalledSearchPanel.fullRepaint();
                            if (group2.getModels().isEmpty()) {
                                InstalledPluginsTab.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                                InstalledPluginsTab.this.myInstalledSearchPanel.removeGroup();
                            }
                        });
                    } else if (parser.needUpdate) {
                        result2.rightAction = new PluginManagerConfigurablePanel.LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null, (__, ___) -> {
                            result2.rightAction.setEnabled(false);
                            for (ListPluginComponent plugin : result2.ui.plugins) {
                                plugin.updatePlugin();
                            }
                        });
                    }
                    PluginModelAsyncOperationsExecutor.INSTANCE.loadUpdates(InstalledPluginsTab.this.myCoroutineScope, (Function1<? super List<? extends PluginUiModel>, Unit>)((Function1)updates -> {
                        if (!ContainerUtil.isEmpty((Collection)updates)) {
                            this.myPostFillGroupCallback = () -> {
                                PluginManagerConfigurablePanel.applyUpdates(this.myPanel, updates);
                                selectionListener2.accept(InstalledPluginsTab.this.myInstalledPanel);
                                selectionListener2.accept(InstalledPluginsTab.this.myInstalledSearchPanel.getPanel());
                            };
                        }
                        return null;
                    }));
                }
                this.updatePanel(runQuery);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "query";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setEmptyText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuery";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (searchResultPanel == null) {
            InstalledPluginsTab.$$$reportNull$$$0(9);
        }
        return searchResultPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSearchOptionSelection(final InstalledSearchOptionAction updateAction2) {
        final ArrayList<String> queries = new ArrayList<String>();
        new SearchQueryParser.Installed(this, this.searchTextField.getText()){

            @Override
            protected void addToSearchQuery(@NotNull String query) {
                if (query == null) {
                    6.$$$reportNull$$$0(0);
                }
                queries.add(query);
            }

            @Override
            protected void handleAttribute(@NotNull String name2, @NotNull String value) {
                if (name2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (value == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (!updateAction2.myIsSelected) {
                    queries.add(name2 + (value.isEmpty() ? "" : SearchQueryParser.wrapAttribute(value)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "query";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addToSearchQuery";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (updateAction2.myIsSelected) {
            for (AnAction action2 : this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                if (action2 == updateAction2) continue;
                ((InstalledSearchOptionAction)action2).myIsSelected = false;
            }
            queries.add(updateAction2.getQuery());
        } else {
            queries.remove(updateAction2.getQuery());
        }
        try {
            this.myInstalledSearchSetState = false;
            String query = StringUtil.join(queries, (String)" ");
            this.searchTextField.setTextIgnoreEvents(query);
            if (query.isEmpty()) {
                this.hideSearchPanel();
            } else {
                this.showSearchPanel(query);
            }
        }
        finally {
            this.myInstalledSearchSetState = true;
        }
    }

    private void applyBundledUpdates(@Nullable Collection<? extends PluginUiModel> updates) {
        if (ContainerUtil.isEmpty(updates)) {
            if (this.myBundledUpdateGroup.ui != null) {
                this.getInstalledPanel().removeGroup(this.myBundledUpdateGroup);
                this.getInstalledPanel().doLayout();
            }
        } else if (this.myBundledUpdateGroup.ui == null) {
            block0: for (PluginUiModel pluginUiModel : updates) {
                for (UIPluginGroup group2 : this.getInstalledPanel().getGroups()) {
                    ListPluginComponent component2 = group2.findComponent(pluginUiModel.getPluginId());
                    if (component2 == null || !component2.getPluginModel().isBundled()) continue;
                    this.myBundledUpdateGroup.addModel(component2.getPluginModel());
                    continue block0;
                }
            }
            if (!this.myBundledUpdateGroup.getModels().isEmpty()) {
                this.getInstalledPanel().addGroup(this.myBundledUpdateGroup, 0);
                this.myBundledUpdateGroup.ui.excluded = true;
                for (PluginUiModel pluginUiModel : updates) {
                    ListPluginComponent listPluginComponent = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                    if (listPluginComponent == null) continue;
                    listPluginComponent.setUpdateDescriptor(pluginUiModel);
                }
                this.getInstalledPanel().doLayout();
            }
        } else {
            ArrayList<ListPluginComponent> toDelete = new ArrayList<ListPluginComponent>();
            for (ListPluginComponent listPluginComponent : this.myBundledUpdateGroup.ui.plugins) {
                boolean exist = false;
                for (PluginUiModel pluginUiModel : updates) {
                    if (!listPluginComponent.getPluginModel().getPluginId().equals((Object)pluginUiModel.getPluginId())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                toDelete.add(listPluginComponent);
            }
            for (ListPluginComponent listPluginComponent : toDelete) {
                this.getInstalledPanel().removeFromGroup(this.myBundledUpdateGroup, listPluginComponent.getPluginModel());
            }
            block6: for (PluginUiModel pluginUiModel : updates) {
                ListPluginComponent exist = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                if (exist != null) continue;
                for (UIPluginGroup uIPluginGroup : this.getInstalledPanel().getGroups()) {
                    ListPluginComponent component5;
                    if (uIPluginGroup == this.myBundledUpdateGroup.ui || (component5 = uIPluginGroup.findComponent(pluginUiModel.getPluginId())) == null || !component5.getPluginModel().isBundled()) continue;
                    this.getInstalledPanel().addToGroup(this.myBundledUpdateGroup, component5.getPluginModel());
                    continue block6;
                }
            }
            if (this.myBundledUpdateGroup.getModels().isEmpty()) {
                this.getInstalledPanel().removeGroup(this.myBundledUpdateGroup);
            } else {
                for (PluginUiModel pluginUiModel : updates) {
                    ListPluginComponent component6 = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                    if (component6 == null) continue;
                    component6.setUpdateDescriptor(pluginUiModel);
                }
            }
            this.getInstalledPanel().doLayout();
        }
        this.myUpdateAll.setVisible(this.myUpdateAll.isVisible() && this.myBundledUpdateGroup.ui == null);
        this.myUpdateCounter.setVisible(this.myUpdateCounter.isVisible() && this.myBundledUpdateGroup.ui == null);
    }

    void onPluginUpdatesRecalculation(Integer updatesCount, @Nls String tooltip) {
        int count = updatesCount == null ? 0 : updatesCount;
        String text2 = Integer.toString(count);
        boolean visible = count > 0;
        this.myUpdateAll.setEnabled(true);
        this.myUpdateAllBundled.setEnabled(true);
        this.myUpdateAll.setVisible(visible && this.myBundledUpdateGroup.ui == null);
        this.myUpdateAllBundled.setVisible(visible);
        this.myUpdateCounter.setText(text2);
        this.myUpdateCounter.setToolTipText(tooltip);
        this.myUpdateCounterBundled.setText(text2);
        this.myUpdateCounterBundled.setToolTipText(tooltip);
        this.myUpdateCounter.setVisible(visible && this.myBundledUpdateGroup.ui == null);
        this.myUpdateCounterBundled.setVisible(visible);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTab";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetailsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginsPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsPanel";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPluginsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateMainSelection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSearchPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9 -> new IllegalStateException(string);
        };
    }

    private static enum InstalledSearchOption {
        Downloaded(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Downloaded", (Object[])new Object[0])),
        NeedUpdate(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.NeedUpdate", (Object[])new Object[0])),
        Enabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Enabled", (Object[])new Object[0])),
        Disabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Disabled", (Object[])new Object[0])),
        Invalid(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Invalid", (Object[])new Object[0])),
        Bundled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Bundled", (Object[])new Object[0]));

        private final Supplier<@Nls String> myPresentableNameSupplier;

        private InstalledSearchOption(Supplier<String> name2) {
            this.myPresentableNameSupplier = name2;
        }
    }

    private final class InstalledSearchOptionAction
    extends ToggleAction
    implements DumbAware {
        private final InstalledSearchOption myOption;
        private boolean myIsSelected;

        private InstalledSearchOptionAction(InstalledSearchOption option2) {
            if (option2 == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(0);
            }
            super(option2.myPresentableNameSupplier);
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(1);
            }
            return this.myIsSelected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(2);
            }
            this.myIsSelected = state2;
            InstalledPluginsTab.this.handleSearchOptionSelection(this);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void setState(@Nullable SearchQueryParser.Installed parser) {
            if (parser == null) {
                this.myIsSelected = false;
                return;
            }
            this.myIsSelected = switch (this.myOption.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> parser.enabled;
                case 3 -> parser.disabled;
                case 0 -> parser.downloaded;
                case 5 -> parser.bundled;
                case 4 -> parser.invalid;
                case 1 -> parser.needUpdate;
            };
        }

        @NotNull
        public String getQuery() {
            Object object = this.myOption == InstalledSearchOption.NeedUpdate ? "/outdated" : "/" + StringUtil.decapitalize((String)this.myOption.name());
            if (object == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTab$InstalledSearchOptionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab$InstalledSearchOptionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private final class ComparablePluginsGroup
    extends PluginsGroup
    implements Comparable<ComparablePluginsGroup> {
        private boolean myIsEnable;

        private ComparablePluginsGroup(@NotNull String category, @NotNull List<PluginUiModel> descriptors2, Map<PluginId, Boolean> pluginsRequiresUltimate) {
            if (category == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(0);
            }
            if (descriptors2 == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(1);
            }
            if (pluginsRequiresUltimate == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(2);
            }
            super(category, PluginsGroupType.INSTALLED);
            this.myIsEnable = false;
            this.addModels(descriptors2);
            this.sortByName();
            this.rightAction = new PluginManagerConfigurablePanel.LinkLabelButton("", null, (__, ___) -> this.setEnabledState());
            boolean hasPluginsAvailableForEnableDisable = ContainerUtil.exists(descriptors2, it -> (Boolean)pluginsRequiresUltimate.get(it.getPluginId()) == false);
            this.rightAction.setVisible(hasPluginsAvailableForEnableDisable);
            this.titleWithEnabled(InstalledPluginsTab.this.myPluginModelFacade);
        }

        @Override
        public int compareTo(@NotNull ComparablePluginsGroup other) {
            if (other == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(3);
            }
            return StringUtil.compare((String)this.title, (String)other.title, (boolean)true);
        }

        @Override
        public void titleWithCount(int enabled2) {
            this.myIsEnable = enabled2 == 0;
            String key = this.myIsEnable ? "plugins.configurable.enable.all" : "plugins.configurable.disable.all";
            this.rightAction.setText(IdeBundle.message((String)key, (Object[])new Object[0]));
        }

        private void setEnabledState() {
            PluginManagerConfigurablePanel.setState(InstalledPluginsTab.this.myPluginModelFacade, this.getModels(), this.myIsEnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginsRequiresUltimate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTab$ComparablePluginsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

