/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.CannotUndoReportDialog;
import com.intellij.openapi.command.impl.UndoReportHandler;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultUndoReportHandler
implements UndoReportHandler {
    private static final Logger LOG = Logger.getInstance(DefaultUndoReportHandler.class);

    DefaultUndoReportHandler() {
    }

    @Override
    public boolean reportNonUndoable(@Nullable Project project2, @Nls @NotNull String operationName, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        if (operationName == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(0);
        }
        if (problemFiles == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(1);
        }
        String message = IdeBundle.message((String)"cannot.undo.error.contains.nonundoable.changes.message", (Object[])new Object[]{operationName});
        return this.reportGeneric(project2, message, problemFiles);
    }

    @Override
    public boolean reportClashingDocuments(@Nullable Project project2, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        if (problemFiles == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(2);
        }
        return this.reportGeneric(project2, IdeBundle.message((String)"cannot.undo.error.other.affected.files.changed.message", (Object[])new Object[0]), problemFiles);
    }

    @Override
    public boolean reportCannotAdjust(@Nullable Project project2, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        if (problemFiles == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(3);
        }
        return this.reportGeneric(project2, IdeBundle.message((String)"cannot.undo.error.other.users.overwrote.changes.message", (Object[])new Object[0]), problemFiles);
    }

    @Override
    public boolean reportException(@Nullable Project project2, @NotNull UnexpectedUndoException exception, boolean isUndo) {
        Object message;
        String title2;
        if (exception == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(4);
        }
        if (isUndo) {
            title2 = IdeBundle.message((String)"cannot.undo.title", (Object[])new Object[0]);
            message = IdeBundle.message((String)"cannot.undo.message", (Object[])new Object[0]);
        } else {
            title2 = IdeBundle.message((String)"cannot.redo.title", (Object[])new Object[0]);
            message = IdeBundle.message((String)"cannot.redo.message", (Object[])new Object[0]);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (exception.getMessage() != null) {
                message = (String)message + ".\n" + exception.getMessage();
            }
            Messages.showMessageDialog((Project)project2, (String)message, (String)title2, (Icon)Messages.getErrorIcon());
        } else {
            LOG.error((Throwable)exception);
        }
        return true;
    }

    @Override
    public boolean reportGeneric(@Nullable Project project2, @NlsContexts.DialogMessage String message, @NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            DefaultUndoReportHandler.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message + "\n" + StringUtil.join(problemFiles, (String)"\n"));
        }
        new CannotUndoReportDialog(project2, message, problemFiles).show();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/DefaultUndoReportHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportNonUndoable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportClashingDocuments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCannotAdjust";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportException";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportGeneric";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

