/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.ClientFileChooserFactory;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.fileChooser.impl.NativeFileChooserDialogImpl;
import com.intellij.openapi.fileChooser.impl.NativeFileSaverDialogImpl;
import com.intellij.openapi.fileChooser.impl.NewFileChooserDialogImpl;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelDescriptorWithoutNativeFileChooserSupport;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import javax.swing.JTextField;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LocalFileChooserFactory
implements ClientFileChooserFactory {
    @Override
    @NotNull
    public FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        PathChooserDialog chooser;
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(0);
        }
        return (chooser = LocalFileChooserFactory.createNativePathChooserIfEnabled(descriptor2, project2, parent)) != null ? (FileChooserDialog)chooser : (LocalFileChooserFactory.useNewChooser(descriptor2) ? new NewFileChooserDialogImpl(descriptor2, parent, project2) : (parent != null ? new FileChooserDialogImpl(descriptor2, parent, project2) : new FileChooserDialogImpl(descriptor2, project2)));
    }

    @Override
    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        PathChooserDialog chooser;
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(1);
        }
        return (chooser = LocalFileChooserFactory.createNativePathChooserIfEnabled(descriptor2, project2, parent)) != null ? chooser : (LocalFileChooserFactory.useNewChooser(descriptor2) ? new NewFileChooserDialogImpl(descriptor2, parent, project2) : (parent != null ? new FileChooserDialogImpl(descriptor2, parent, project2) : new FileChooserDialogImpl(descriptor2, project2)));
    }

    @Override
    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(2);
        }
        return new FileTextFieldImpl(new JTextField(), new LocalFsFinder(), new LocalFsFinder.FileChooserFilter(descriptor2, showHidden), FileChooserFactoryImpl.getMacroMap(), parent);
    }

    @Override
    public void installFileCompletion(@NotNull JTextField field, @NotNull FileChooserDescriptor descriptor2, boolean showHidden, @Nullable Disposable parent) {
        if (field == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(4);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new FileTextFieldImpl(field, new LocalFsFinder(), new LocalFsFinder.FileChooserFilter(descriptor2, showHidden), FileChooserFactoryImpl.getMacroMap(), parent);
        }
    }

    @Override
    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @Nullable Project project2) {
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(5);
        }
        return LocalFileChooserFactory.canUseNativeDialog((FileChooserDescriptor)descriptor2, project2) ? new NativeFileSaverDialogImpl(descriptor2, project2) : new FileSaverDialogImpl(descriptor2, project2);
    }

    @Override
    @NotNull
    public FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor descriptor2, @NotNull Component parent) {
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(7);
        }
        return LocalFileChooserFactory.canUseNativeDialog((FileChooserDescriptor)descriptor2, null) ? new NativeFileSaverDialogImpl(descriptor2, parent) : new FileSaverDialogImpl(descriptor2, parent);
    }

    @Nullable
    static PathChooserDialog createNativePathChooserIfEnabled(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project2, @Nullable Component parent) {
        if (descriptor2 == null) {
            LocalFileChooserFactory.$$$reportNull$$$0(8);
        }
        return LocalFileChooserFactory.canUseNativeDialog(descriptor2, project2) ? new NativeFileChooserDialogImpl(descriptor2, parent, project2) : null;
    }

    private static boolean canUseNativeDialog(FileChooserDescriptor descriptor2, @Nullable Project project2) {
        EelDescriptor eelDescriptor;
        Project currProject;
        Project project3 = currProject = project2 != null ? project2 : ProjectUtil.getActiveProject();
        if (currProject != null && (eelDescriptor = EelProviderUtil.getEelDescriptor((Project)currProject)) instanceof EelDescriptorWithoutNativeFileChooserSupport) {
            return false;
        }
        return !(descriptor2.isForcedToUseIdeaFileChooser() || !SystemInfo.isJetBrainsJvm || !SystemInfo.isWindows && !SystemInfo.isMac || ApplicationManager.getApplication() != null && !AdvancedSettings.getBoolean((String)"ide.ui.native.file.chooser"));
    }

    private static boolean useNewChooser(FileChooserDescriptor descriptor2) {
        return Registry.is((String)"ide.ui.new.file.chooser") && ContainerUtil.and((Iterable)descriptor2.getRoots(), VirtualFile::isInLocalFileSystem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileChooser/impl/LocalFileChooserFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPathChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileTextField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installFileCompletion";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createSaveFileDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createNativePathChooserIfEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

