/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u001bJ\u0006\u0010,\u001a\u00020\u001bJ\b\u0010-\u001a\u00020\u001bH\u0002J\u000e\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00060"}, d2={"Lcom/intellij/openapi/wm/impl/content/AdditionalIcon;", "", "action", "Lcom/intellij/openapi/wm/impl/content/tabActions/ContentTabAction;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/tabActions/ContentTabAction;)V", "getAction", "()Lcom/intellij/openapi/wm/impl/content/tabActions/ContentTabAction;", "icon", "Lcom/intellij/openapi/ui/popup/ActiveIcon;", "getIcon", "()Lcom/intellij/openapi/ui/popup/ActiveIcon;", "afterText", "", "getAfterText", "()Z", "available", "getAvailable", "runAction", "", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "active", "getActive", "height", "", "getHeight", "()I", "x", "getX", "setX", "(I)V", "centerPoint", "Ljava/awt/Point;", "getCenterPoint", "()Ljava/awt/Point;", "paintIcon", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "getIconWidth", "getIconHeight", "getIconY", "contains", "point", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class AdditionalIcon {
    @NotNull
    private final ContentTabAction action;
    private int x;

    public AdditionalIcon(@NotNull ContentTabAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.action = action2;
    }

    @NotNull
    public final ContentTabAction getAction() {
        return this.action;
    }

    @NotNull
    public final ActiveIcon getIcon() {
        return this.action.getIcon();
    }

    public final boolean getAfterText() {
        return this.action.getAfterText();
    }

    public final boolean getAvailable() {
        return this.action.getAvailable();
    }

    public final void runAction() {
        this.action.runAction();
    }

    @NlsContexts.Tooltip
    @Nullable
    public final String getTooltip() {
        return this.action.getTooltip();
    }

    public abstract boolean getActive();

    public abstract int getHeight();

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    @NotNull
    public final Point getCenterPoint() {
        return new Point(this.x + this.getIconWidth() / 2, this.getIconY());
    }

    public final void paintIcon(@NotNull Component c, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.getIcon().setActive(this.getActive());
        this.getIcon().paintIcon(c, g, this.x, this.getIconY());
    }

    public final int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    public final int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    private final int getIconY() {
        return (this.getHeight() - this.getIconHeight()) / 2 + 1;
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return new Rectangle(this.x, 0, this.getIconWidth(), this.getHeight()).contains(point);
    }
}

