/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.learnIde;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.LearnIdeContentColorsAndFonts;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/HeightLimitedPane;", "Ljavax/swing/JTextPane;", "text", "", "relativeFontSize", "", "fontColor", "Lcom/intellij/ui/JBColor;", "isBold", "", "maximumWidth", "<init>", "(Ljava/lang/String;ILcom/intellij/ui/JBColor;ZLjava/lang/Integer;)V", "getFontColor", "()Lcom/intellij/ui/JBColor;", "Ljava/lang/Integer;", "style", "Ljavax/swing/text/SimpleAttributeSet;", "getStyle", "()Ljavax/swing/text/SimpleAttributeSet;", "getMaximumSize", "Ljava/awt/Dimension;", "setUI", "", "ui", "Ljavax/swing/plaf/TextUI;", "adjustFont", "Lcom/intellij/util/ui/JBFont;", "Lorg/jetbrains/annotations/NotNull;", "updateUI", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class HeightLimitedPane
extends JTextPane {
    private final int relativeFontSize;
    @NotNull
    private final JBColor fontColor;
    private final boolean isBold;
    @Nullable
    private final Integer maximumWidth;
    @NotNull
    private final SimpleAttributeSet style;

    public HeightLimitedPane(@NotNull String text2, int relativeFontSize, @NotNull JBColor fontColor, boolean isBold, @Nullable Integer maximumWidth) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fontColor, (String)"fontColor");
        this.relativeFontSize = relativeFontSize;
        this.fontColor = fontColor;
        this.isBold = isBold;
        this.maximumWidth = maximumWidth;
        this.style = new SimpleAttributeSet();
        this.setBorder((Border)JBUI.Borders.empty());
        this.setEditable(false);
        StyleConstants.setFontFamily(this.style, JBUI.Fonts.label().getFontName());
        if (this.isBold) {
            StyleConstants.setBold(this.style, true);
        }
        StyleConstants.setForeground(this.style, (Color)this.fontColor);
        StyleConstants.setFontSize(this.style, this.adjustFont().getSize());
        this.getDocument().insertString(0, text2, this.style);
        this.getStyledDocument().setCharacterAttributes(0, text2.length(), this.style, true);
        this.getStyledDocument().setParagraphAttributes(0, text2.length(), this.style, true);
        this.setOpaque(false);
        this.setEditable(false);
        this.setAlignmentX(0.0f);
        this.setHighlighter(null);
        this.setCaret(new DefaultCaret(){

            @Override
            public void mousePressed(MouseEvent e) {
                MouseListener[] mouseListenerArray = this.getParent().getMouseListeners();
                Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
                Object[] $this$forEach$iv = mouseListenerArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MouseListener it = (MouseListener)element$iv;
                    boolean bl = false;
                    it.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MouseListener[] mouseListenerArray = this.getParent().getMouseListeners();
                Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
                Object[] $this$forEach$iv = mouseListenerArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MouseListener it = (MouseListener)element$iv;
                    boolean bl = false;
                    it.mouseReleased(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseListener[] mouseListenerArray = this.getParent().getMouseListeners();
                Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
                Object[] $this$forEach$iv = mouseListenerArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MouseListener it = (MouseListener)element$iv;
                    boolean bl = false;
                    it.mouseEntered(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseListener[] mouseListenerArray = this.getParent().getMouseListeners();
                Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
                Object[] $this$forEach$iv = mouseListenerArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MouseListener it = (MouseListener)element$iv;
                    boolean bl = false;
                    it.mouseExited(e);
                }
            }
        });
    }

    public /* synthetic */ HeightLimitedPane(String string, int n, JBColor jBColor, boolean bl, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        this(string, n, jBColor, bl, n2);
    }

    @NotNull
    public final JBColor getFontColor() {
        return this.fontColor;
    }

    @NotNull
    public final SimpleAttributeSet getStyle() {
        return this.style;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        if (this.maximumWidth == null) {
            Dimension dimension = this.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            return dimension;
        }
        return new Dimension(this.getWidth(), this.getPreferredSize().height);
    }

    @Override
    public void setUI(@Nullable TextUI ui) {
        super.setUI(ui);
        if (this.getFont() != null) {
            this.setFont(new FontUIResource((Font)this.adjustFont()));
        }
    }

    private final JBFont adjustFont() {
        JBFont jBFont = JBUI.Fonts.label().deriveFont(JBUI.Fonts.label().getSize2D() + (float)JBUIScale.scale((int)this.relativeFontSize) + (float)(SystemInfo.isWindows ? JBUIScale.scale((int)1) : 0));
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"deriveFont(...)");
        return jBFont;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getFont() != null && this.style != null) {
            StyleConstants.setFontSize(this.style, this.getFont().getSize());
            this.getStyledDocument().setCharacterAttributes(0, this.getText().length(), this.style, true);
            this.getStyledDocument().setParagraphAttributes(0, this.getText().length(), LearnIdeContentColorsAndFonts.INSTANCE.getPARAGRAPH_STYLE(), true);
        }
    }
}

