/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class HideableDecorator {
    private static final String ACTION_KEY = "Collapse/Expand on mnemonic";
    private final JPanel myPanel;
    private final TitledSeparator myTitledSeparator;
    private final boolean myAdjustWindow;
    private boolean myOn;
    private JComponent myContent;
    private Dimension myPreviousContentSize;

    public HideableDecorator(JPanel panel2, @NlsContexts.Separator String title2, boolean adjustWindow) {
        this(panel2, title2, adjustWindow, null);
    }

    public HideableDecorator(JPanel panel2, @NlsContexts.Separator String title2, boolean adjustWindow, @Nullable JComponent northEastComponent) {
        this.myPanel = panel2;
        this.myAdjustWindow = adjustWindow;
        this.myTitledSeparator = new TitledSeparator(title2, null){

            public void addNotify() {
                super.addNotify();
                HideableDecorator.this.registerMnemonic();
            }
        };
        UIUtil.applyDeprecatedBackground((JComponent)this.myTitledSeparator);
        JPanel northPanel2 = new JPanel(new BorderLayout());
        northPanel2.add((Component)this.myTitledSeparator, "Center");
        if (northEastComponent != null) {
            northPanel2.add((Component)northEastComponent, "East");
        }
        this.myPanel.add((Component)northPanel2, "North");
        this.myTitledSeparator.setCursor(Cursor.getPredefinedCursor(12));
        this.updateIcon();
        this.myTitledSeparator.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (HideableDecorator.this.myOn) {
                    HideableDecorator.this.off();
                } else {
                    HideableDecorator.this.on();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/HideableDecorator$2", "mouseReleased"));
            }
        });
    }

    private void updateIcon() {
        Icon icon2 = this.myOn ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight;
        this.myTitledSeparator.getLabel().setIcon(icon2);
        this.myTitledSeparator.getLabel().setDisabledIcon(IconLoader.getTransparentIcon((Icon)icon2, (float)0.5f));
    }

    public void setContentComponent(@Nullable JComponent content2) {
        if (content2 == null && this.myContent != null) {
            this.myPanel.remove(this.myContent);
        }
        this.myContent = content2;
        if (this.myContent != null) {
            this.myContent.setVisible(this.myOn);
            this.myPanel.add((Component)this.myContent, "Center");
        }
    }

    public void setOn(boolean on) {
        this.myOn = on;
        if (this.myOn) {
            this.on();
        } else {
            this.off();
        }
    }

    public boolean isExpanded() {
        return this.myOn;
    }

    public void setTitle(@NlsContexts.Separator String title2) {
        this.myTitledSeparator.setText(title2);
    }

    @NlsContexts.Separator
    public String getTitle() {
        return this.myTitledSeparator.getText();
    }

    protected void on() {
        this.myOn = true;
        this.updateIcon();
        this.myTitledSeparator.getLabel().setIconTextGap(5);
        if (this.myContent != null) {
            this.myContent.setVisible(true);
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    protected void off() {
        this.myOn = false;
        this.updateIcon();
        if (this.myContent != null) {
            this.myContent.setVisible(false);
            this.myPreviousContentSize = this.myContent.getSize();
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    private void adjustWindow() {
        Window window;
        if (this.myAdjustWindow && (window = SwingUtilities.getWindowAncestor(this.myPanel)) != null) {
            Dimension size2;
            Dimension newSize;
            Dimension contentSize = this.myPreviousContentSize;
            if (contentSize == null || contentSize.width <= 0 || contentSize.height <= 0) {
                contentSize = this.myContent.getPreferredSize();
            }
            if (!(newSize = this.myOn ? new Dimension(Math.max(size2.width, this.myContent.getSize().width), size2.height + contentSize.height) : new Dimension(size2.width, size2.height - contentSize.height)).equals(size2 = window.getSize())) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (window.isShowing()) {
                        window.setSize(newSize);
                    }
                });
            }
        }
    }

    public void setEnabled(boolean enabled2) {
        this.myTitledSeparator.setEnabled(enabled2);
        this.myContent.setEnabled(enabled2);
    }

    private void registerMnemonic() {
        TextWithMnemonic text2 = TextWithMnemonic.parse((String)this.getTitle());
        int c = text2.getMnemonicCode();
        if (c != 0) {
            this.myPanel.getActionMap().put(ACTION_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (HideableDecorator.this.myOn) {
                        HideableDecorator.this.off();
                    } else {
                        HideableDecorator.this.on();
                    }
                }
            });
            this.myPanel.getInputMap(2).put(KeyStroke.getKeyStroke(c, 8, false), ACTION_KEY);
        }
    }
}

