/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    @Nullable
    private final Language myLanguage;
    @Nullable
    private final Project myProject;

    public LanguageTextField() {
        this(null, null, "");
    }

    public LanguageTextField(Language language, @Nullable Project project2, @NotNull String value) {
        if (value == null) {
            LanguageTextField.$$$reportNull$$$0(0);
        }
        this(language, project2, value, true);
    }

    public LanguageTextField(Language language, @Nullable Project project2, @NotNull String value, boolean oneLineMode) {
        if (value == null) {
            LanguageTextField.$$$reportNull$$$0(1);
        }
        this(language, project2, value, new SimpleDocumentCreator(), oneLineMode);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project2, @NotNull String value, @NotNull DocumentCreator documentCreator) {
        if (value == null) {
            LanguageTextField.$$$reportNull$$$0(2);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(3);
        }
        this(language, project2, value, documentCreator, true);
    }

    public LanguageTextField(@Nullable Language language, @Nullable Project project2, @NotNull String value, @NotNull DocumentCreator documentCreator, boolean oneLineMode) {
        if (value == null) {
            LanguageTextField.$$$reportNull$$$0(4);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(5);
        }
        super(documentCreator.createDocument(value, language, project2), project2, (FileType)(language != null ? language.getAssociatedFileType() : FileTypes.PLAIN_TEXT), language == null, oneLineMode);
        this.myLanguage = language;
        this.myProject = project2;
        this.setEnabled(language != null);
    }

    public static Document createDocument(String value, @Nullable Language language, @Nullable Project project2, @NotNull SimpleDocumentCreator documentCreator) {
        LanguageFileType fileType2;
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(6);
        }
        LanguageFileType languageFileType = fileType2 = language != null ? language.getAssociatedFileType() : null;
        if (fileType2 != null) {
            Document document2;
            Project notNullProject = project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
            PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)notNullProject);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> LanguageTextField.lambda$createDocument$0(factory2, (FileType)fileType2, value, stamp));
            documentCreator.customizePsiFile(psiFile);
            try (AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)psiFile.getVirtualFile(), (Project)notNullProject);){
                document2 = (Document)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)notNullProject).getDocument(psiFile));
            }
            assert (document2 != null);
            return document2;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)value);
    }

    @Override
    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor2 = super.createEditor();
        if (!(this.myLanguage == null || this.myProject != null && this.myProject.isDisposed())) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myLanguage, (Project)this.myProject, null);
            editor2.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(syntaxHighlighter, editor2.getColorsScheme()));
        }
        editor2.setEmbeddedIntoDialogWrapper(true);
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            LanguageTextField.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private static /* synthetic */ PsiFile lambda$createDocument$0(PsiFileFactory factory2, FileType fileType2, String value, long stamp) throws RuntimeException {
        return factory2.createFileFromText("Dummy." + fileType2.getDefaultExtension(), fileType2, (CharSequence)value, stamp, true, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCreator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LanguageTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LanguageTextField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    public static class SimpleDocumentCreator
    implements DocumentCreator {
        @Override
        public Document createDocument(String value, @Nullable Language language, Project project2) {
            return LanguageTextField.createDocument(value, language, project2, this);
        }

        public void customizePsiFile(PsiFile file2) {
        }
    }

    public static interface DocumentCreator {
        public Document createDocument(String var1, @Nullable Language var2, Project var3);
    }
}

