/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalPathCellEditor
extends AbstractTableCellEditor {
    @NlsContexts.DialogTitle
    private final String myTitle;
    private final Project myProject;
    private FileChooserDescriptor myFileChooserDescriptor;
    private boolean myNormalizePath;
    protected CellEditorComponentWithBrowseButton<JTextField> myComponent;

    public LocalPathCellEditor(@NlsContexts.DialogTitle @Nullable String title2, @Nullable Project project2) {
        this.myTitle = title2;
        this.myProject = project2;
    }

    public LocalPathCellEditor(@Nullable Project project2) {
        this(null, project2);
    }

    public LocalPathCellEditor() {
        this(null, null);
    }

    public LocalPathCellEditor fileChooserDescriptor(@NotNull FileChooserDescriptor value) {
        if (value == null) {
            LocalPathCellEditor.$$$reportNull$$$0(0);
        }
        this.myFileChooserDescriptor = value;
        return this;
    }

    public LocalPathCellEditor normalizePath(boolean value) {
        this.myNormalizePath = value;
        return this;
    }

    public Object getCellEditorValue() {
        @NlsSafe String value = this.myComponent.getChildComponent().getText();
        return this.myNormalizePath ? PathUtil.toSystemDependentName((String)StringUtil.nullize((String)value)) : value;
    }

    public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row2, int column) {
        this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(this.createActionListener(table2)), (TableCellEditor)((Object)this));
        this.myComponent.getChildComponent().setText((String)value);
        return this.myComponent;
    }

    protected ActionListener createActionListener(final JTable table2) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initial = (String)LocalPathCellEditor.this.getCellEditorValue();
                if (StringUtil.isEmpty((String)initial)) {
                    initial = LocalPathCellEditor.this.getDefaultPath();
                }
                VirtualFile initialFile = StringUtil.isNotEmpty((String)initial) ? LocalFileSystem.getInstance().findFileByPath(initial) : null;
                FileChooser.chooseFile((FileChooserDescriptor)LocalPathCellEditor.this.getFileChooserDescriptor(), (Project)LocalPathCellEditor.this.myProject, (Component)table2, (VirtualFile)initialFile, file2 -> {
                    Object path = file2.getPresentableUrl();
                    if (SystemInfo.isWindows && ((String)path).length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
                        path = (String)path + "\\";
                    }
                    LocalPathCellEditor.this.myComponent.getChildComponent().setText((String)path);
                });
            }
        };
    }

    protected String getDefaultPath() {
        return null;
    }

    public FileChooserDescriptor getFileChooserDescriptor() {
        if (this.myFileChooserDescriptor == null) {
            this.myFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            if (this.myTitle != null) {
                this.myFileChooserDescriptor.setTitle(this.myTitle);
            }
            this.myFileChooserDescriptor.setShowFileSystemRoots(true);
        }
        return this.myFileChooserDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/ui/LocalPathCellEditor", "fileChooserDescriptor"));
    }
}

