/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.zip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipException;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.utils.ByteBufferExtensionsKt;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J'\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001f\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010\f\u001a\u00020\rH\u0002J-\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010)\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils;", "", "<init>", "()V", "ZIP_EOCD_REC_MIN_SIZE", "", "ZIP_EOCD_REC_SIG", "ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET", "ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET", "ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET", "findZipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "zip", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "getModifiedEocdRecord", "Ljava/nio/ByteBuffer;", "inputZipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "additionalMetadataSize", "findZipSections", "zipSectionsInformation", "zipMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "findZipSections$lib", "setZipEocdCentralDirectoryOffset", "", "zipEndOfCentralDirectory", "offset", "Lkotlin/UInt;", "setZipEocdCentralDirectoryOffset-Qn1smSk$lib", "(Ljava/nio/ByteBuffer;I)V", "findEocdInBuffer", "Lkotlin/Pair;", "", "Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "maxCommentSize", "Lkotlin/UShort;", "findEocdInBuffer-i8woANY", "(Lorg/jetbrains/zip/signer/datasource/DataSource;S)Lkotlin/Pair;", "zipContents", "parseEOCD", "eocdSection", "ZipEocdData", "lib"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nZipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtils.kt\norg/jetbrains/zip/signer/zip/ZipUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class ZipUtils {
    @NotNull
    public static final ZipUtils INSTANCE = new ZipUtils();
    private static final int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static final int ZIP_EOCD_REC_SIG = 101010256;
    private static final int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static final int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;

    private ZipUtils() {
    }

    @NotNull
    public final ZipSectionsInformation findZipSectionsInformation(@NotNull DataSource zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer(zip);
        if (pair == null) {
            throw new ZipException("ZIP End of Central Directory record not found");
        }
        Pair<Long, ZipEocdData> pair2 = pair;
        long eocdOffset = ((Number)pair2.component1()).longValue();
        ZipEocdData eocd = (ZipEocdData)pair2.component2();
        long centralDirectoryEndOffset = ((long)eocd.getCentralDirectoryOffset-pVg5ArA() & 0xFFFFFFFFL) + ((long)eocd.getCentralDirectorySize-pVg5ArA() & 0xFFFFFFFFL);
        if (((long)eocd.getCentralDirectoryOffset-pVg5ArA() & 0xFFFFFFFFL) > eocdOffset) {
            throw new ZipException("ZIP Central Directory start offset out of range");
        }
        if (centralDirectoryEndOffset > eocdOffset) {
            throw new ZipException("ZIP Central Directory overlaps with End of Central Directory");
        }
        return new ZipSectionsInformation((long)eocd.getCentralDirectoryOffset-pVg5ArA() & 0xFFFFFFFFL, (long)eocd.getCentralDirectorySize-pVg5ArA() & 0xFFFFFFFFL, eocdOffset, (int)(zip.size() - eocdOffset));
    }

    @NotNull
    public final ByteBuffer getModifiedEocdRecord(@NotNull ZipSections inputZipSections, int additionalMetadataSize) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)inputZipSections, (String)"inputZipSections");
        ByteBuffer $this$getModifiedEocdRecord_u24lambda_u240 = byteBuffer = inputZipSections.getEndOfCentralDirectorySection().getByteBuffer(0L, (int)inputZipSections.getEndOfCentralDirectorySection().size());
        boolean bl = false;
        $this$getModifiedEocdRecord_u24lambda_u240.order(ByteOrder.LITTLE_ENDIAN);
        INSTANCE.setZipEocdCentralDirectoryOffset-Qn1smSk$lib($this$getModifiedEocdRecord_u24lambda_u240, UInt.constructor-impl((int)((int)(inputZipSections.getBeforeSigningBlockSection().size() + (long)additionalMetadataSize))));
        return byteBuffer;
    }

    @NotNull
    public final ZipSections findZipSections$lib(@NotNull DataSource zip, @NotNull ZipSectionsInformation zipSectionsInformation, @Nullable ZipMetadata zipMetadata) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Intrinsics.checkNotNullParameter((Object)zipSectionsInformation, (String)"zipSectionsInformation");
        ZipMetadata zipMetadata2 = zipMetadata;
        return new ZipSections(zip.slice(0L, zipSectionsInformation.getCentralDirectoryOffset() - (zipMetadata2 != null ? (long)zipMetadata2.getSize() : 0L)), zip.slice(zipSectionsInformation.getCentralDirectoryOffset(), zipSectionsInformation.getCentralDirectorySizeBytes()), zip.slice(zipSectionsInformation.getEndOfCentralDirectoryOffset(), zipSectionsInformation.getEndOfCentralDirectorySizeBytes()));
    }

    public final void setZipEocdCentralDirectoryOffset-Qn1smSk$lib(@NotNull ByteBuffer zipEndOfCentralDirectory, int offset) {
        Intrinsics.checkNotNullParameter((Object)zipEndOfCentralDirectory, (String)"zipEndOfCentralDirectory");
        if (!ByteBufferExtensionsKt.isLittleEndian(zipEndOfCentralDirectory)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBufferExtensionsKt.setUnsignedInt-jXDDuk8(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16, offset);
    }

    private final Pair<Long, ZipEocdData> findEocdInBuffer(DataSource zip) {
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer-i8woANY(zip, (short)0);
        if (pair == null) {
            pair = this.findEocdInBuffer-i8woANY(zip, (short)-1);
        }
        return pair;
    }

    private final Pair<Long, ZipEocdData> findEocdInBuffer-i8woANY(DataSource zip, short maxCommentSize) {
        Pair<Integer, ZipEocdData> pair;
        long fileSize = zip.size();
        if (fileSize < 22L) {
            return null;
        }
        int maxEocdSize = 22 + RangesKt.coerceAtMost((int)(maxCommentSize & 0xFFFF), (int)((int)fileSize - 22));
        long bufOffsetInFile = fileSize - (long)maxEocdSize;
        Pair<Integer, ZipEocdData> $this$findEocdInBuffer_i8woANY_u24lambda_u241 = pair = zip.getByteBuffer(bufOffsetInFile, maxEocdSize);
        boolean bl = false;
        $this$findEocdInBuffer_i8woANY_u24lambda_u241.order(ByteOrder.LITTLE_ENDIAN);
        Pair<Integer, ZipEocdData> buf = pair;
        Pair<Integer, ZipEocdData> pair2 = this.findEocdInBuffer((ByteBuffer)buf);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        int eocdOffsetInBuffer = ((Number)pair.component1()).intValue();
        ZipEocdData eocd = (ZipEocdData)pair.component2();
        return TuplesKt.to((Object)(bufOffsetInFile + (long)eocdOffsetInBuffer), (Object)eocd);
    }

    private final Pair<Integer, ZipEocdData> findEocdInBuffer(ByteBuffer zipContents) {
        if (!ByteBufferExtensionsKt.isLittleEndian(zipContents)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int eocdWithEmptyCommentStartPosition = zipContents.capacity() - 22;
        if (eocdWithEmptyCommentStartPosition < 0) {
            return null;
        }
        int possibleCommentLength = 0;
        int n = RangesKt.coerceAtMost((int)eocdWithEmptyCommentStartPosition, (int)(0xFFFFFFFF & 0xFFFF));
        if (possibleCommentLength <= n) {
            while (true) {
                ZipEocdData zipEocd;
                zipContents.position(eocdWithEmptyCommentStartPosition - possibleCommentLength);
                if (this.parseEOCD(zipContents) != null && (zipEocd.getCommentLength-Mh2AYeg() & 0xFFFF) == possibleCommentLength) {
                    return TuplesKt.to((Object)zipContents.position(), (Object)zipEocd);
                }
                if (possibleCommentLength == n) break;
                ++possibleCommentLength;
            }
        }
        return null;
    }

    private final ZipEocdData parseEOCD(ByteBuffer eocdSection) {
        ByteBuffer $this$parseEOCD_u24lambda_u242 = eocdSection;
        boolean bl = false;
        if (!ByteBufferExtensionsKt.isLittleEndian($this$parseEOCD_u24lambda_u242)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$parseEOCD_u24lambda_u242.getInt($this$parseEOCD_u24lambda_u242.position()) != 101010256) {
            return null;
        }
        return new ZipEocdData(ByteBufferExtensionsKt.getUnsignedInt($this$parseEOCD_u24lambda_u242, $this$parseEOCD_u24lambda_u242.position() + 16), ByteBufferExtensionsKt.getUnsignedInt($this$parseEOCD_u24lambda_u242, $this$parseEOCD_u24lambda_u242.position() + 12), ByteBufferExtensionsKt.getUnsignedShort($this$parseEOCD_u24lambda_u242, $this$parseEOCD_u24lambda_u242.position() + 20), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u000eJ.\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "", "centralDirectoryOffset", "Lkotlin/UInt;", "centralDirectorySize", "commentLength", "Lkotlin/UShort;", "<init>", "(IISLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCentralDirectoryOffset-pVg5ArA", "()I", "I", "getCentralDirectorySize-pVg5ArA", "getCommentLength-Mh2AYeg", "()S", "S", "component1", "component1-pVg5ArA", "component2", "component2-pVg5ArA", "component3", "component3-Mh2AYeg", "copy", "copy-EV3HgwY", "(IIS)Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "equals", "", "other", "hashCode", "", "toString", "", "lib"})
    private static final class ZipEocdData {
        private final int centralDirectoryOffset;
        private final int centralDirectorySize;
        private final short commentLength;

        private ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            this.centralDirectoryOffset = centralDirectoryOffset;
            this.centralDirectorySize = centralDirectorySize;
            this.commentLength = commentLength;
        }

        public final int getCentralDirectoryOffset-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int getCentralDirectorySize-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short getCommentLength-Mh2AYeg() {
            return this.commentLength;
        }

        public final int component1-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int component2-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short component3-Mh2AYeg() {
            return this.commentLength;
        }

        @NotNull
        public final ZipEocdData copy-EV3HgwY(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            return new ZipEocdData(centralDirectoryOffset, centralDirectorySize, commentLength, null);
        }

        public static /* synthetic */ ZipEocdData copy-EV3HgwY$default(ZipEocdData zipEocdData, int n, int n2, short s, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = zipEocdData.centralDirectoryOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = zipEocdData.centralDirectorySize;
            }
            if ((n3 & 4) != 0) {
                s = zipEocdData.commentLength;
            }
            return zipEocdData.copy-EV3HgwY(n, n2, s);
        }

        @NotNull
        public String toString() {
            return "ZipEocdData(centralDirectoryOffset=" + UInt.toString-impl((int)this.centralDirectoryOffset) + ", centralDirectorySize=" + UInt.toString-impl((int)this.centralDirectorySize) + ", commentLength=" + UShort.toString-impl((short)this.commentLength) + ')';
        }

        public int hashCode() {
            int result2 = UInt.hashCode-impl((int)this.centralDirectoryOffset);
            result2 = result2 * 31 + UInt.hashCode-impl((int)this.centralDirectorySize);
            result2 = result2 * 31 + UShort.hashCode-impl((short)this.commentLength);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ZipEocdData)) {
                return false;
            }
            ZipEocdData zipEocdData = (ZipEocdData)other;
            if (this.centralDirectoryOffset != zipEocdData.centralDirectoryOffset) {
                return false;
            }
            if (this.centralDirectorySize != zipEocdData.centralDirectorySize) {
                return false;
            }
            return this.commentLength == zipEocdData.commentLength;
        }

        public /* synthetic */ ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength, DefaultConstructorMarker $constructor_marker) {
            this(centralDirectoryOffset, centralDirectorySize, commentLength);
        }
    }
}

