/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.lexer;

import com.intellij.html.embedding.HtmlEmbeddedContentProvider;
import com.intellij.html.embedding.HtmlEmbeddedContentSupport;
import com.intellij.html.embedding.HtmlEmbedmentInfo;
import com.intellij.html.embedding.HtmlTagEmbeddedContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSModuleContentType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.postcss.PostCssLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.html.lexer.VueLexer;
import org.jetbrains.vuejs.lang.html.parser.VueElementTypes;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 82\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001fH\u0014J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020#H\u0002J$\u0010)\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u00182\b\u0010*\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u001c\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010.\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010/\u001a\u00020,H\u0002J\u0012\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u00102\u001a\u00020,2\b\u00103\u001a\u0004\u0018\u00010,H\u0002J\u0018\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u00182\u0006\u00101\u001a\u000206H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider;", "Lcom/intellij/html/embedding/HtmlTagEmbeddedContentProvider;", "lexer", "Lcom/intellij/lexer/BaseHtmlLexer;", "<init>", "(Lcom/intellij/lexer/BaseHtmlLexer;)V", "languageLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "getLanguageLevel", "()Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "langMode", "Lorg/jetbrains/vuejs/lang/LangMode;", "getLangMode", "()Lorg/jetbrains/vuejs/lang/LangMode;", "htmlCompatMode", "", "getHtmlCompatMode", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "interpolationConfig", "Lkotlin/Pair;", "", "getInterpolationConfig", "()Lkotlin/Pair;", "interestingTags", "", "isInterestedInTag", "tagName", "", "isInterestedInAttribute", "attributeName", "handleToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "range", "Lcom/intellij/openapi/util/TextRange;", "handleLangMode", "isBoundLang", "attributeValue", "createEmbedmentInfo", "Lcom/intellij/html/embedding/HtmlEmbedmentInfo;", "getClassicScriptOrTemplateTagInfo", "lang", "getBoundScriptLangTagInfo", "findEmbedmentInfo", "language", "wrapEmbedmentInfo", "embedmentInfo", "languageMatches", "scriptType", "Lcom/intellij/lang/Language;", "VueScriptEmbedmentInfo", "Companion", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueEmbeddedContentSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueEmbeddedContentSupport.kt\norg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1807#2,3:241\n1#3:244\n*S KotlinDebug\n*F\n+ 1 VueEmbeddedContentSupport.kt\norg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider\n*L\n99#1:241,3\n*E\n"})
public final class VueTagEmbeddedContentProvider
extends HtmlTagEmbeddedContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> interestingTags;

    public VueTagEmbeddedContentProvider(@NotNull BaseHtmlLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        super(lexer);
        Object[] objectArray = new String[]{"template", "script", "style"};
        this.interestingTags = CollectionsKt.listOf((Object[])objectArray);
    }

    private final JSLanguageLevel getLanguageLevel() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        return ((VueLexer)baseHtmlLexer).getLanguageLevel();
    }

    private final LangMode getLangMode() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        return ((VueLexer)baseHtmlLexer).getLangMode();
    }

    private final boolean getHtmlCompatMode() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        return ((VueLexer)baseHtmlLexer).getHtmlCompatMode();
    }

    private final Project getProject() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        return ((VueLexer)baseHtmlLexer).getProject();
    }

    private final Pair<String, String> getInterpolationConfig() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        return ((VueLexer)baseHtmlLexer).getInterpolationConfig();
    }

    protected boolean isInterestedInTag(@NotNull CharSequence tagName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Iterable $this$any$iv = this.interestingTags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.namesEqual(tagName, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isInterestedInAttribute(@NotNull CharSequence attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return this.namesEqual(attributeName, "lang") || this.namesEqual(attributeName, "type") && this.namesEqual(this.getTagName(), "script");
    }

    public void handleToken(@NotNull IElementType tokenType, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)tokenType, (Object)XmlTokenType.XML_EMPTY_ELEMENT_END) || Intrinsics.areEqual((Object)tokenType, (Object)XmlTokenType.XML_TAG_END)) {
            this.handleLangMode();
        }
        super.handleToken(tokenType, range);
    }

    private final void handleLangMode() {
        String attributeValue2;
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        VueLexer lexer = (VueLexer)baseHtmlLexer;
        if (lexer.getLexedLangMode() != LangMode.PENDING) {
            return;
        }
        CharSequence charSequence = this.getTagName();
        if (charSequence == null) {
            return;
        }
        CharSequence tagName = charSequence;
        CharSequence charSequence2 = this.getAttributeName();
        String attributeName = charSequence2 != null && (charSequence2 = StringsKt.trim((CharSequence)charSequence2)) != null ? ((Object)charSequence2).toString() : null;
        CharSequence charSequence3 = this.getAttributeValue();
        String string = charSequence3 != null && (charSequence3 = StringsKt.trim((CharSequence)charSequence3)) != null ? ((Object)charSequence3).toString() : (attributeValue2 = null);
        if (this.isBoundLang(tagName, attributeName, attributeValue2)) {
            lexer.setLexedLangMode(LangMode.Companion.fromAttrValue(attributeValue2));
        }
    }

    private final boolean isBoundLang(CharSequence tagName, String attributeName, String attributeValue2) {
        return (attributeName == null || this.namesEqual(attributeName, "lang")) && this.namesEqual(tagName, "script") && LangMode.Companion.getKnownAttrValues().contains(attributeValue2);
    }

    @Nullable
    protected HtmlEmbedmentInfo createEmbedmentInfo() {
        Object object;
        block5: {
            String attributeValue2;
            String attributeName;
            CharSequence tagName;
            block3: {
                block4: {
                    CharSequence charSequence = this.getTagName();
                    if (charSequence == null) {
                        return null;
                    }
                    tagName = charSequence;
                    CharSequence charSequence2 = this.getAttributeName();
                    attributeName = charSequence2 != null && (charSequence2 = StringsKt.trim((CharSequence)charSequence2)) != null ? ((Object)charSequence2).toString() : null;
                    CharSequence charSequence3 = this.getAttributeValue();
                    attributeValue2 = charSequence3 != null && (charSequence3 = StringsKt.trim((CharSequence)charSequence3)) != null ? ((Object)charSequence3).toString() : null;
                    if (!this.namesEqual(tagName, "style")) break block3;
                    object = Companion.styleLanguage(attributeValue2);
                    if (object == null) break block4;
                    Language it = object;
                    boolean bl = false;
                    HtmlEmbedmentInfo htmlEmbedmentInfo = HtmlEmbeddedContentSupport.Companion.getStyleTagEmbedmentInfo(it);
                    object = htmlEmbedmentInfo;
                    if (htmlEmbedmentInfo != null) break block5;
                }
                object = HtmlEmbeddedContentProvider.RAW_TEXT_EMBEDMENT;
                break block5;
            }
            object = this.isBoundLang(tagName, attributeName, attributeValue2) ? this.getBoundScriptLangTagInfo() : (this.namesEqual(tagName, "script") || this.namesEqual(tagName, "template") ? this.getClassicScriptOrTemplateTagInfo(tagName, attributeValue2) : null);
        }
        return object;
    }

    private final HtmlEmbedmentInfo getClassicScriptOrTemplateTagInfo(CharSequence tagName, String lang) {
        if (this.namesEqual(tagName, "template") && (lang == null || StringsKt.equals((String)lang, (String)"html", (boolean)true))) {
            return null;
        }
        return this.findEmbedmentInfo(lang);
    }

    private final HtmlEmbedmentInfo getBoundScriptLangTagInfo() {
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        Intrinsics.checkNotNull((Object)baseHtmlLexer, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
        if (!((VueLexer)baseHtmlLexer).isHighlighting()) {
            BaseHtmlLexer baseHtmlLexer2 = this.getLexer();
            Intrinsics.checkNotNull((Object)baseHtmlLexer2, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.lexer.VueLexer");
            LangMode langMode = ((VueLexer)baseHtmlLexer2).getLexedLangMode();
            return langMode.getScriptEmbedmentInfo$intellij_vuejs_backend();
        }
        return this.findEmbedmentInfo(this.getLangMode().getCanonicalAttrValue());
    }

    private final HtmlEmbedmentInfo findEmbedmentInfo(String language) {
        HtmlEmbedmentInfo htmlEmbedmentInfo;
        String string = language;
        if (string == null) {
            htmlEmbedmentInfo = HtmlEmbeddedContentSupport.Companion.getScriptTagEmbedmentInfo((Language)this.getLanguageLevel().getDialect());
        } else if (Intrinsics.areEqual((Object)string, (Object)"js")) {
            htmlEmbedmentInfo = HtmlEmbeddedContentSupport.Companion.getScriptTagEmbedmentInfo((Language)JavaScriptSupportLoader.ECMA_SCRIPT_6);
        } else if (Intrinsics.areEqual((Object)string, (Object)"ts")) {
            htmlEmbedmentInfo = HtmlEmbeddedContentSupport.Companion.getScriptTagEmbedmentInfo((Language)JavaScriptSupportLoader.TYPESCRIPT);
        } else {
            Collection collection = Language.findInstancesByMimeType((String)language);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findInstancesByMimeType(...)");
            Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
            Collection collection2 = Language.findInstancesByMimeType((String)("text/" + language));
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findInstancesByMimeType(...)");
            Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Iterable)collection2);
            Collection collection3 = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getRegisteredLanguages(...)");
            Sequence languageSequence = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection3), arg_0 -> VueTagEmbeddedContentProvider.findEmbedmentInfo$lambda$0(this, language, arg_0))), (Iterable)(StringUtil.containsIgnoreCase((String)language, (String)"template") ? CollectionsKt.listOf((Object)HTMLLanguage.INSTANCE) : CollectionsKt.emptyList()));
            htmlEmbedmentInfo = (HtmlEmbedmentInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)languageSequence, VueTagEmbeddedContentProvider::findEmbedmentInfo$lambda$1));
        }
        HtmlEmbedmentInfo p0 = htmlEmbedmentInfo;
        boolean bl = false;
        return this.wrapEmbedmentInfo(p0);
    }

    private final HtmlEmbedmentInfo wrapEmbedmentInfo(HtmlEmbedmentInfo embedmentInfo) {
        IElementType elementType;
        HtmlEmbedmentInfo htmlEmbedmentInfo = embedmentInfo;
        Object object = elementType = htmlEmbedmentInfo != null ? htmlEmbedmentInfo.getElementType() : null;
        return Intrinsics.areEqual((Object)elementType, (Object)XmlElementType.HTML_EMBEDDED_CONTENT) ? (HtmlEmbedmentInfo)new HtmlEmbedmentInfo(this){
            final /* synthetic */ VueTagEmbeddedContentProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public IElementType getElementType() {
                return VueElementTypes.INSTANCE.getVUE_EMBEDDED_CONTENT();
            }

            public Lexer createHighlightingLexer() {
                return (Lexer)new VueLexer(VueTagEmbeddedContentProvider.access$getLanguageLevel(this.this$0), VueTagEmbeddedContentProvider.access$getProject(this.this$0), (Pair<String, String>)VueTagEmbeddedContentProvider.access$getInterpolationConfig(this.this$0), VueTagEmbeddedContentProvider.access$getHtmlCompatMode(this.this$0), true, VueTagEmbeddedContentProvider.access$getLangMode(this.this$0));
            }
        } : (elementType == null ? HtmlEmbeddedContentProvider.RAW_TEXT_EMBEDMENT : (HtmlEmbedmentInfo)new HtmlEmbedmentInfo(elementType, embedmentInfo){
            final /* synthetic */ IElementType $elementType;
            final /* synthetic */ HtmlEmbedmentInfo $embedmentInfo;
            {
                this.$elementType = $elementType;
                this.$embedmentInfo = $embedmentInfo;
            }

            public IElementType getElementType() {
                return JSModuleContentType.toModuleContentType((IElementType)this.$elementType);
            }

            public Lexer createHighlightingLexer() {
                return this.$embedmentInfo.createHighlightingLexer();
            }
        });
    }

    private final boolean languageMatches(String scriptType, Language language) {
        return StringsKt.equals((String)scriptType, (String)language.getID(), (boolean)true) || FileTypeManager.getInstance().getFileTypeByExtension(scriptType) == language.getAssociatedFileType();
    }

    private static final boolean findEmbedmentInfo$lambda$0(VueTagEmbeddedContentProvider this$0, String $language, Language it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.languageMatches($language, it);
    }

    private static final HtmlEmbedmentInfo findEmbedmentInfo$lambda$1(Language it) {
        Intrinsics.checkNotNull((Object)it);
        return HtmlEmbeddedContentSupport.Companion.getScriptTagEmbedmentInfo(it);
    }

    public static final /* synthetic */ JSLanguageLevel access$getLanguageLevel(VueTagEmbeddedContentProvider $this) {
        return $this.getLanguageLevel();
    }

    public static final /* synthetic */ Project access$getProject(VueTagEmbeddedContentProvider $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ Pair access$getInterpolationConfig(VueTagEmbeddedContentProvider $this) {
        return $this.getInterpolationConfig();
    }

    public static final /* synthetic */ boolean access$getHtmlCompatMode(VueTagEmbeddedContentProvider $this) {
        return $this.getHtmlCompatMode();
    }

    public static final /* synthetic */ LangMode access$getLangMode(VueTagEmbeddedContentProvider $this) {
        return $this.getLangMode();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider$Companion;", "", "<init>", "()V", "styleLanguage", "Lcom/intellij/lang/Language;", "styleLang", "", "intellij.vuejs.backend"})
    @SourceDebugExtension(value={"SMAP\nVueEmbeddedContentSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueEmbeddedContentSupport.kt\norg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n296#2:241\n297#2:244\n13225#3,2:242\n1#4:245\n*S KotlinDebug\n*F\n+ 1 VueEmbeddedContentSupport.kt\norg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider$Companion\n*L\n230#1:241\n230#1:244\n232#1:242,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Nullable
        public final Language styleLanguage(@Nullable String styleLang) {
            Object v2;
            block6: {
                Object element$iv;
                boolean bl;
                void $this$firstOrNull$iv;
                CSSLanguage cssLanguage = CSSLanguage.INSTANCE;
                if (styleLang == null) return (Language)PostCssLanguage.INSTANCE;
                if (StringsKt.equals((String)styleLang, (String)"text/css", (boolean)true)) {
                    return (Language)cssLanguage;
                }
                List list = cssLanguage.getDialects();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDialects(...)");
                Iterable iterable = list;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                do {
                    block11: {
                        block9: {
                            boolean bl2;
                            block7: {
                                int n;
                                Object[] $this$any$iv;
                                block10: {
                                    block8: {
                                        if (!iterator.hasNext()) break block8;
                                        element$iv = iterator.next();
                                        Language dialect = (Language)element$iv;
                                        boolean bl3 = false;
                                        if (StringsKt.equals((String)dialect.getID(), (String)styleLang, (boolean)true)) break block9;
                                        String[] stringArray = dialect.getMimeTypes();
                                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getMimeTypes(...)");
                                        $this$any$iv = stringArray;
                                        boolean $i$f$any = false;
                                        n = $this$any$iv.length;
                                        break block10;
                                    }
                                    v2 = null;
                                    break block6;
                                }
                                for (int i = 0; i < n; ++i) {
                                    Object element$iv2 = $this$any$iv[i];
                                    String it = (String)element$iv2;
                                    boolean bl4 = false;
                                    if (!StringsKt.equals((String)it, (String)styleLang, (boolean)true)) continue;
                                    bl2 = true;
                                    break block7;
                                }
                                bl2 = false;
                            }
                            if (!bl2) break block11;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (!bl);
                v2 = element$iv;
            }
            Language language = v2;
            if (language == null) return (Language)PostCssLanguage.INSTANCE;
            return language;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/lang/html/lexer/VueTagEmbeddedContentProvider$VueScriptEmbedmentInfo;", "Lcom/intellij/html/embedding/HtmlEmbedmentInfo;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getElementType", "createHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "intellij.vuejs.backend"})
    public static final class VueScriptEmbedmentInfo
    implements HtmlEmbedmentInfo {
        @NotNull
        private final IElementType elementType;

        public VueScriptEmbedmentInfo(@NotNull IElementType elementType) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            this.elementType = elementType;
        }

        @NotNull
        public IElementType getElementType() {
            return this.elementType;
        }

        @NotNull
        public Lexer createHighlightingLexer() {
            throw new IllegalStateException("VueEmbeddedContentSupport did something unexpected".toString());
        }
    }
}

