/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.languageService.TypeScriptServiceProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServiceWrapper;
import org.jetbrains.vuejs.lang.typescript.service.VueTypeScriptPluginServiceWrapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider;", "Lcom/intellij/lang/typescript/languageService/TypeScriptServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lspLanguageService", "Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServiceWrapper;", "getLspLanguageService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServiceWrapper;", "lspLanguageService$delegate", "Lkotlin/Lazy;", "tsPluginService", "Lorg/jetbrains/vuejs/lang/typescript/service/VueTypeScriptPluginServiceWrapper;", "getTsPluginService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VueTypeScriptPluginServiceWrapper;", "tsPluginService$delegate", "allServices", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "getAllServices", "()Ljava/util/List;", "isHighlightingCandidate", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueLanguageServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,54:1\n30#2,2:55\n30#2,2:57\n*S KotlinDebug\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n*L\n18#1:55,2\n19#1:57,2\n*E\n"})
public final class VueLanguageServiceProvider
extends TypeScriptServiceProvider {
    @NotNull
    private final Lazy lspLanguageService$delegate;
    @NotNull
    private final Lazy tsPluginService$delegate;

    public VueLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lspLanguageService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueLanguageServiceProvider.lspLanguageService_delegate$lambda$0(project));
        this.tsPluginService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueLanguageServiceProvider.tsPluginService_delegate$lambda$0(project));
    }

    private final VueLspServiceWrapper getLspLanguageService() {
        Lazy lazy = this.lspLanguageService$delegate;
        return (VueLspServiceWrapper)lazy.getValue();
    }

    private final VueTypeScriptPluginServiceWrapper getTsPluginService() {
        Lazy lazy = this.tsPluginService$delegate;
        return (VueTypeScriptPluginServiceWrapper)lazy.getValue();
    }

    @NotNull
    public List<TypeScriptService> getAllServices() {
        Object[] objectArray = new TypeScriptService[]{this.getLspLanguageService().getService(), this.getTsPluginService().getService()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isHighlightingCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptLanguageServiceUtil.isJavaScriptOrTypeScriptFileType((FileType)file.getFileType()) || VueFileTypeKt.isVueFile(file);
    }

    private static final VueLspServiceWrapper lspLanguageService_delegate$lambda$0(Project $project) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<VueLspServiceWrapper> serviceClass$iv = VueLspServiceWrapper.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VueLspServiceWrapper)object;
    }

    private static final VueTypeScriptPluginServiceWrapper tsPluginService_delegate$lambda$0(Project $project) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<VueTypeScriptPluginServiceWrapper> serviceClass$iv = VueTypeScriptPluginServiceWrapper.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VueTypeScriptPluginServiceWrapper)object;
    }
}

