/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSStubSafeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.VueContainer;
import org.jetbrains.vuejs.model.VueInject;
import org.jetbrains.vuejs.model.VueProvide;
import org.jetbrains.vuejs.model.VueProvideUtilsKt;
import org.jetbrains.vuejs.model.VueSymbol;
import org.jetbrains.vuejs.types.VueTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001ap\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032M\u0010\t\u001aI\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\u00070\nH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0017\u00a8\u0006!"}, d2={"analyzeProvide", "Lorg/jetbrains/vuejs/model/VueProvide;", "call", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "analyzeInject", "Lorg/jetbrains/vuejs/model/VueInject;", "analyzeCall", "T", "Lorg/jetbrains/vuejs/model/VueSymbol;", "factory", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "Lcom/intellij/psi/PsiElement;", "source", "Lcom/intellij/psi/PsiNamedElement;", "symbol", "(Lcom/intellij/lang/javascript/psi/JSCallExpression;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/vuejs/model/VueSymbol;", "findInjectForCall", "component", "Lorg/jetbrains/vuejs/model/VueComponent;", "evaluateInjectedType", "Lcom/intellij/lang/javascript/psi/JSType;", "inject", "provides", "", "resolveInjectionSymbol", "Lcom/intellij/lang/javascript/psi/JSFieldVariable;", "element", "isInjectionSymbolType", "", "symbolType", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueProvideUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueProvideUtils.kt\norg/jetbrains/vuejs/model/VueProvideUtilsKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n18#2:77\n18#2:78\n18#2:80\n18#2:81\n18#2:82\n18#2:83\n1#3:79\n*S KotlinDebug\n*F\n+ 1 VueProvideUtils.kt\norg/jetbrains/vuejs/model/VueProvideUtilsKt\n*L\n37#1:77\n39#1:78\n48#1:80\n50#1:81\n65#1:82\n76#1:83\n*E\n"})
public final class VueProvideUtilsKt {
    @Nullable
    public static final VueProvide analyzeProvide(@NotNull JSCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return (VueProvide)VueProvideUtilsKt.analyzeCall(call, analyzeProvide.1.INSTANCE);
    }

    @Nullable
    public static final VueInject analyzeInject(@NotNull JSCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return (VueInject)VueProvideUtilsKt.analyzeCall(call, analyzeInject.1.INSTANCE);
    }

    private static final <T extends VueSymbol> T analyzeCall(JSCallExpression call, Function3<? super String, ? super PsiElement, ? super PsiNamedElement, ? extends T> factory) {
        VueSymbol vueSymbol;
        JSImplicitElement jSImplicitElement = VueFrameworkHandlerKt.getFunctionImplicitElement(call);
        String referenceName = jSImplicitElement != null ? jSImplicitElement.getUserStringData() : null;
        Object $this$asSafely$iv = CollectionsKt.getOrNull((List)JSStubSafeUtil.getStubSafeCallArguments((JSCallExpression)call), (int)0);
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof JSLiteralExpression)) {
            object = null;
        }
        JSLiteralExpression literal = (JSLiteralExpression)object;
        if (referenceName != null) {
            PsiNamedElement psiNamedElement;
            PsiElement $this$asSafely$iv2 = JSStubBasedPsiTreeUtil.resolveLocally((String)referenceName, (PsiElement)((PsiElement)call));
            boolean $i$f$asSafely2 = false;
            PsiElement psiElement = $this$asSafely$iv2;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            if ((psiNamedElement = (PsiNamedElement)psiElement) != null) {
                PsiNamedElement it = psiNamedElement;
                boolean bl = false;
                vueSymbol = (VueSymbol)factory.invoke((Object)referenceName, (Object)call, (Object)it);
            } else {
                vueSymbol = null;
            }
        } else {
            JSLiteralExpression jSLiteralExpression = literal;
            if (jSLiteralExpression != null) {
                String string = JSStubSafeUtil.getStubSafeStringValue((JSLiteralExpression)jSLiteralExpression);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    vueSymbol = (VueSymbol)factory.invoke((Object)it, (Object)literal, null);
                } else {
                    vueSymbol = null;
                }
            } else {
                vueSymbol = null;
            }
        }
        return (T)vueSymbol;
    }

    @Nullable
    public static final VueInject findInjectForCall(@NotNull JSCallExpression call, @NotNull VueComponent component) {
        VueInject vueInject;
        Object object;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object2 = VueFrameworkHandlerKt.getFunctionImplicitElement(call);
        if (object2 == null || (object2 = object2.getUserStringData()) == null) {
            Object $this$asSafely$iv = CollectionsKt.getOrNull((List)JSStubSafeUtil.getStubSafeCallArguments((JSCallExpression)call), (int)0);
            boolean $i$f$asSafely = false;
            Object object3 = $this$asSafely$iv;
            if (!(object3 instanceof JSLiteralExpression)) {
                object3 = null;
            }
            JSLiteralExpression jSLiteralExpression = (JSLiteralExpression)object3;
            object2 = jSLiteralExpression != null ? JSStubSafeUtil.getStubSafeStringValue((JSLiteralExpression)jSLiteralExpression) : null;
            if (object2 == null) {
                return null;
            }
        }
        Object injectionKey = object2;
        VueComponent $this$asSafely$iv = component;
        boolean $i$f$asSafely = false;
        VueComponent vueComponent = $this$asSafely$iv;
        if (!(vueComponent instanceof VueContainer)) {
            vueComponent = null;
        }
        if ((object = (VueContainer)vueComponent) != null && (object = object.getInjects()) != null) {
            Object v5;
            block7: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    VueInject it = (VueInject)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)injectionKey)) continue;
                    v5 = t;
                    break block7;
                }
                v5 = null;
            }
            vueInject = v5;
        } else {
            vueInject = null;
        }
        return vueInject;
    }

    @Nullable
    public static final JSType evaluateInjectedType(@NotNull VueInject inject, @NotNull List<? extends VueProvide> provides) {
        JSType jSType;
        Object v4;
        boolean isOptional;
        block5: {
            Intrinsics.checkNotNullParameter((Object)inject, (String)"inject");
            Intrinsics.checkNotNullParameter(provides, (String)"provides");
            if (provides.isEmpty()) {
                return null;
            }
            JSType defaultValue = inject.getDefaultValue();
            isOptional = defaultValue == null || defaultValue instanceof JSUndefinedType || defaultValue instanceof JSVoidType;
            Iterable iterable = provides;
            for (Object t : iterable) {
                boolean bl;
                VueProvide provide = (VueProvide)t;
                boolean bl2 = false;
                PsiNamedElement psiNamedElement = provide.getInjectionKey();
                if (psiNamedElement != null) {
                    bl = psiNamedElement.isEquivalentTo((PsiElement)inject.getInjectionKey());
                } else {
                    String string = provide.getName();
                    String string2 = inject.getFrom();
                    if (string2 == null) {
                        string2 = inject.getName();
                    }
                    bl = Intrinsics.areEqual((Object)string, (Object)string2);
                }
                if (!bl) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        VueProvide vueProvide = v4;
        return vueProvide != null && (jSType = vueProvide.getType()) != null ? VueTypeUtilsKt.optionalIf(jSType, isOptional) : null;
    }

    @Nullable
    public static final JSFieldVariable resolveInjectionSymbol(@Nullable PsiElement element) {
        JSPsiNamedElementBase jSPsiNamedElementBase;
        PsiElement psiElement = element;
        if (psiElement instanceof JSReferenceExpression) {
            PsiElement $this$asSafely$iv = ((JSReferenceExpression)element).resolve();
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof JSFieldVariable)) {
                psiElement2 = null;
            }
            jSPsiNamedElementBase = (JSPsiNamedElementBase)((JSFieldVariable)psiElement2);
        } else {
            jSPsiNamedElementBase = psiElement instanceof JSPsiNamedElementBase ? VueUtilKt.resolveIfImportSpecifier((JSPsiNamedElementBase)element) : null;
        }
        JSPsiNamedElementBase jSPsiNamedElementBase2 = jSPsiNamedElementBase;
        JSFieldVariable jSFieldVariable = jSPsiNamedElementBase2 instanceof JSFieldVariable ? (JSFieldVariable)jSPsiNamedElementBase2 : null;
        if (jSFieldVariable == null) {
            return null;
        }
        JSFieldVariable declaration = jSFieldVariable;
        JSType jSType = JSResolveUtil.getElementJSType((PsiElement)((PsiElement)declaration));
        JSType symbolType = jSType != null ? jSType.substitute() : null;
        return VueProvideUtilsKt.isInjectionSymbolType(symbolType) ? declaration : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInjectionSymbolType(@Nullable JSType symbolType) {
        if (symbolType instanceof JSSymbolType) return true;
        if (!(symbolType instanceof JSGenericTypeImpl)) return false;
        JSType $this$asSafely$iv = ((JSGenericTypeImpl)symbolType).getType();
        boolean $i$f$asSafely = false;
        JSType jSType = $this$asSafely$iv;
        if (!(jSType instanceof JSTypeImpl)) {
            jSType = null;
        }
        JSTypeImpl jSTypeImpl = (JSTypeImpl)jSType;
        if (!Intrinsics.areEqual((Object)(jSTypeImpl != null ? jSTypeImpl.getTypeText() : null), (Object)"InjectionKey")) return false;
        return true;
    }
}

