/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.model.Pointer;
import com.intellij.polySymbols.patterns.PolySymbolPattern;
import com.intellij.polySymbols.patterns.PolySymbolPatternFactory;
import com.intellij.polySymbols.query.PolySymbolWithPattern;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueSlot;
import org.jetbrains.vuejs.types.VueSourceSlotScopeType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0082\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceRegexSlot;", "Lorg/jetbrains/vuejs/model/VueSlot;", "Lcom/intellij/polySymbols/query/PolySymbolWithPattern;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "regex", "", "source", "Lcom/intellij/psi/xml/XmlTag;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/xml/XmlTag;)V", "getSource", "()Lcom/intellij/psi/xml/XmlTag;", "name", "getName", "()Ljava/lang/String;", "pattern", "Lcom/intellij/polySymbols/patterns/PolySymbolPattern;", "getPattern", "()Lcom/intellij/polySymbols/patterns/PolySymbolPattern;", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "intellij.vuejs.backend"})
final class VueSourceRegexSlot
implements VueSlot,
PolySymbolWithPattern,
PsiSourcedPolySymbol {
    @NotNull
    private final String regex;
    @NotNull
    private final XmlTag source;
    @NotNull
    private final PolySymbolPattern pattern;

    public VueSourceRegexSlot(@NotNull String regex, @NotNull XmlTag source) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.regex = regex;
        this.source = source;
        this.pattern = PolySymbolPatternFactory.INSTANCE.createRegExMatch(this.regex, true);
    }

    @NotNull
    public XmlTag getSource() {
        return this.source;
    }

    @NotNull
    public String getName() {
        return "Dynamic slot";
    }

    @NotNull
    public PolySymbolPattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public JSType getType() {
        return (JSType)new VueSourceSlotScopeType(this.getSource(), this.getName() + " /" + this.getPattern() + "/");
    }

    @NotNull
    public Pointer<VueSourceRegexSlot> createPointer() {
        String regex = this.regex;
        SmartPsiElementPointer sourcePtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.getSource()));
        return () -> VueSourceRegexSlot.createPointer$lambda$0(sourcePtr, regex);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceRegexSlot && Intrinsics.areEqual((Object)((VueSourceRegexSlot)other).regex, (Object)this.regex) && Intrinsics.areEqual((Object)((VueSourceRegexSlot)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        int result = this.regex.hashCode();
        result = 31 * result + this.getSource().hashCode();
        return result;
    }

    private static final VueSourceRegexSlot createPointer$lambda$0(SmartPsiElementPointer $sourcePtr, String $regex) {
        XmlTag xmlTag = (XmlTag)$sourcePtr.dereference();
        if (xmlTag == null) {
            return null;
        }
        XmlTag source = xmlTag;
        return new VueSourceRegexSlot($regex, source);
    }
}

