/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DelegatingCharSequence;
import com.intellij.lang.javascript.JSMinifiedFileGistServiceKt;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/JSMinifiedFileGistService;", "", "<init>", "()V", "gist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "getGist", "()Lcom/intellij/util/gist/VirtualFileGist;", "isJavaScriptFileMinified", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "readFileContentPrefix", "", "limitBytes", "", "isDetectionReliable", "fileContentPrefix", "Lcom/intellij/lang/javascript/DelegatingCharSequence;", "readPrefixBytes", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJSMinifiedFileGistService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMinifiedFileGistService.kt\ncom/intellij/lang/javascript/JSMinifiedFileGistService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n60#2,5:94\n60#2,5:99\n61#2,4:104\n*S KotlinDebug\n*F\n+ 1 JSMinifiedFileGistService.kt\ncom/intellij/lang/javascript/JSMinifiedFileGistService\n*L\n33#1:94,5\n40#1:99,5\n53#1:104,4\n*E\n"})
public final class JSMinifiedFileGistService {
    @NotNull
    private final VirtualFileGist<Boolean> gist;

    public JSMinifiedFileGistService() {
        VirtualFileGist virtualFileGist = GistManager.getInstance().newVirtualFileGist("js.minified.store", 1, (DataExternalizer)BooleanDataDescriptor.INSTANCE, (arg_0, arg_1) -> JSMinifiedFileGistService.gist$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileGist, (String)"newVirtualFileGist(...)");
        this.gist = virtualFileGist;
    }

    @NotNull
    public final VirtualFileGist<Boolean> getGist() {
        return this.gist;
    }

    private final boolean isJavaScriptFileMinified(VirtualFile file) {
        DelegatingCharSequence initialContentPrefix = new DelegatingCharSequence(this.readFileContentPrefix(file, 4096));
        boolean initialMinified = JSMinifiedFileUtil.calculateIsMinified(initialContentPrefix);
        if (initialMinified) {
            int extendedFileReadLimit;
            Logger logger;
            boolean reliable = this.isDetectionReliable(initialContentPrefix, file, 4096);
            Logger $this$debug_u24default$iv = JSMinifiedFileGistServiceKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Detected JavaScript minified file (reliable: " + reliable + "): " + file.getPath(), t$iv);
            }
            if (!reliable && (extendedFileReadLimit = RangesKt.coerceIn((int)Registry.Companion.intValue("js.minified.detection.limit.bytes", 262144), (int)4096, (int)0x100000)) > 4096) {
                CharSequence extendedContentPrefix = this.readFileContentPrefix(file, extendedFileReadLimit);
                boolean extendedMinified = JSMinifiedFileUtil.calculateIsMinified(extendedContentPrefix);
                Logger $this$debug_u24default$iv2 = JSMinifiedFileGistServiceKt.access$getLOG$p();
                Throwable t$iv2 = null;
                boolean $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl = false;
                    logger.debug("Extended JavaScript minified file status: " + extendedMinified + ", limit=" + extendedFileReadLimit + ", " + file.getPath(), t$iv2);
                }
                return extendedMinified;
            }
        }
        return initialMinified;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence readFileContentPrefix(VirtualFile file, int limitBytes) {
        try {
            CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)file, (int)limitBytes);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadText(...)");
            return charSequence;
        }
        catch (Exception e) {
            void $this$debug$iv;
            Logger logger = JSMinifiedFileGistServiceKt.access$getLOG$p();
            Throwable t$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var8_7 = $this$debug$iv;
                boolean bl = false;
                var8_7.debug("Failed to read file content (" + file.getPath() + ", prefix: " + limitBytes + ")", t$iv);
            }
            return "";
        }
    }

    private final boolean isDetectionReliable(DelegatingCharSequence fileContentPrefix, VirtualFile file, int readPrefixBytes) {
        if (fileContentPrefix.length() < readPrefixBytes / 4) {
            return true;
        }
        return fileContentPrefix.getMaxAccessedIndex() < fileContentPrefix.length() - 1 || file.getLength() <= (long)readPrefixBytes;
    }

    private static final Boolean gist$lambda$0(JSMinifiedFileGistService this$0, Project project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this$0.isJavaScriptFileMinified(file);
    }
}

