/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.langs;

import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.JSReferencePathUpdater;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSParsedPathElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\u0018\u0010#\u001a\u00020\u00062\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0%H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fH\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010'\u001a\u00020(H\u0016J\"\u0010-\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001fH\u0002J\u0014\u00102\u001a\u00020\u00062\b\u00103\u001a\u0004\u0018\u00010,H\u0096\u0082\u0004J\n\u00104\u001a\u00020\rH\u0096\u0080\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/langs/ResolutionPathItem;", "Lcom/intellij/psi/impl/SyntheticFileSystemItem;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceResolver;", "project", "Lcom/intellij/openapi/project/Project;", "hasTilde", "", "resolution", "Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "paths", "", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "index", "", "context", "Lcom/intellij/psi/PsiFileSystemItem;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;ILcom/intellij/psi/PsiFileSystemItem;)V", "getHasTilde", "()Z", "getResolution", "()Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "getPaths", "()[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "getIndex", "()I", "getContext", "()Lcom/intellij/psi/PsiFileSystemItem;", "getParent", "getName", "", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDirectory", "processChildren", "processor", "Lcom/intellij/psi/search/PsiElementProcessor;", "resolveFileReference", "reference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "name", "getVariants", "", "", "getRelativePath", "contextFile", "newElement", "Lcom/intellij/psi/PsiElement;", "prefix", "equals", "other", "hashCode", "intellij.javascript.backend"})
public final class ResolutionPathItem
extends SyntheticFileSystemItem
implements FileReferenceResolver {
    private final boolean hasTilde;
    @NotNull
    private final JSPathResolution resolution;
    @NotNull
    private final JSParsedPathElement[] paths;
    private final int index;
    @NotNull
    private final PsiFileSystemItem context;

    public ResolutionPathItem(@NotNull Project project, boolean hasTilde, @NotNull JSPathResolution resolution, @NotNull JSParsedPathElement[] paths, int index, @NotNull PsiFileSystemItem context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(project);
        this.hasTilde = hasTilde;
        this.resolution = resolution;
        this.paths = paths;
        this.index = index;
        this.context = context2;
    }

    public final boolean getHasTilde() {
        return this.hasTilde;
    }

    @NotNull
    public final JSPathResolution getResolution() {
        return this.resolution;
    }

    @NotNull
    public final JSParsedPathElement[] getPaths() {
        return this.paths;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final PsiFileSystemItem getContext() {
        return this.context;
    }

    @Nullable
    public PsiFileSystemItem getParent() {
        return this.index < 0 ? this.context.getParent() : this.context;
    }

    @NotNull
    public String getName() {
        String string;
        if (this.index < 0) {
            String string2 = this.context.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        } else {
            string = this.paths[this.index].getText();
        }
        return string;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.index < 0 ? this.context.getVirtualFile() : (VirtualFile)this.resolution.getChain().get(this.index);
    }

    public boolean isDirectory() {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile != null ? virtualFile.isDirectory() : true;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        block4: {
            VirtualFile virtualFile;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    int newIndex = this.index + 1;
                    if (this.resolution.size() > newIndex && ((CharSequence)this.paths[newIndex].getText()).length() > 0 && this.resolution.getChain().get(newIndex) != null) {
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        return processor.execute((PsiElement)new ResolutionPathItem(project, this.hasTilde, this.resolution, this.paths, newIndex, (PsiFileSystemItem)this));
                    }
                    if (this.index >= 0 && this.resolution.getChain().get(this.index) == null) break block4;
                    virtualFile = this.getVirtualFile();
                    if (virtualFile == null) break block5;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    PsiFileSystemItem psiFileSystemItem = FileReferenceHelper.getPsiFileSystemItem((PsiManager)PsiManager.getInstance((Project)this.getProject()), (VirtualFile)it);
                    virtualFile = psiFileSystemItem;
                    if (psiFileSystemItem != null) break block6;
                }
                return true;
            }
            VirtualFile curr = virtualFile;
            return curr.processChildren(processor);
        }
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolveFileReference(@NotNull FileReference reference, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @NotNull
    public Collection<Object> getVariants(@NotNull FileReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public String getRelativePath(@NotNull FileReference reference, @NotNull VirtualFile contextFile, @NotNull PsiElement newElement) {
        String nameForModuleBind;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        if (newElement instanceof PsiFileSystemItem && this.resolution.getChain().contains(((PsiFileSystemItem)newElement).getVirtualFile()) && (nameForModuleBind = JSReferencePathUpdater.getNameForModuleBind(newElement, (PsiReference)reference)) != null) {
            return this.prefix() + nameForModuleBind;
        }
        return super.getRelativePath(reference, contextFile, newElement);
    }

    private final String prefix() {
        return this.hasTilde ? "~" : "";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.frameworks.modules.langs.ResolutionPathItem");
        ResolutionPathItem cfr_ignored_0 = (ResolutionPathItem)((Object)object2);
        if (this.hasTilde != ((ResolutionPathItem)((Object)other)).hasTilde) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resolution, (Object)((ResolutionPathItem)((Object)other)).resolution)) {
            return false;
        }
        if (!Arrays.equals(this.paths, ((ResolutionPathItem)((Object)other)).paths)) {
            return false;
        }
        if (this.index != ((ResolutionPathItem)((Object)other)).index) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.context, (Object)((ResolutionPathItem)((Object)other)).context);
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.hasTilde);
        result2 = 31 * result2 + this.resolution.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.paths);
        result2 = 31 * result2 + this.index;
        result2 = 31 * result2 + this.context.hashCode();
        return result2;
    }
}

