/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.lang.javascript.service.JSLanguageServiceInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.TypeScriptServiceOutOfMemoryDetector;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.lang.typescript.compiler.languageService.protocol.JSLanguageServiceObjectWithStateUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceQueueImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueueImpl;", "project", "Lcom/intellij/openapi/project/Project;", "protocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "reporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "serverState", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerState;", "oomDetector", "Lcom/intellij/lang/javascript/service/TypeScriptServiceOutOfMemoryDetector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerState;Lcom/intellij/lang/javascript/service/TypeScriptServiceOutOfMemoryDetector;)V", "getServerState", "()Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerState;", "registerProcessListeners", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "doDispose", "getDocumentTextMatchingTextAtServer", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryGetServiceObjectWithoutStateUpdater", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/JSLanguageServiceObjectWithStateUpdater;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "getServiceObjectWithStateUpdater", "intellij.javascript.backend"})
public final class TypeScriptLanguageServiceQueueImpl
extends JSLanguageServiceQueueImpl {
    @NotNull
    private final TypeScriptServerState serverState;
    @NotNull
    private final TypeScriptServiceOutOfMemoryDetector oomDetector;

    public TypeScriptLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @NotNull JSLanguageServiceInfoReporter reporter, @NotNull TypeScriptServerState serverState, @NotNull TypeScriptServiceOutOfMemoryDetector oomDetector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)serverState, (String)"serverState");
        Intrinsics.checkNotNullParameter((Object)oomDetector, (String)"oomDetector");
        super(project, protocol, (JSLanguageServiceQueue.ProcessConnector)null, (JSLanguageServiceQueue.ServiceInfoReporter)reporter, false);
        this.serverState = serverState;
        this.oomDetector = oomDetector;
        Disposer.register((Disposable)this, (Disposable)this.serverState);
    }

    @NotNull
    public final TypeScriptServerState getServerState() {
        return this.serverState;
    }

    @Override
    protected void registerProcessListeners(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        super.registerProcessListeners(processHandler);
        processHandler.addProcessListener(this.oomDetector.getProcessListener());
    }

    @Override
    protected void doDispose() {
        Disposer.dispose((Disposable)this.serverState);
        super.doDispose();
    }

    @Nullable
    public final CharSequence getDocumentTextMatchingTextAtServer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.serverState.getCacheData().getDocumentTextMatchingTextAtServer(file);
    }

    @Override
    @Nullable
    protected JSLanguageServiceObjectWithStateUpdater tryGetServiceObjectWithoutStateUpdater(@NotNull JSLanguageServiceCommand $this$tryGetServiceObjectWithoutStateUpdater) {
        Intrinsics.checkNotNullParameter((Object)$this$tryGetServiceObjectWithoutStateUpdater, (String)"<this>");
        return this.serverState.getCacheData().tryGetServiceObjectWithoutStateUpdater($this$tryGetServiceObjectWithoutStateUpdater);
    }

    @Override
    @Nullable
    protected JSLanguageServiceObjectWithStateUpdater getServiceObjectWithStateUpdater(@NotNull JSLanguageServiceCommand $this$getServiceObjectWithStateUpdater) {
        Intrinsics.checkNotNullParameter((Object)$this$getServiceObjectWithStateUpdater, (String)"<this>");
        return this.serverState.getCacheData().getServiceObjectWithStateUpdater($this$getServiceObjectWithStateUpdater);
    }
}

