/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerCheckerTransferredData;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContext;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContextKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006R$\u0010\u0004\u001a\u0018\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerTransferredData;", "", "<init>", "()V", "checkerPool", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerCheckerTransferredData;", "myResetCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "resetCount", "getResetCount$intellij_javascript_backend", "()I", "getOrComputeType", "T", "sourceFile", "Lcom/intellij/psi/PsiFile;", "type", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "compute", "Lkotlin/Function0;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/lang/typescript/tsc/gen/Type;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrCreateChecker", "ideProjectId", "ideTypeCheckerId", "dropCaches", "", "isUpToDate", "", "markOutdated", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerTransferredData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerTransferredData.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTransferredData\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n72#2,2:69\n1#3:71\n1#3:72\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerTransferredData.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTransferredData\n*L\n31#1:69,2\n31#1:71\n*E\n"})
public final class TypeScriptCompilerTransferredData {
    @NotNull
    private final Cache<Integer, TypeScriptCompilerCheckerTransferredData> checkerPool;
    @NotNull
    private final AtomicInteger myResetCount;

    public TypeScriptCompilerTransferredData() {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).maximumSize(50L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.checkerPool = cache;
        this.myResetCount = new AtomicInteger(0);
    }

    public final int getResetCount$intellij_javascript_backend() {
        return this.myResetCount.get();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> T getOrComputeType(@NotNull PsiFile sourceFile, @NotNull Type type2, @NotNull Function0<? extends T> compute) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        TypeScriptServerTypeCheckerContext typeCheckerContext = TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(type2);
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)sourceFile), () -> TypeScriptCompilerTransferredData.getOrComputeType$lambda$0(sourceFile, typeCheckerContext));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        ConcurrentMap concurrentMap = (ConcurrentMap)object;
        Type key$iv = type2;
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(key$iv);
        if (object2 == null) {
            Object default$iv = compute.invoke();
            boolean bl = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        Object v = object2;
        Intrinsics.checkNotNullExpressionValue(v, (String)"getOrPut(...)");
        return (T)v;
    }

    @NotNull
    public final TypeScriptCompilerCheckerTransferredData getOrCreateChecker(int ideProjectId, int ideTypeCheckerId) {
        while (true) {
            if ((TypeScriptCompilerCheckerTransferredData)this.checkerPool.getIfPresent((Object)ideProjectId) != null) {
                TypeScriptCompilerCheckerTransferredData currentEntry;
                boolean bl = false;
                if (currentEntry.getIdeTypeCheckerId() == ideTypeCheckerId) {
                    return currentEntry;
                }
                if (currentEntry.getIdeTypeCheckerId() > ideTypeCheckerId) {
                    return new TypeScriptCompilerCheckerTransferredData(ideTypeCheckerId);
                }
            }
            this.checkerPool.put((Object)ideProjectId, (Object)new TypeScriptCompilerCheckerTransferredData(ideTypeCheckerId));
        }
    }

    public final void dropCaches() {
        this.checkerPool.invalidateAll();
        this.myResetCount.incrementAndGet();
    }

    public final boolean isUpToDate(int ideProjectId, int ideTypeCheckerId) {
        boolean bl;
        TypeScriptCompilerCheckerTransferredData typeScriptCompilerCheckerTransferredData = (TypeScriptCompilerCheckerTransferredData)this.checkerPool.getIfPresent((Object)ideProjectId);
        if (typeScriptCompilerCheckerTransferredData != null) {
            TypeScriptCompilerCheckerTransferredData it = typeScriptCompilerCheckerTransferredData;
            boolean bl2 = false;
            bl = it.getIdeTypeCheckerId() <= ideTypeCheckerId && !it.getOutdated();
        } else {
            bl = false;
        }
        return bl;
    }

    public final void markOutdated(int ideProjectId, int ideTypeCheckerId) {
        block1: {
            TypeScriptCompilerCheckerTransferredData typeScriptCompilerCheckerTransferredData;
            TypeScriptCompilerCheckerTransferredData typeScriptCompilerCheckerTransferredData2 = (TypeScriptCompilerCheckerTransferredData)this.checkerPool.getIfPresent((Object)ideProjectId);
            if (typeScriptCompilerCheckerTransferredData2 == null) break block1;
            TypeScriptCompilerCheckerTransferredData it = typeScriptCompilerCheckerTransferredData = typeScriptCompilerCheckerTransferredData2;
            boolean bl = false;
            typeScriptCompilerCheckerTransferredData2 = it.getIdeTypeCheckerId() == ideTypeCheckerId ? typeScriptCompilerCheckerTransferredData : null;
            if (typeScriptCompilerCheckerTransferredData2 != null) {
                it = typeScriptCompilerCheckerTransferredData2;
                boolean bl2 = false;
                it.setOutdated(true);
            }
        }
    }

    private static final long getOrComputeType$lambda$0$0(TypeScriptServerTypeCheckerContext $typeCheckerContext) {
        return !$typeCheckerContext.isUpToDate() ? -1L : 0L;
    }

    private static final CachedValueProvider.Result getOrComputeType$lambda$0(PsiFile $sourceFile, TypeScriptServerTypeCheckerContext $typeCheckerContext) {
        Object[] objectArray = new Object[]{$sourceFile, () -> TypeScriptCompilerTransferredData.getOrComputeType$lambda$0$0($typeCheckerContext)};
        return CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])objectArray);
    }
}

