/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance(Notification.class);
    public static final DataKey<Notification> KEY = DataKey.create((String)"Notification");
    @NotNull
    public final String id;
    @NotNull
    private final String myGroupId;
    @NotNull
    private final NotificationType myType;
    @Nullable
    private String myDisplayId;
    @Nullable
    private Icon myIcon;
    private @NlsContexts.NotificationTitle @NotNull String myTitle;
    private @NlsContexts.NotificationSubtitle @Nullable String mySubtitle;
    private @NlsContexts.NotificationContent @NotNull String myContent;
    @Nullable
    private NotificationListener myListener;
    private @NlsContexts.LinkLabel @Nullable String myDropDownText;
    private @Nullable List<@NotNull AnAction> myActions;
    @NotNull
    private CollapseActionsDirection myCollapseDirection;
    @Nullable
    private AnAction myContextHelpAction;
    private @Nullable List<@NotNull Runnable> myWhenExpired;
    @Nullable
    private Boolean myImportant;
    private boolean mySuggestionType;
    private boolean myImportantSuggestion;
    private boolean myRemoveWhenExpired;
    private boolean myAddExtraAction;
    private String myDoNotAskId;
    @Nls
    private String myDoNotAskDisplayName;
    private boolean myIsShowingPopupSuppressed;
    private String myRemindLaterHandlerId;
    @Nullable
    private String myToolWindowId;
    private final AtomicBoolean myExpired;
    private final AtomicReference<WeakReference<Balloon>> myBalloonRef;
    private final long myTimestamp;
    private static final String DO_NOT_ASK_PREFIX = "Notification.DoNotAsk-";
    private static final String DO_NOT_ASK_DISPLAY_PREFIX = "Notification.DisplayName-DoNotAsk-";

    public Notification(@NotNull String groupId, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(0);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(1);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(2);
        }
        this(groupId, "", content, type);
    }

    public Notification(@NotNull String groupId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(3);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(4);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(5);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(6);
        }
        this.myCollapseDirection = CollapseActionsDirection.KEEP_LEFTMOST;
        this.myExpired = new AtomicBoolean(false);
        this.myBalloonRef = new AtomicReference();
        this.myTimestamp = System.currentTimeMillis();
        this.id = this.myTimestamp + "." + System.identityHashCode(this);
        this.myGroupId = groupId;
        this.myType = type;
        this.myTitle = title;
        this.myContent = content;
    }

    public boolean isSuggestionType() {
        return this.mySuggestionType;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setSuggestionType(boolean suggestionType) {
        this.mySuggestionType = suggestionType;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(7);
        }
        return notification;
    }

    public boolean isImportantSuggestion() {
        return this.myImportantSuggestion;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setImportantSuggestion(boolean importantSuggestion) {
        this.myImportantSuggestion = importantSuggestion;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(8);
        }
        return notification;
    }

    public boolean isRemoveWhenExpired() {
        return this.myRemoveWhenExpired;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setRemoveWhenExpired(boolean removeWhenExpired) {
        this.myRemoveWhenExpired = removeWhenExpired;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(9);
        }
        return notification;
    }

    public boolean isAddExtraAction() {
        return this.myAddExtraAction;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setAddExtraAction(boolean addExtraAction) {
        this.myAddExtraAction = addExtraAction;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(10);
        }
        return notification;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public String getDisplayId() {
        return this.myDisplayId;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setDisplayId(@NotNull String displayId) {
        if (displayId == null) {
            Notification.$$$reportNull$$$0(11);
        }
        this.myDisplayId = displayId;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(12);
        }
        return notification;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public Notification setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(13);
        }
        return notification;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            Notification.$$$reportNull$$$0(14);
        }
        return string;
    }

    @ApiStatus.Internal
    public boolean canShowFor(@Nullable Project project) {
        if (this.myDoNotAskId == null && this.myDisplayId != null) {
            this.myDoNotAskDisplayName = this.myTitle;
            this.myDoNotAskId = this.myDisplayId;
        } else if (this.myDoNotAskId == null) {
            String title = NotificationGroup.getGroupTitle(this.myGroupId);
            if (title == null) {
                title = this.myGroupId;
            }
            this.myDoNotAskDisplayName = title;
            this.myDoNotAskId = this.myGroupId;
        }
        String id = DO_NOT_ASK_PREFIX + this.myDoNotAskId;
        boolean doNotAsk = PropertiesComponent.getInstance().getBoolean(id, false);
        if (doNotAsk) {
            return false;
        }
        if (project != null) {
            return !PropertiesComponent.getInstance((Project)project).getBoolean(id, false);
        }
        return true;
    }

    @ApiStatus.Internal
    public void setSuppressShowingPopup(boolean isShowingPopupSuppressed) {
        this.myIsShowingPopupSuppressed = isShowingPopupSuppressed;
    }

    @ApiStatus.Internal
    public boolean isShowingPopupSuppressed() {
        return this.myIsShowingPopupSuppressed;
    }

    @ApiStatus.Internal
    @Nullable
    public String getRemindLaterHandlerId() {
        return this.myRemindLaterHandlerId;
    }

    @Contract(value="_ -> this", mutates="this")
    public Notification setRemindLaterHandlerId(@NotNull String remindLaterHandlerId) {
        if (remindLaterHandlerId == null) {
            Notification.$$$reportNull$$$0(15);
        }
        this.myRemindLaterHandlerId = remindLaterHandlerId;
        return this;
    }

    public boolean hasTitle() {
        return !Notification.isEmpty(this.myTitle) || !Notification.isEmpty(this.mySubtitle);
    }

    @NlsContexts.NotificationTitle
    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            Notification.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public Notification setTitle(@NlsContexts.NotificationTitle @Nullable String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(17);
        }
        return notification;
    }

    @NotNull
    public Notification setTitle(@NlsContexts.NotificationTitle @Nullable String title, @NlsContexts.NotificationSubtitle @Nullable String subtitle) {
        Notification notification = this.setTitle(title).setSubtitle(subtitle);
        if (notification == null) {
            Notification.$$$reportNull$$$0(18);
        }
        return notification;
    }

    @NlsContexts.NotificationTitle
    @Nullable
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@NlsContexts.NotificationTitle @Nullable String subtitle) {
        this.mySubtitle = subtitle;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(19);
        }
        return notification;
    }

    public boolean hasContent() {
        return !Notification.isEmpty(this.myContent);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String text) {
        return StringUtil.isEmptyOrSpaces((String)text) || StringUtil.isEmptyOrSpaces((String)StringUtil.stripHtml((String)text, (boolean)false));
    }

    @NlsContexts.NotificationContent
    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            Notification.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public Notification setContent(@NlsContexts.NotificationContent @Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(21);
        }
        return notification;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public static Notification get(@NotNull AnActionEvent e) {
        if (e == null) {
            Notification.$$$reportNull$$$0(22);
        }
        Notification notification = Objects.requireNonNull((Notification)e.getData(KEY));
        if (notification == null) {
            Notification.$$$reportNull$$$0(23);
        }
        return notification;
    }

    public void configureDoNotAskOption(@NotNull String id, @NotNull @Nls String displayName) {
        if (id == null) {
            Notification.$$$reportNull$$$0(24);
        }
        if (displayName == null) {
            Notification.$$$reportNull$$$0(25);
        }
        this.myDoNotAskId = id;
        this.myDoNotAskDisplayName = displayName;
    }

    @NlsContexts.LinkLabel
    @NotNull
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = IdeCoreBundle.message("notifications.action.more", new Object[0]);
        }
        String string = this.myDropDownText;
        if (string == null) {
            Notification.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public Notification setDropDownText(@NlsContexts.LinkLabel @NotNull String dropDownText) {
        if (dropDownText == null) {
            Notification.$$$reportNull$$$0(27);
        }
        this.myDropDownText = dropDownText;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(28);
        }
        return notification;
    }

    @NotNull
    public CollapseActionsDirection getCollapseDirection() {
        CollapseActionsDirection collapseActionsDirection = this.myCollapseDirection;
        if (collapseActionsDirection == null) {
            Notification.$$$reportNull$$$0(29);
        }
        return collapseActionsDirection;
    }

    @NotNull
    public Notification setCollapseDirection(CollapseActionsDirection collapseDirection) {
        this.myCollapseDirection = collapseDirection;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(30);
        }
        return notification;
    }

    @NotNull
    public List<AnAction> getActions() {
        List<Object> list = this.myActions != null ? this.myActions : Collections.emptyList();
        if (list == null) {
            Notification.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action) {
        if (action == null) {
            Notification.$$$reportNull$$$0(32);
        }
        (this.myActions != null ? this.myActions : (this.myActions = new ArrayList<AnAction>())).add(action);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(33);
        }
        return notification;
    }

    @NotNull
    public Notification addActions(@NotNull @NotNull Collection<? extends @NotNull AnAction> actions) {
        if (actions == null) {
            Notification.$$$reportNull$$$0(34);
        }
        (this.myActions != null ? this.myActions : (this.myActions = new ArrayList<AnAction>())).addAll(actions);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(35);
        }
        return notification;
    }

    @Nullable
    public AnAction getContextHelpAction() {
        return this.myContextHelpAction;
    }

    @NotNull
    public Notification setContextHelpAction(AnAction action) {
        this.myContextHelpAction = action;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(36);
        }
        return notification;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            Notification.$$$reportNull$$$0(37);
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired.get();
    }

    public void expire() {
        if (!this.myExpired.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(this::hideBalloon);
        NotificationsManager.getNotificationsManager().expire(this);
        if (this.myWhenExpired != null) {
            for (Runnable each : this.myWhenExpired) {
                each.run();
            }
        }
    }

    public Notification whenExpired(@NotNull Runnable whenExpired) {
        if (whenExpired == null) {
            Notification.$$$reportNull$$$0(38);
        }
        (this.myWhenExpired != null ? this.myWhenExpired : (this.myWhenExpired = new ArrayList<Runnable>())).add(whenExpired);
        return this;
    }

    public void hideBalloon() {
        Notification.hideBalloon(this.myBalloonRef.getAndSet(null));
    }

    private static void hideBalloon(@Nullable Reference<? extends Balloon> balloonRef) {
        Balloon balloon = (Balloon)SoftReference.dereference(balloonRef);
        if (balloon != null) {
            UIUtil.invokeLaterIfNeeded(balloon::hide);
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        if (balloon == null) {
            Notification.$$$reportNull$$$0(39);
        }
        WeakReference<Balloon> oldBalloon = this.myBalloonRef.getAndSet(new WeakReference<Balloon>(balloon));
        Notification.hideBalloon(oldBalloon);
        balloon.addListener(new JBPopupListener(){

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Notification.this.myBalloonRef.updateAndGet(prev -> SoftReference.dereference((Reference)prev) == balloon ? null : prev);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/Notification$1", "onClosed"));
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference((Reference)this.myBalloonRef.get());
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    @NotNull
    public Notification setImportant(boolean important) {
        this.myImportant = important;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(40);
        }
        return notification;
    }

    public boolean isImportant() {
        return this.myImportant != null ? this.myImportant : this.getListener() != null || this.myActions != null && !this.myActions.isEmpty();
    }

    @NotNull
    public Notification setToolWindowId(@Nullable String toolWindowId) {
        this.myToolWindowId = toolWindowId;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(41);
        }
        return notification;
    }

    @Nullable
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    final void assertHasTitleOrContent() {
        LOG.assertTrue(this.hasTitle() || this.hasContent(), (Object)("Notification should have title and/or content; groupId: " + this.myGroupId));
    }

    public String toString() {
        return String.format("Notification{id='%s', myGroupId='%s', myType=%s, myTitle='%s', mySubtitle='%s', myContent='%s'}", new Object[]{this.id, this.myGroupId, this.myType, this.myTitle, this.mySubtitle, this.myContent});
    }

    @ApiStatus.Experimental
    @Contract(value="_ -> this")
    public Notification setDoNotAskFor(@Nullable Project project) {
        PropertiesComponent manager = project == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project);
        manager.setValue(DO_NOT_ASK_PREFIX + this.myDoNotAskId, true);
        manager.setValue(DO_NOT_ASK_DISPLAY_PREFIX + this.myDoNotAskId, this.myDoNotAskDisplayName);
        return this;
    }

    @ApiStatus.Experimental
    public static boolean isDoNotAskFor(@Nullable Project project, @NotNull String doNotAskId) {
        if (doNotAskId == null) {
            Notification.$$$reportNull$$$0(42);
        }
        return project != null && PropertiesComponent.getInstance((Project)project).getBoolean(DO_NOT_ASK_PREFIX + doNotAskId) || PropertiesComponent.getInstance().getBoolean(DO_NOT_ASK_PREFIX + doNotAskId);
    }

    @ApiStatus.Internal
    public static void fire(@NotNull Notification notification, @NotNull AnAction action, @Nullable DataContext context) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(43);
        }
        if (action == null) {
            Notification.$$$reportNull$$$0(44);
        }
        DataContext dataContext = context != null ? context : CustomizedDataContext.withSnapshot((DataContext)DataContext.EMPTY_CONTEXT, sink -> sink.set(KEY, (Object)notification));
        AnActionEvent event = AnActionEvent.createEvent((AnAction)action, (DataContext)dataContext, null, (String)"Notification", (ActionUiKind)ActionUiKind.NONE, null);
        IdeUiService.getInstance().performAction(action, event);
    }

    @Deprecated(forRemoval=true)
    public Notification(@NotNull String groupId, @Nullable Icon icon, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(45);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(46);
        }
        this(groupId, "", type);
        this.setIcon(icon);
    }

    @Deprecated(forRemoval=true)
    public Notification(@NotNull String groupId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(47);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(48);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(49);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(50);
        }
        this(groupId, title, content, type);
        this.myListener = listener;
    }

    @Deprecated(forRemoval=true)
    public Notification(@NotNull String groupId, @Nullable Icon icon, @NlsContexts.NotificationTitle @Nullable String title, @NlsContexts.NotificationSubtitle @Nullable String subtitle, @NlsContexts.NotificationContent @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(51);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(52);
        }
        this(groupId, content != null ? content : "", type);
        this.setIcon(icon);
        this.setTitle(title, subtitle);
        this.myListener = listener;
    }

    @Deprecated
    @NotNull
    public Notification setListener(@NotNull NotificationListener listener) {
        if (listener == null) {
            Notification.$$$reportNull$$$0(53);
        }
        this.myListener = listener;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(54);
        }
        return notification;
    }

    @Deprecated(forRemoval=true)
    public void setCollapseActionsDirection(CollapseActionsDirection collapseDirection) {
        this.myCollapseDirection = collapseDirection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 21, 23, 26, 28, 29, 30, 31, 33, 35, 36, 37, 40, 41, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 5: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 6: 
            case 46: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/Notification";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remindLaterHandlerId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropDownText";
                break;
            }
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpired";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotAskId";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/Notification";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setSuggestionType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setImportantSuggestion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveWhenExpired";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddExtraAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setDisplayId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setIcon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setSubtitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setContent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropDownText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setDropDownText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapseDirection";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setCollapseDirection";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "addAction";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "addActions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setContextHelpAction";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "setImportant";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolWindowId";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "setListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 54: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayId";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setRemindLaterHandlerId";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "configureDoNotAskOption";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setDropDownText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "whenExpired";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setBalloon";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isDoNotAskFor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fire";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 21, 23, 26, 28, 29, 30, 31, 33, 35, 36, 37, 40, 41, 54 -> new IllegalStateException(string);
        };
    }

    public static enum CollapseActionsDirection {
        KEEP_LEFTMOST,
        KEEP_RIGHTMOST;

    }
}

