/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "calcIsFeatureEnabled", "", "feature", "Lcom/intellij/openapi/application/ExperimentalFeature;", "propertyManager", "Lcom/intellij/ide/util/PropertiesComponent;", "getFeatureById", "featureId", "", "toPropertyKey", "intellij.platform.ide.core"})
@SourceDebugExtension(value={"SMAP\nExperiments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Experiments.kt\ncom/intellij/openapi/application/ExperimentsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n13#2:103\n*S KotlinDebug\n*F\n+ 1 Experiments.kt\ncom/intellij/openapi/application/ExperimentsKt\n*L\n18#1:103\n*E\n"})
public final class ExperimentsKt {
    @NotNull
    private static final Logger LOG;

    private static final boolean calcIsFeatureEnabled(ExperimentalFeature feature, PropertiesComponent propertyManager) {
        String manualOptionIdText = System.getProperty("platform.experiment.ab.manual.option", "");
        if (StringsKt.equals((String)"control.option", (String)manualOptionIdText, (boolean)true)) {
            return false;
        }
        String key = ExperimentsKt.toPropertyKey(feature);
        return propertyManager.isValueSet(key) ? propertyManager.getBoolean(key, false) : feature.isEnabled();
    }

    private static final ExperimentalFeature getFeatureById(String featureId) {
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return (ExperimentalFeature)Experiments.EP_NAME.findFirstSafe(arg_0 -> ExperimentsKt.getFeatureById$lambda$1(arg_0 -> ExperimentsKt.getFeatureById$lambda$0(featureId, arg_0), arg_0));
        }
        return null;
    }

    private static final String toPropertyKey(ExperimentalFeature feature) {
        return "experimentalFeature." + feature.id;
    }

    private static final boolean getFeatureById$lambda$0(String $featureId, ExperimentalFeature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.id, (Object)$featureId);
    }

    private static final boolean getFeatureById$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ExperimentalFeature access$getFeatureById(String featureId) {
        return ExperimentsKt.getFeatureById(featureId);
    }

    public static final /* synthetic */ boolean access$calcIsFeatureEnabled(ExperimentalFeature feature, PropertiesComponent propertyManager) {
        return ExperimentsKt.calcIsFeatureEnabled(feature, propertyManager);
    }

    public static final /* synthetic */ String access$toPropertyKey(ExperimentalFeature feature) {
        return ExperimentsKt.toPropertyKey(feature);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Experiments.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

