/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.models.chat;

import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.models.chat.ChatEvent;
import com.intellij.aiplayground.models.chat.ChatRepository;
import com.intellij.aiplayground.models.chat.ChatStorageService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016J\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J+\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0012\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/aiplayground/models/chat/ChatRepositoryService;", "Lcom/intellij/aiplayground/models/chat/ChatRepository;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "storageService", "Lcom/intellij/aiplayground/models/chat/ChatStorageService;", "getAllChats", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/intellij/aiplayground/models/chat/Chat;", "getChat", "id", "Lcom/intellij/aiplayground/models/chat/ChatId;", "getChat-HECah-U", "(Ljava/lang/String;)Lcom/intellij/aiplayground/models/chat/Chat;", "getChatFlow", "chatId", "getChatFlow-HECah-U", "(Ljava/lang/String;)Lkotlinx/coroutines/flow/Flow;", "getEventsFlow", "Lcom/intellij/aiplayground/models/chat/ChatEvent;", "saveChat", "", "chat", "updateChat", "updater", "Lkotlin/Function1;", "updateChat-lBbKWHE", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/intellij/aiplayground/models/chat/Chat;", "deleteChat", "deleteChat-HECah-U", "(Ljava/lang/String;)V", "createChat", "title", "", "intellij.aiplayground.models"})
@SourceDebugExtension(value={"SMAP\nChatRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRepository.kt\ncom/intellij/aiplayground/models/chat/ChatRepositoryService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,90:1\n30#2,2:91\n*S KotlinDebug\n*F\n+ 1 ChatRepository.kt\ncom/intellij/aiplayground/models/chat/ChatRepositoryService\n*L\n60#1:91,2\n*E\n"})
public final class ChatRepositoryService
implements ChatRepository {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ChatStorageService storageService;

    public ChatRepositoryService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChatStorageService> serviceClass$iv = ChatStorageService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.storageService = (ChatStorageService)object;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public Flow<List<Chat>> getAllChats() {
        return this.storageService.getAllChats();
    }

    @Override
    @Nullable
    public Chat getChat-HECah-U(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.storageService.getChat-HECah-U(id);
    }

    @Override
    @NotNull
    public Flow<Chat> getChatFlow-HECah-U(@NotNull String chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return this.storageService.getChatFlow-HECah-U(chatId);
    }

    @Override
    @NotNull
    public Flow<ChatEvent> getEventsFlow() {
        return this.storageService.getEventsFlow();
    }

    @Override
    public void saveChat(@NotNull Chat chat2) {
        Intrinsics.checkNotNullParameter((Object)chat2, (String)"chat");
        this.storageService.saveChat(chat2);
    }

    @Override
    @NotNull
    public Chat updateChat-lBbKWHE(@NotNull String id, @NotNull Function1<? super Chat, Chat> updater) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        return this.storageService.updateChat-lBbKWHE(id, updater);
    }

    @Override
    public void deleteChat-HECah-U(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.storageService.deleteChat-HECah-U(id);
    }

    @Override
    @NotNull
    public Chat createChat(@Nullable String title) {
        return this.storageService.createChat(title);
    }
}

