/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryExtKt;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.vcs.impl.shared.RepositoryId;
import com.intellij.util.Alarm;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.git.branch.GitInOutCountersInProject;
import com.intellij.vcs.git.branch.GitInOutCountersInRepo;
import com.intellij.vcs.git.branch.GitInOutProjectState;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(GitBranchIncomingOutgoingManager.class);
    @Topic.ProjectLevel
    public static final Topic<GitIncomingOutgoingListener> GIT_INCOMING_OUTGOING_CHANGED = new Topic("Git incoming outgoing info changed", GitIncomingOutgoingListener.class);
    private static final String MAC_DEFAULT_LAUNCH = "com.apple.launchd";
    private static final NotNullLazyValue<Boolean> HAS_EXTERNAL_SSH_AGENT = NotNullLazyValue.lazy(() -> GitBranchIncomingOutgoingManager.hasExternalSSHAgent());
    @NotNull
    private final Object LOCK;
    @NotNull
    private final Set<GitRepository> myDirtyReposWithIncoming;
    @NotNull
    private final Set<GitRepository> myDirtyReposWithOutgoing;
    private boolean myShouldRequestRemoteInfo;
    @NotNull
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Integer>> myLocalBranchesWithIncoming;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToFetch;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Integer>> myLocalBranchesWithOutgoing;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myErrorMap;
    @NotNull
    private final Project myProject;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthSuccessMap;
    @NotNull
    private final AtomicBoolean myIsUpdating;

    GitBranchIncomingOutgoingManager(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myDirtyReposWithIncoming = new HashSet<GitRepository>();
        this.myDirtyReposWithOutgoing = new HashSet<GitRepository>();
        this.myLocalBranchesWithIncoming = new ConcurrentHashMap<GitRepository, Map<GitLocalBranch, Integer>>();
        this.myLocalBranchesToFetch = new ConcurrentHashMap<GitRepository, Map<GitLocalBranch, Hash>>();
        this.myLocalBranchesWithOutgoing = new ConcurrentHashMap<GitRepository, Map<GitLocalBranch, Integer>>();
        this.myErrorMap = MultiMap.createConcurrentSet();
        this.myAuthSuccessMap = MultiMap.createConcurrentSet();
        this.myIsUpdating = new AtomicBoolean();
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("GitBranchIncomingOutgoingManager", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void dispose() {
        this.stopScheduling();
    }

    private static boolean hasExternalSSHAgent() {
        String ssh_auth_sock = EnvironmentUtil.getValue((String)"SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            return false;
        }
        if (StringUtil.contains((CharSequence)ssh_auth_sock, (CharSequence)MAC_DEFAULT_LAUNCH)) {
            try {
                Path agentPath = Path.of(ssh_auth_sock, new String[0]);
                String originPath = agentPath.toString();
                String realPath = agentPath.toRealPath(new LinkOption[0]).toString();
                if (!originPath.equals(realPath)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository2, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(1);
        }
        return this.shouldCheckIncoming() && this.getBranchesWithIncoming(repository2).contains((Object)new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository2, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(2);
        }
        return GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing() && this.getBranchesWithOutgoing(repository2).contains((Object)new GitLocalBranch(localBranchName));
    }

    @Nullable
    private Integer getIncomingFor(@Nullable GitRepository repository2, @NotNull GitLocalBranch localBranch) {
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(3);
        }
        if (!this.shouldCheckIncoming()) {
            return null;
        }
        Map<GitLocalBranch, Integer> incomingForRepo = this.myLocalBranchesWithIncoming.get(repository2);
        if (incomingForRepo == null) {
            return null;
        }
        return incomingForRepo.get((Object)localBranch);
    }

    @Nullable
    private Integer getOutgoingFor(@Nullable GitRepository repository2, @NotNull GitLocalBranch localBranch) {
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(4);
        }
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return null;
        }
        Map<GitLocalBranch, Integer> outgoingForRepo = this.myLocalBranchesWithOutgoing.get(repository2);
        if (outgoingForRepo == null) {
            return null;
        }
        return outgoingForRepo.get((Object)localBranch);
    }

    @ApiStatus.Internal
    @NotNull
    public GitInOutCountersInProject getIncomingOutgoingState(@NotNull GitRepository repository2, @NotNull GitLocalBranch localBranch) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(5);
        }
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(6);
        }
        GitInOutCountersInProject gitInOutCountersInProject = this.getIncomingOutgoingState(Collections.singleton(repository2), localBranch);
        if (gitInOutCountersInProject == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(7);
        }
        return gitInOutCountersInProject;
    }

    @ApiStatus.Internal
    @NotNull
    public GitInOutCountersInProject getIncomingOutgoingState(@NotNull Collection<GitRepository> repositories, @NotNull GitLocalBranch localBranch) {
        if (repositories == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(8);
        }
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(9);
        }
        if (repositories.isEmpty()) {
            GitInOutCountersInProject gitInOutCountersInProject = GitInOutCountersInProject.EMPTY;
            if (gitInOutCountersInProject == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(10);
            }
            return gitInOutCountersInProject;
        }
        Map<RepositoryId, GitInOutCountersInRepo> repoStates = repositories.stream().map(r -> {
            Integer incoming = this.getIncomingFor((GitRepository)r, localBranch);
            Integer outgoing = this.getOutgoingFor((GitRepository)r, localBranch);
            if (incoming == null && outgoing == null) {
                return null;
            }
            return new Pair((Object)RepositoryExtKt.repositoryId((Repository)r), (Object)new GitInOutCountersInRepo(incoming, outgoing));
        }).filter(Objects::nonNull).collect(Collectors.toMap(pair -> (RepositoryId)pair.first, pair -> (GitInOutCountersInRepo)pair.second));
        if (repoStates.isEmpty()) {
            GitInOutCountersInProject gitInOutCountersInProject = GitInOutCountersInProject.EMPTY;
            if (gitInOutCountersInProject == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(11);
            }
            return gitInOutCountersInProject;
        }
        return new GitInOutCountersInProject(repoStates);
    }

    public boolean shouldCheckIncoming() {
        return AdvancedSettings.getBoolean((String)"git.update.incoming.outgoing.info") && GitVcsSettings.getInstance((Project)this.myProject).getIncomingCheckStrategy() != GitIncomingCheckStrategy.Never;
    }

    private static boolean shouldCheckIncomingOutgoing() {
        return AdvancedSettings.getBoolean((String)"git.update.incoming.outgoing.info");
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(12);
        }
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = (GitBranchIncomingOutgoingManager)project.getService(GitBranchIncomingOutgoingManager.class);
        if (gitBranchIncomingOutgoingManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(13);
        }
        return gitBranchIncomingOutgoingManager;
    }

    public boolean supportsIncomingOutgoing() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public void activate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.updateBranchesWithOutgoing();
            this.updateIncomingScheduling();
        });
    }

    public void updateIncomingScheduling() {
        if (this.myPeriodicalUpdater == null && this.shouldCheckIncoming()) {
            this.updateBranchesWithIncoming(true);
            int timeout = Registry.intValue((String)"git.update.incoming.info.time");
            this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesWithIncoming(true), timeout, timeout, TimeUnit.MINUTES);
        } else if (this.myPeriodicalUpdater != null && !this.shouldCheckIncoming()) {
            this.stopScheduling();
        }
    }

    @RequiresEdt
    private void stopScheduling() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
    }

    public void forceUpdateBranches(final @Nullable Runnable runAfterUpdate) {
        if (!this.myIsUpdating.compareAndSet(false, true)) {
            return;
        }
        this.updateBranchesWithIncoming(false);
        this.updateBranchesWithOutgoing();
        new Task.Backgroundable(this.myProject, GitBundle.message((String)"branches.update.info.process", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Semaphore semaphore = new Semaphore(0);
                GitBranchIncomingOutgoingManager.this.myQueue.queue(Update.create((Object)((Object)this), () -> semaphore.release()));
                GitBranchIncomingOutgoingManager.this.myQueue.flush();
                try {
                    while (!indicator.isCanceled() && !semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            public void onFinished() {
                GitBranchIncomingOutgoingManager.this.myIsUpdating.set(false);
                if (runAfterUpdate != null) {
                    runAfterUpdate.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchIncomingOutgoingManager$1", "run"));
            }
        }.queue();
    }

    public boolean isUpdating() {
        return this.myIsUpdating.get();
    }

    private void scheduleUpdate() {
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> {
            boolean shouldRequestRemoteInfo;
            ArrayList<GitRepository> withOutgoing;
            ArrayList<GitRepository> withIncoming;
            Iterator iterator = this.LOCK;
            synchronized (iterator) {
                withIncoming = new ArrayList<GitRepository>(this.myDirtyReposWithIncoming);
                withOutgoing = new ArrayList<GitRepository>(this.myDirtyReposWithOutgoing);
                shouldRequestRemoteInfo = this.myShouldRequestRemoteInfo;
                this.myDirtyReposWithIncoming.clear();
                this.myDirtyReposWithOutgoing.clear();
                this.myShouldRequestRemoteInfo = false;
            }
            for (GitRepository r : withOutgoing) {
                this.myLocalBranchesWithOutgoing.put(r, this.calculateBranchesWithOutgoing(r));
            }
            for (GitRepository r : withIncoming) {
                if (shouldRequestRemoteInfo) {
                    this.myLocalBranchesToFetch.put(r, this.calculateBranchesToFetch(r));
                }
                this.myLocalBranchesWithIncoming.put(r, this.calcBranchesWithIncoming(r));
            }
            ((GitIncomingOutgoingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GIT_INCOMING_OUTGOING_CHANGED)).incomingOutgoingInfoChanged();
        }));
    }

    @ApiStatus.Internal
    @NotNull
    public GitInOutProjectState getState() {
        return new GitInOutProjectState(GitBranchIncomingOutgoingManager.mapState(this.myLocalBranchesWithIncoming), GitBranchIncomingOutgoingManager.mapState(this.myLocalBranchesWithOutgoing));
    }

    @NotNull
    private static Map<RepositoryId, Map<String, Integer>> mapState(@NotNull Map<GitRepository, Map<GitLocalBranch, Integer>> projectState) {
        if (projectState == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(14);
        }
        HashMap<RepositoryId, Map<String, Integer>> result2 = new HashMap<RepositoryId, Map<String, Integer>>();
        projectState.forEach((repo, branches) -> result2.put(RepositoryExtKt.repositoryId((Repository)repo), GitBranchIncomingOutgoingManager.remapLocalBranchToName(branches)));
        HashMap<RepositoryId, Map<String, Integer>> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, Integer> remapLocalBranchToName(@NotNull Map<GitLocalBranch, Integer> repoState) {
        if (repoState == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(16);
        }
        HashMap<String, Integer> result2 = new HashMap<String, Integer>();
        repoState.forEach((localBranch, commits) -> result2.put(localBranch.getName(), (Integer)commits));
        HashMap<String, Integer> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithIncoming(@Nullable GitRepository repository2) {
        return GitBranchIncomingOutgoingManager.getBranches(repository2, this.myLocalBranchesWithIncoming);
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesWithOutgoing(@Nullable GitRepository repository2) {
        return GitBranchIncomingOutgoingManager.getBranches(repository2, this.myLocalBranchesWithOutgoing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithIncoming(boolean fromRemote) {
        if (!this.shouldCheckIncoming()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myShouldRequestRemoteInfo = fromRemote;
            this.myDirtyReposWithIncoming.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesWithOutgoing() {
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.addAll(GitRepositoryManager.getInstance(this.myProject).getRepositories());
        }
        this.scheduleUpdate();
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToFetch(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(18);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository2).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToFetchForRemote(repository2, (GitRemote)entry.getKey(), (Collection)entry.getValue(), this.getAuthenticationMode(repository2, (GitRemote)entry.getKey()))));
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToFetchForRemote(@NotNull GitRepository repository2, @NotNull GitRemote gitRemote, @NotNull Collection<? extends GitBranchTrackInfo> trackInfoList, AuthenticationMode mode) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(20);
        }
        if (gitRemote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(21);
        }
        if (trackInfoList == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(22);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchesCollection branchesCollection = repository2.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository2, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), mode);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                Hash localHashForRemoteBranch = branchesCollection.getHash((GitBranch)remoteBranch);
                if (localHashForRemoteBranch == null) {
                    return;
                }
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations())) && !localHashForRemoteBranch.equals((Object)remoteHash)) {
                    result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                }
            });
        }
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitLocalBranch, Integer> calcBranchesWithIncoming(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(24);
        }
        HashMap<GitLocalBranch, Integer> result2 = new HashMap<GitLocalBranch, Integer>();
        GitBranchesCollection branchesCollection = repository2.getBranches();
        Map<GitLocalBranch, Hash> cachedBranchesToFetch = this.myLocalBranchesToFetch.get(repository2);
        branchesCollection.getLocalBranches().forEach(localBranch -> {
            GitBranchTrackInfo info = GitBranchUtil.getTrackInfoForBranch(repository2, localBranch);
            if (info == null) {
                return;
            }
            Hash localHashForRemoteBranch = branchesCollection.getHash((GitBranch)info.getRemoteBranch());
            Hash localHash = branchesCollection.getHash((GitBranch)localBranch);
            if (localHashForRemoteBranch == null) {
                return;
            }
            Integer commits = this.getCommitsForBranch(repository2, info.getLocalBranch(), localHash, localHashForRemoteBranch, true);
            if (commits != null && commits > 0) {
                result2.put(info.getLocalBranch(), commits);
            } else if (cachedBranchesToFetch != null && localHashForRemoteBranch.equals(cachedBranchesToFetch.get(localBranch))) {
                result2.put(info.getLocalBranch(), 0);
            }
        });
        HashMap<GitLocalBranch, Integer> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(25);
        }
        return hashMap;
    }

    @NotNull
    private AuthenticationMode getAuthenticationMode(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(26);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(27);
        }
        AuthenticationMode authenticationMode = this.myAuthSuccessMap.get((Object)repository2).contains(remote) ? AuthenticationMode.SILENT : AuthenticationMode.NONE;
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(28);
        }
        return authenticationMode;
    }

    private boolean shouldAvoidUserInteraction(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(29);
        }
        return GitVcsSettings.getInstance((Project)this.myProject).getIncomingCheckStrategy() == GitIncomingCheckStrategy.Auto && GitBranchIncomingOutgoingManager.containsSSHUrl(remote) && (Boolean)HAS_EXTERNAL_SSH_AGENT.get() != false;
    }

    private static boolean containsSSHUrl(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(30);
        }
        return ContainerUtil.exists((Iterable)remote.getUrls(), url -> !url.startsWith("http"));
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, @NotNull AuthenticationMode authenticationMode) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(31);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(32);
        }
        if (branchRefNames == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(33);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(34);
        }
        HashMap<String, Hash> result2 = new HashMap<String, Hash>();
        if (!this.supportsIncomingOutgoing()) {
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(35);
            }
            return hashMap;
        }
        if (authenticationMode == AuthenticationMode.NONE || authenticationMode == AuthenticationMode.SILENT && this.shouldAvoidUserInteraction(remote)) {
            this.myErrorMap.putValue((Object)repository2, (Object)remote);
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(36);
            }
            return hashMap;
        }
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            List params = ContainerUtil.concat(List.of("--heads", remote.getName()), (List)refs);
            GitCommandResult lsRemoteResult = Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository2, remote, params, authenticationMode)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseBranchesLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myErrorMap.remove((Object)repository2, (Object)remote);
                this.myAuthSuccessMap.putValue((Object)repository2, (Object)remote);
            } else {
                this.myErrorMap.putValue((Object)repository2, (Object)remote);
            }
        });
        HashMap<String, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull List<String> params, @NotNull AuthenticationMode authenticationMode) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(38);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(39);
        }
        if (params == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(40);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(41);
        }
        GitLineHandler h = new GitLineHandler(this.myProject, repository2.getRoot(), GitCommand.LS_REMOTE);
        h.setIgnoreAuthenticationMode(authenticationMode);
        h.addParameters(params);
        h.setUrls(remote.getUrls());
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(42);
        }
        return gitLineHandler;
    }

    @NotNull
    private Map<GitLocalBranch, Integer> calculateBranchesWithOutgoing(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(43);
        }
        HashMap<GitLocalBranch, Integer> branchesWithOutgoing = new HashMap<GitLocalBranch, Integer>();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            Hash localHashForRemoteBranch;
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash hash = localHashForRemoteBranch = pushTarget != null ? branchesCollection.getHash((GitBranch)pushTarget.getBranch()) : null;
            Hash localHash = branchesCollection.getHash((GitBranch)branch);
            Integer commits = this.getCommitsForBranch(gitRepository, branch, localHash, localHashForRemoteBranch, false);
            if (commits == null || commits <= 0) continue;
            branchesWithOutgoing.put(branch, commits);
        }
        HashMap<GitLocalBranch, Integer> hashMap = branchesWithOutgoing;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(44);
        }
        return hashMap;
    }

    private Integer getCommitsForBranch(@NotNull GitRepository repository2, @NotNull GitLocalBranch localBranch, @Nullable Hash localBranchHash, @Nullable Hash localHashForRemoteBranch, boolean incoming) {
        Object to;
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(45);
        }
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(46);
        }
        if (!this.supportsIncomingOutgoing()) {
            return null;
        }
        if (localHashForRemoteBranch == null || Objects.equals(localBranchHash, localHashForRemoteBranch)) {
            return null;
        }
        String branchName = localBranch.getName();
        String from = incoming ? branchName : localHashForRemoteBranch.asString();
        String numberOfCommitsBetween = GitHistoryUtils.getNumberOfCommitsBetween(repository2, from, (String)(to = incoming ? branchName + "@{u}" : branchName));
        if (numberOfCommitsBetween == null) {
            LOG.warn("Can't get outgoing info (git rev-list " + branchName + " failed)");
            return null;
        }
        return StringsKt.toIntOrNull((String)numberOfCommitsBetween);
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository2, @NotNull Map<GitRepository, Map<GitLocalBranch, Integer>> branchCollection) {
        if (branchCollection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(47);
        }
        if (repository2 != null) {
            Map map3 = Objects.requireNonNullElse(branchCollection.get(repository2), Collections.emptyMap());
            Set<GitLocalBranch> set = map3.keySet();
            if (set == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(48);
            }
            return set;
        }
        Collection collection = (Collection)StreamEx.of(branchCollection.values()).map(map2 -> map2.keySet()).nonNull().flatMap(branches -> branches.stream()).collect(Collectors.toSet());
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(49);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(50);
        }
        if (!GitBranchIncomingOutgoingManager.shouldCheckIncomingOutgoing()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposWithOutgoing.add(repository2);
            this.myDirtyReposWithIncoming.add(repository2);
        }
        this.scheduleUpdate();
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository2, @NotNull GitRemote remote) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(51);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(52);
        }
        if (!this.shouldCheckIncoming()) {
            return;
        }
        this.myAuthSuccessMap.putValue((Object)repository2, (Object)remote);
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(53);
        }
        MultiMap multiMap = ContainerUtil.groupBy(repository2.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
        if (multiMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(54);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 13, 15, 17, 19, 23, 25, 28, 35, 36, 37, 42, 44, 48, 49, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 5: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 31: 
            case 38: 
            case 45: 
            case 50: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemote";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackInfoList";
                break;
            }
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchRefNames";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncomingOutgoingState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "mapState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "remapLocalBranchToName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToFetch";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesToFetchForRemote";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesWithIncoming";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationMode";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createLsRemoteHandler";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesWithOutgoing";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackInfoByRemotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasIncomingFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasOutgoingFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncomingFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOutgoingFor";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIncomingOutgoingState";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 54: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mapState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "remapLocalBranchToName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToFetch";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesToFetchForRemote";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesWithIncoming";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAuthenticationMode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldAvoidUserInteraction";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "containsSSHUrl";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createLsRemoteHandler";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesWithOutgoing";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsForBranch";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "repositoryChanged";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "authenticationSucceeded";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "groupTrackInfoByRemotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 13, 15, 17, 19, 23, 25, 28, 35, 36, 37, 42, 44, 48, 49, 54 -> new IllegalStateException(string);
        };
    }

    public static interface GitIncomingOutgoingListener {
        public void incomingOutgoingInfoChanged();
    }
}

