/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/rebase/GitSquashedCommitsMessage;", "", "<init>", "()V", "REBASE_SQUASH_SEPARATOR", "", "AUTOSQUASH_SUBJECT_REGEX", "Lkotlin/text/Regex;", "trimAutosquashSubject", "commitMessage", "isAutosquashCommitMessage", "", "squash", "message1", "message2", "prettySquash", "messages", "", "canAutosquash", "commitsSubjects", "", "getSubject", "message", "removeSubject", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSquashedCommitsMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSquashedCommitsMessage.kt\ngit4idea/rebase/GitSquashedCommitsMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1651#2:44\n1915#2:45\n1916#2:47\n1652#2:48\n1651#2:49\n1915#2:50\n1916#2:53\n1652#2:54\n1#3:46\n1#3:51\n1#3:52\n*S KotlinDebug\n*F\n+ 1 GitSquashedCommitsMessage.kt\ngit4idea/rebase/GitSquashedCommitsMessage\n*L\n21#1:44\n21#1:45\n21#1:47\n21#1:48\n25#1:49\n25#1:50\n25#1:53\n25#1:54\n21#1:46\n25#1:52\n*E\n"})
public final class GitSquashedCommitsMessage {
    @NotNull
    public static final GitSquashedCommitsMessage INSTANCE = new GitSquashedCommitsMessage();
    @NotNull
    private static final String REBASE_SQUASH_SEPARATOR = "\n\n\n";
    @NotNull
    private static final Regex AUTOSQUASH_SUBJECT_REGEX = new Regex("^(fixup|squash|amend)! (.+)$");

    private GitSquashedCommitsMessage() {
    }

    @NotNull
    public final String trimAutosquashSubject(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        return this.isAutosquashCommitMessage(commitMessage) ? this.removeSubject(commitMessage) : commitMessage;
    }

    public final boolean isAutosquashCommitMessage(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        CharSequence charSequence = this.getSubject(commitMessage);
        return AUTOSQUASH_SUBJECT_REGEX.matches(charSequence);
    }

    @NotNull
    public final String squash(@NotNull String message1, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message1, (String)"message1");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message2");
        return message1 + REBASE_SQUASH_SEPARATOR + message2;
    }

    @NotNull
    public final String prettySquash(@NotNull Collection<String> messages) {
        Collection destination$iv;
        String message;
        boolean bl;
        Object element$iv;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Iterable iterable = messages;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            element$iv = element$iv$iv = iterator.next();
            bl = false;
            message = (String)element$iv;
            boolean bl2 = false;
            if ((INSTANCE.isAutosquashCommitMessage(message) ? null : INSTANCE.getSubject(message)) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set distinctSubjects = (Set)destination$iv;
        $this$mapNotNullTo$iv = messages;
        destination$iv = new LinkedHashSet();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            element$iv = element$iv$iv = iterator.next();
            bl = false;
            message = (String)element$iv;
            boolean bl4 = false;
            if (INSTANCE.canAutosquash(message, distinctSubjects)) {
                String string2;
                String it = string2 = INSTANCE.trimAutosquashSubject(message);
                boolean bl5 = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
            } else {
                string = message;
            }
            if (string == null) continue;
            String it$iv = string;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)destination$iv, (CharSequence)REBASE_SQUASH_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean canAutosquash(String commitMessage, Set<String> commitsSubjects) {
        String subject = this.getSubject(commitMessage);
        Object object = Regex.find$default((Regex)AUTOSQUASH_SUBJECT_REGEX, (CharSequence)subject, (int)0, (int)2, null);
        String autosquashWith = object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)2) : null;
        return CollectionsKt.contains((Iterable)commitsSubjects, (Object)autosquashWith);
    }

    private final String getSubject(String message) {
        return (String)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)message));
    }

    private final String removeSubject(String commitMessage) {
        return ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter((String)commitMessage, (String)"\n", (String)""))).toString();
    }
}

