/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u00020\tH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/editor/SimpleDiffVirtualFile;", "Lcom/intellij/diff/editor/DiffVirtualFile;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "<init>", "(Lcom/intellij/diff/requests/DiffRequest;)V", "getRequest", "()Lcom/intellij/diff/requests/DiffRequest;", "getName", "", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "MyDiffRequestProcessor", "intellij.platform.diff.impl"})
public final class SimpleDiffVirtualFile
extends DiffVirtualFile {
    @NotNull
    private final DiffRequest request;

    public SimpleDiffVirtualFile(@NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = DiffBundle.message((String)"label.default.diff.editor.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string);
        this.request = request;
    }

    @NotNull
    public final DiffRequest getRequest() {
        return this.request;
    }

    @NotNull
    public String getName() {
        String string = this.request.getTitle();
        if (string == null) {
            String string2 = super.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MyDiffRequestProcessor(project, this.request);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + ":" + this.request;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/editor/SimpleDiffVirtualFile$MyDiffRequestProcessor;", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diff/requests/DiffRequest;)V", "getRequest", "()Lcom/intellij/diff/requests/DiffRequest;", "updateRequest", "", "force", "", "scrollToChangePolicy", "Lcom/intellij/diff/util/DiffUserDataKeysEx$ScrollToPolicy;", "intellij.platform.diff.impl"})
    private static final class MyDiffRequestProcessor
    extends DiffRequestProcessor {
        @NotNull
        private final DiffRequest request;

        public MyDiffRequestProcessor(@Nullable Project project, @NotNull DiffRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            super(project);
            this.request = request;
        }

        @NotNull
        public final DiffRequest getRequest() {
            return this.request;
        }

        @Override
        @RequiresEdt
        public synchronized void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            this.applyRequest(this.request, force, scrollToChangePolicy);
        }
    }
}

