/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class TextDiffViewerUtil {
    private static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result, (Object[])new AnAction[]{ActionManager.getInstance().getAction("Diff.EditorPopupMenu")});
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(1);
        }
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        return TextDiffViewerUtil.getFoldingModelSettings(settings);
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (settings == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(2);
        }
        return new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings;
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(3);
        }
        if ((settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.TextDiffSettings.KEY)) == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = settings;
        if (textDiffSettings == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(4);
        }
        return textDiffSettings;
    }

    public static boolean @NotNull [] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(5);
        }
        if (request == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(6);
        }
        List contents = request.getContents();
        int contentCount = contents.size();
        boolean[] result = new boolean[contentCount];
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length != contentCount) {
            LOG.warn("Invalid FORCE_READ_ONLY_CONTENTS key value: " + String.valueOf(request));
            data = null;
        }
        for (int i = 0; i < contents.size(); ++i) {
            if (!DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{(UserDataHolder)contents.get(i), request, context}) && (data == null || !data[i])) continue;
            result[i] = true;
        }
        if (result == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(7);
        }
        return result;
    }

    public static void installDocumentListeners(@NotNull DocumentListener listener, @NotNull List<? extends Document> documents, @NotNull Disposable disposable) {
        if (listener == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(8);
        }
        if (documents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(9);
        }
        if (disposable == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(10);
        }
        for (Document document : new HashSet<Document>(documents)) {
            document.addDocumentListener(listener, disposable);
        }
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        if (request == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(11);
        }
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i = 0; i < contents.size(); ++i) {
            for (int j = i + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request).append("\n");
            for (DiffContent content : contents) {
                message.append(content).append("\n");
            }
            LOG.warn(message.toString());
        }
    }

    @Nullable
    public static JPanel createEqualContentsNotification(@NotNull List<? extends DocumentContent> contents) {
        boolean isPartialPreview;
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(12);
        }
        if (isPartialPreview = ContainerUtil.exists(contents, content -> FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(content.getDocument()))) {
            return null;
        }
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        return DiffNotifications.createEqualContents(equalCharsets, equalSeparators);
    }

    public static boolean areEqualLineSeparators(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(13);
        }
        return TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getLineSeparator);
    }

    public static boolean areEqualCharsets(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(14);
        }
        boolean sameCharset = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getCharset);
        boolean sameBOM = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::hasBom);
        return sameCharset && sameBOM;
    }

    private static <T> boolean areEqualDocumentContentProperties(@NotNull List<? extends DiffContent> contents, @NotNull Function<? super DocumentContent, ? extends T> propertyGetter) {
        List properties;
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(15);
        }
        if (propertyGetter == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(16);
        }
        if ((properties = ContainerUtil.mapNotNull(contents, content -> {
            FileDocumentContentImpl o;
            if (content instanceof EmptyContent) {
                return null;
            }
            if (content instanceof FileDocumentContentImpl && (o = (FileDocumentContentImpl)((Object)content)).getProject() != null) {
                try (AccessToken ignore = ProjectLocator.withPreferredProject((VirtualFile)o.getFile(), (Project)o.getProject());){
                    Object object = propertyGetter.apply((Object)o);
                    return object;
                }
            }
            return propertyGetter.fun((Object)((DocumentContent)content));
        })).size() < 2) {
            return true;
        }
        return new HashSet(properties).size() == 1;
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2, boolean isLocalChangeRevert) {
        if (document1 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(17);
        }
        if (document2 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(18);
        }
        DiffUtil.applyModification(document1, line1, line2, document2, oLine1, oLine2);
        if (isLocalChangeRevert) {
            DiffUtil.clearLineModificationFlags(document1, line1, line1 + (oLine2 - oLine1));
        }
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        if (editors == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(19);
        }
        List list = ContainerUtil.filter(editors, editor -> !editor.isViewer());
        if (list == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyGetter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkForceReadOnly";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableEditors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingModelSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForceReadOnly";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installDocumentListeners";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkDifferentDocuments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEqualContentsNotification";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areEqualLineSeparators";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areEqualCharsets";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areEqualDocumentContentProperties";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyModification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEditableEditors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    public static class EditorActionsPopup {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            if (editorPopupActions == null) {
                EditorActionsPopup.$$$reportNull$$$0(0);
            }
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends EditorEx> editors, @NotNull JComponent component2) {
            if (editors == null) {
                EditorActionsPopup.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                EditorActionsPopup.$$$reportNull$$$0(2);
            }
            DiffUtil.recursiveRegisterShortcutSet((ActionGroup)new DefaultActionGroup(this.myEditorPopupActions), component2, null);
            ContextMenuPopupHandler.Simple handler = new ContextMenuPopupHandler.Simple((ActionGroup)(this.myEditorPopupActions.isEmpty() ? null : new DefaultActionGroup(this.myEditorPopupActions)));
            for (EditorEx editorEx : editors) {
                editorEx.installPopupHandler((EditorPopupHandler)handler);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorPopupActions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(0);
            }
            this.myDuringUpdate = false;
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(1);
            }
            if (this.myEditors.size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                editorEx.addPropertyChangeListener((PropertyChangeListener)this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize2D".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            float fontSize = ((Float)evt.getNewValue()).floatValue();
            for (EditorEx editorEx : this.myEditors) {
                if (evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, float fontSize) {
            if (editor == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(2);
            }
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            if (context == null) {
                EditorReadOnlyLockAction.$$$reportNull$$$0(0);
            }
            if (editableEditors == null) {
                EditorReadOnlyLockAction.$$$reportNull$$$0(1);
            }
            super(context);
            this.myEditableEditors = editableEditors;
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
                this.putEditorHint(editorEx, readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editableEditors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            if (context == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(0);
            }
            super(DiffBundle.message((String)"disable.editing", (Object[])new Object[0]), null, AllIcons.Diff.Lock);
            this.myContext = context;
            this.mySettings = TextDiffViewerUtil.getTextSettings(context);
        }

        protected void applyDefaults() {
            if (this.isVisible()) {
                this.setSelected(this.isSelected());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(2);
            }
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(3);
            }
            return this.isSelected();
        }

        boolean isSelected() {
            return this.mySettings.isReadOnlyLock();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(4);
            }
            this.setSelected(state);
        }

        void setSelected(boolean state) {
            this.mySettings.setReadOnlyLock(state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();

        protected void putEditorHint(@NotNull EditorEx editor, boolean readOnly) {
            if (editor == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(5);
            }
            if (readOnly) {
                EditorModificationUtil.setReadOnlyHint((Editor)editor, (String)DiffBundle.message((String)"editing.viewer.hint.enable.editing.text", (Object[])new Object[0]), e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        this.setSelected(false);
                    }
                });
            } else {
                EditorModificationUtil.setReadOnlyHint((Editor)editor, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "putEditorHint";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class ToggleExpandByDefaultAction
    extends DumbAwareToggleAction {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;
        private final FoldingModelSupport myFoldingSupport;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull FoldingModelSupport foldingSupport) {
            if (settings == null) {
                ToggleExpandByDefaultAction.$$$reportNull$$$0(0);
            }
            if (foldingSupport == null) {
                ToggleExpandByDefaultAction.$$$reportNull$$$0(1);
            }
            super(DiffBundle.message((String)"collapse.unchanged.fragments", (Object[])new Object[0]), null, AllIcons.Actions.Collapseall);
            this.mySettings = settings;
            this.myFoldingSupport = foldingSupport;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleExpandByDefaultAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleExpandByDefaultAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setVisible(this.mySettings.getContextRange() != -1 && this.myFoldingSupport.isEnabled());
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected void expandAll(boolean expand) {
            this.myFoldingSupport.expandAll(expand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingSupport";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleExpandByDefaultAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleExpandByDefaultAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ToggleAutoScrollAction
    extends DumbAwareToggleAction {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                ToggleAutoScrollAction.$$$reportNull$$$0(0);
            }
            super(DiffBundle.message((String)"synchronize.scrolling", (Object[])new Object[0]), null, AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleAutoScrollAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAutoScrollAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setVisible(!this.mySettings.isEnableAligningChangesMode());
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAutoScrollAction.$$$reportNull$$$0(3);
            }
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleAutoScrollAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleAutoScrollAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class IgnorePolicySettingAction
    extends EnumPolicySettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, IgnorePolicy ... policies) {
            if (settings == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(0);
            }
            if (policies == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(1);
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull IgnorePolicy option) {
            if (option == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(2);
            }
            if (this.getValue() == option) {
                return;
            }
            DiffUsageTriggerCollector.logToggleIgnorePolicy(option, this.mySettings.getPlace());
            this.mySettings.setIgnorePolicy(option);
        }

        @Override
        @NotNull
        protected IgnorePolicy getStoredValue() {
            IgnorePolicy ignorePolicy2 = this.mySettings.getIgnorePolicy();
            if (ignorePolicy2 == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(3);
            }
            return ignorePolicy2;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getValueSubstitutes(@NotNull IgnorePolicy value) {
            if (value == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(4);
            }
            if (value == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
                List<IgnorePolicy> list = Collections.singletonList(IgnorePolicy.IGNORE_WHITESPACES);
                if (list == null) {
                    IgnorePolicySettingAction.$$$reportNull$$$0(5);
                }
                return list;
            }
            if (value == IgnorePolicy.FORMATTING) {
                List<IgnorePolicy> list = Collections.singletonList(IgnorePolicy.TRIM_WHITESPACES);
                if (list == null) {
                    IgnorePolicySettingAction.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<IgnorePolicy> list = Collections.singletonList(IgnorePolicy.DEFAULT);
            if (list == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        @Nls
        @NotNull
        protected String getText(@NotNull IgnorePolicy option) {
            if (option == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(8);
            }
            String string = option.getText();
            if (string == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredValue";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueSubstitutes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueSubstitutes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 7, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class HighlightPolicySettingAction
    extends EnumPolicySettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, HighlightPolicy ... policies) {
            if (settings == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(0);
            }
            if (policies == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(1);
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull HighlightPolicy option) {
            if (option == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(2);
            }
            if (this.getValue() == option) {
                return;
            }
            DiffUsageTriggerCollector.logToggleHighlightPolicy(option, this.mySettings.getPlace());
            this.mySettings.setHighlightPolicy(option);
        }

        @Override
        @NotNull
        protected HighlightPolicy getStoredValue() {
            HighlightPolicy highlightPolicy = this.mySettings.getHighlightPolicy();
            if (highlightPolicy == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(3);
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getValueSubstitutes(@NotNull HighlightPolicy value) {
            if (value == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(4);
            }
            if (value == HighlightPolicy.BY_WORD_SPLIT) {
                List<HighlightPolicy> list = Collections.singletonList(HighlightPolicy.BY_WORD);
                if (list == null) {
                    HighlightPolicySettingAction.$$$reportNull$$$0(5);
                }
                return list;
            }
            if (value == HighlightPolicy.DO_NOT_HIGHLIGHT) {
                List<HighlightPolicy> list = Collections.singletonList(HighlightPolicy.BY_LINE);
                if (list == null) {
                    HighlightPolicySettingAction.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<HighlightPolicy> list = Collections.singletonList(HighlightPolicy.BY_WORD);
            if (list == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        @Nls
        @NotNull
        protected String getText(@NotNull HighlightPolicy option) {
            if (option == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(8);
            }
            String string = option.getText();
            if (string == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredValue";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueSubstitutes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueSubstitutes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6, 7, 9 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class EnumPolicySettingAction<T extends Enum<T>>
    extends ComboBoxSettingAction<T> {
        private final T @NotNull [] myPolicies;

        public EnumPolicySettingAction(T @NotNull [] policies) {
            if (policies == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(0);
            }
            assert (policies.length > 0);
            this.myPolicies = policies;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(this.myPolicies.length > 1);
        }

        @Override
        @NotNull
        protected @Unmodifiable List<T> getAvailableOptions() {
            List list = ContainerUtil.sorted(Arrays.asList(this.myPolicies));
            if (list == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public T getValue() {
            T value = this.getStoredValue();
            if (ArrayUtil.contains(value, (Object[])this.myPolicies)) {
                T t = value;
                if (t == null) {
                    EnumPolicySettingAction.$$$reportNull$$$0(3);
                }
                return t;
            }
            List<T> substitutes = this.getValueSubstitutes(value);
            for (Enum substitute : substitutes) {
                if (!ArrayUtil.contains((Object)substitute, (Object[])this.myPolicies)) continue;
                Enum enum_ = substitute;
                if (enum_ == null) {
                    EnumPolicySettingAction.$$$reportNull$$$0(4);
                }
                return (T)enum_;
            }
            T t = this.myPolicies[0];
            if (t == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(5);
            }
            return t;
        }

        @NotNull
        protected abstract T getStoredValue();

        @NotNull
        protected List<T> getValueSubstitutes(@NotNull T value) {
            if (value == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(6);
            }
            List list = Collections.emptyList();
            if (list == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableOptions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueSubstitutes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueSubstitutes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myActions;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getValue()));
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
            if (button == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(2);
            }
            if (context == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(3);
            }
            DefaultActionGroup defaultActionGroup = this.getActions();
            if (defaultActionGroup == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(4);
            }
            return defaultActionGroup;
        }

        @NotNull
        public DefaultActionGroup getActions() {
            if (this.myActions == null) {
                this.myActions = new DefaultActionGroup();
                for (T setting : this.getAvailableOptions()) {
                    this.myActions.add((AnAction)new MyAction(setting));
                }
            }
            DefaultActionGroup defaultActionGroup = this.myActions;
            if (defaultActionGroup == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(5);
            }
            return defaultActionGroup;
        }

        @NotNull
        protected abstract @Unmodifiable List<T> getAvailableOptions();

        @NotNull
        protected abstract T getValue();

        protected abstract void setValue(@NotNull T var1);

        @NotNull
        @Nls
        protected abstract String getText(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopupActionGroup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }

        private class MyAction
        extends AnAction
        implements Toggleable,
        DumbAware {
            @NotNull
            private final T myOption;

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    MyAction.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAction.$$$reportNull$$$0(1);
                }
                Toggleable.setSelected((Presentation)e.getPresentation(), (ComboBoxSettingAction.this.getValue() == this.myOption ? 1 : 0) != 0);
            }

            MyAction(T option) {
                if (option == null) {
                    MyAction.$$$reportNull$$$0(2);
                }
                super(ComboBoxSettingAction.this.getText(option));
                this.myOption = option;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAction.$$$reportNull$$$0(3);
                }
                ComboBoxSettingAction.this.setValue(this.myOption);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

