/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginOsRequirement;
import com.intellij.ide.plugins.PluginNonLoadReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0019\u0010\u0014\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0019\u0010\u0017\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/plugins/PluginIsIncompatibleWithHostPlatform;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "requiredOs", "Lcom/intellij/ide/plugins/IdeaPluginOsRequirement;", "hostOs", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Lcom/intellij/ide/plugins/IdeaPluginOsRequirement;Ljava/lang/String;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getRequiredOs", "()Lcom/intellij/ide/plugins/IdeaPluginOsRequirement;", "getHostOs", "()Ljava/lang/String;", "detailedMessage", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginIsIncompatibleWithHostPlatform
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @NotNull
    private final IdeaPluginOsRequirement requiredOs;
    @NotNull
    private final String hostOs;
    private final boolean shouldNotifyUser;

    public PluginIsIncompatibleWithHostPlatform(@NotNull IdeaPluginDescriptor plugin, @NotNull IdeaPluginOsRequirement requiredOs, @NotNull String hostOs) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)requiredOs, (String)"requiredOs");
        Intrinsics.checkNotNullParameter((Object)hostOs, (String)"hostOs");
        this.plugin = plugin;
        this.requiredOs = requiredOs;
        this.hostOs = hostOs;
        this.shouldNotifyUser = true;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final IdeaPluginOsRequirement getRequiredOs() {
        return this.requiredOs;
    }

    @NotNull
    public final String getHostOs() {
        return this.hostOs;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.getPlugin().getVersion(), this.requiredOs, this.hostOs};
        return CoreBundle.message((String)"plugin.loading.error.long.incompatible.with.platform", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.requiredOs};
        return CoreBundle.message((String)"plugin.loading.error.short.incompatible.with.platform", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ", version=" + this.getPlugin().getVersion() + ") requires platform " + this.requiredOs + " but the current platform is " + this.hostOs;
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }
}

