/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeInfoImpl
implements ChangeInfo {
    @Nullable
    private final ASTNode myOldChild;
    @Nullable
    private final ASTNode myNewChild;
    private final int myOffset;
    private final int myOldLength;
    private final int myNewLength;

    ChangeInfoImpl(@Nullable ASTNode oldChild, @Nullable ASTNode newChild, int offset, int oldLength) {
        this.myOldChild = oldChild;
        this.myNewChild = newChild;
        this.myOffset = offset;
        this.myOldLength = oldLength;
        this.myNewLength = newChild != null ? newChild.getTextLength() : 0;
    }

    public ASTNode getOldChildNode() {
        return this.myOldChild;
    }

    public int getOffsetInParent() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    public int getNewLength() {
        return this.myNewLength;
    }

    @Nullable
    public ASTNode getNewChild() {
        return this.myNewChild;
    }

    @Override
    public int getChangeType() {
        if (this.myOldChild == this.myNewChild) {
            return 3;
        }
        if (this.myOldChild != null) {
            return this.myNewChild == null ? 1 : 2;
        }
        return 0;
    }

    public String toString() {
        return this.myOldChild + "(" + this.myOldLength + ")->" + this.myNewChild + "(" + this.myNewLength + ") at " + this.myOffset;
    }

    int getLengthDelta() {
        return this.myNewLength - this.myOldLength;
    }

    ASTNode getAffectedChild() {
        return this.myNewChild != null ? this.myNewChild : this.myOldChild;
    }

    void fireEvent(int parentStart, PsiFile file, ASTNode parent) {
        PsiTreeChangeEventImpl e = ChangeInfoImpl.createEvent(file, this.myOffset + parentStart);
        if (this.myOldChild == this.myNewChild && this.myNewChild != null) {
            ChangeInfoImpl.childrenChanged(e, this.myNewChild, this.myOldLength);
        } else if (this.myOldChild != null && this.myNewChild != null) {
            this.childReplaced(e, this.myOldChild, this.myNewChild, parent);
        } else if (this.myOldChild != null) {
            this.childRemoved(e, this.myOldChild, parent);
        } else if (this.myNewChild != null) {
            ChangeInfoImpl.childAdded(e, this.myNewChild, parent);
        }
    }

    @NotNull
    static PsiTreeChangeEventImpl createEvent(@NotNull PsiFile psiFile, int offset) {
        if (psiFile == null) {
            ChangeInfoImpl.$$$reportNull$$$0(0);
        }
        PsiTreeChangeEventImpl e = new PsiTreeChangeEventImpl(psiFile.getManager());
        e.setFile(psiFile);
        e.setOffset(offset);
        PsiTreeChangeEventImpl psiTreeChangeEventImpl = e;
        if (psiTreeChangeEventImpl == null) {
            ChangeInfoImpl.$$$reportNull$$$0(1);
        }
        return psiTreeChangeEventImpl;
    }

    boolean hasNoPsi() {
        return this.myOldChild != null && this.myOldChild.getPsi() == null || this.myNewChild != null && this.myNewChild.getPsi() == null;
    }

    private static void childAdded(PsiTreeChangeEventImpl e, ASTNode child, ASTNode parent) {
        e.setParent(parent.getPsi());
        e.setChild(child.getPsi());
        ChangeInfoImpl.getPsiManagerEx(e).childAdded(e);
    }

    private void childRemoved(PsiTreeChangeEventImpl e, ASTNode child, ASTNode parent) {
        e.setParent(parent.getPsi());
        e.setChild(child.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerEx(e).childRemoved(e);
    }

    private void childReplaced(PsiTreeChangeEventImpl e, ASTNode oldChild, ASTNode newChild, ASTNode parent) {
        e.setParent(parent.getPsi());
        e.setOldChild(oldChild.getPsi());
        e.setChild(newChild.getPsi());
        e.setNewChild(newChild.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerEx(e).childReplaced(e);
    }

    static void childrenChanged(PsiTreeChangeEventImpl e, ASTNode parent, int oldLength) {
        e.setParent(parent.getPsi());
        e.setOldLength(oldLength);
        ChangeInfoImpl.getPsiManagerEx(e).childrenChanged(e);
    }

    private static PsiManagerEx getPsiManagerEx(PsiTreeChangeEventImpl e) {
        return (PsiManagerEx)((Object)e.getSource());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/tree/events/impl/ChangeInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/tree/events/impl/ChangeInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

