/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create((String)"UNCLOSED_ELEMENT_PROPERTY");
    public static final Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create((String)"CONTAINING_FILE_KEY_AFTER_REPARSE");

    public static void ensureParsed(@Nullable ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(@NotNull ASTNode parent, @NotNull IElementType type) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED && parent instanceof TreeElement) {
            ((TreeElement)parent).assertReadAccessAllowed();
        }
        for (ASTNode element = parent.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(@Nullable ASTNode element, @NotNull TokenSet types) {
        ASTNode candidate;
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        for (candidate = element; candidate != null && types.contains(candidate.getElementType()); candidate = candidate.getTreeNext()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element, @NotNull TokenSet types) {
        ASTNode candidate;
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        for (candidate = element; candidate != null && types.contains(candidate.getElementType()); candidate = candidate.getTreePrev()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element, @NotNull IElementType type) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (parent.getElementType() != type) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element, @NotNull TokenSet types) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!types.contains(parent.getElementType())) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element, @NotNull TokenSet types, @Nullable TokenSet stopAt) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (types.contains(parent.getElementType())) {
                return parent;
            }
            if (stopAt == null || !stopAt.contains(parent.getElementType())) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(@NotNull ASTNode element) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        return (LeafElement)TreeUtil.findFirstLeaf(element, true);
    }

    public static ASTNode findFirstLeaf(@NotNull ASTNode element, boolean expandChameleons) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findLastLeaf(@NotNull ASTNode element) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        return TreeUtil.findLastLeaf(element, true);
    }

    public static ASTNode findLastLeaf(@NotNull ASTNode element, boolean expandChameleons) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, @NotNull IElementType elementType) {
        if (elementType == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, @NotNull TokenSet types) {
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, @NotNull IElementType elementType) {
        if (elementType == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, @NotNull TokenSet types) {
        if (types == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents = new HashSet<ASTNode>(20);
        while (one != null) {
            parents.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    @NotNull
    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            Couple couple = Couple.of(null, null);
            if (couple == null) {
                TreeUtil.$$$reportNull$$$0(18);
            }
            return couple;
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        Couple couple = Couple.of((Object)one, (Object)two);
        if (couple == null) {
            TreeUtil.$$$reportNull$$$0(19);
        }
        return couple;
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(20);
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(21);
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull LeafElement node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(22);
        }
        return TreeUtil.nextLeaf(node, null);
    }

    public static FileElement getFileElement(@NotNull TreeElement element) {
        TreeElement parent;
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(23);
        }
        for (parent = element; parent != null && !(parent instanceof FileElement); parent = parent.getTreeParent()) {
        }
        if (parent == null) {
            parent = (TreeElement)element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent;
    }

    public static FileASTNode getFileElement(@NotNull ASTNode element) {
        ASTNode parent;
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(24);
        }
        for (parent = element; parent != null && !(parent instanceof FileASTNode); parent = parent.getTreeParent()) {
        }
        if (parent == null) {
            parent = (ASTNode)element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileASTNode)parent;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type) {
        return type instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent) {
        if (start == null) {
            TreeUtil.$$$reportNull$$$0(25);
        }
        return (LeafElement)TreeUtil.nextLeaf(start, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        if (start == null) {
            TreeUtil.$$$reportNull$$$0(26);
        }
        for (TreeElement element = start; element != null; element = element.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element, true);
            }
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return null;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start, boolean slopeSide) {
        if (start instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start.getElementType()) || slopeSide && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(27);
        }
        final class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            private TreeElement result;

            MyVisitor(boolean doTransform) {
                super(doTransform);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor = new MyVisitor(expandChameleons);
        element.acceptTree(visitor);
        return visitor.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start, @Nullable CommonParentState commonParent) {
        while (start != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
                }
                commonParent.nextLeafBranchStart = start;
            }
            TreeElement prevTree = start;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element) {
        ASTNode child = element;
        while (child != null) {
            element = child;
            child = element.getLastChildNode();
        }
        return element;
    }

    public static boolean containsOuterLanguageElements(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(28);
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof OuterLanguageElement) {
                    result.set(true);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element);
            }
        });
        return result.get();
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(@Nullable ASTNode node, boolean forward) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY, forward);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(@Nullable ASTNode node, @NotNull TokenSet alsoSkip, boolean forward) {
        if (alsoSkip == null) {
            TreeUtil.$$$reportNull$$$0(29);
        }
        ASTNode element = node;
        while (true) {
            if (element == null) {
                return null;
            }
            if (!TreeUtil.isWhitespaceOrComment(element) && !alsoSkip.contains(element.getElementType())) break;
            element = forward ? element.getTreeNext() : element.getTreePrev();
        }
        return element;
    }

    public static boolean isWhitespaceOrComment(@NotNull ASTNode element) {
        if (element == null) {
            TreeUtil.$$$reportNull$$$0(30);
        }
        return element.getPsi() instanceof PsiWhiteSpace || element.getPsi() instanceof PsiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/TreeUtil";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/TreeUtil";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostSiblingParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findChildBackward";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipElementsBack";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFirstLeaf";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLastLeaf";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSibling";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingBackward";
                break;
            }
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFileElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findFirstLeafOrType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "containsOuterLanguageElements";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOrComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CommonParentState {
        TreeElement startLeafBranchStart;
        public ASTNode nextLeafBranchStart;
        CompositeElement strongWhiteSpaceHolder;
        boolean isStrongElementOnRisingSlope = true;
    }
}

