/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WslIjentAvailabilityService;
import com.intellij.openapi.application.Experiments;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLCommandLineOptions {
    private boolean myLaunchWithWslExe = !WslIjentAvailabilityService.getInstance().runWslCommandsViaIjent();
    private boolean myExecuteCommandInShell = true;
    private boolean myExecuteCommandInInteractiveShell = false;
    private boolean myExecuteCommandInLoginShell = true;
    private boolean mySudo = false;
    private String myRemoteWorkingDirectory;
    private boolean myPassEnvVarsUsingInterop = false;
    private final List<String> myInitShellCommands = new ArrayList<String>();
    private boolean myExecuteCommandInDefaultShell = false;
    private double mySleepTimeoutSec = 0.0;

    public boolean isLaunchWithWslExe() {
        return this.myLaunchWithWslExe && Experiments.getInstance().isFeatureEnabled("wsl.execute.with.wsl.exe");
    }

    @NotNull
    public WSLCommandLineOptions setLaunchWithWslExe(boolean launchWithWslExe) {
        this.myLaunchWithWslExe = launchWithWslExe;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(0);
        }
        return wSLCommandLineOptions;
    }

    public boolean isExecuteCommandInShell() {
        return this.myExecuteCommandInShell;
    }

    @NotNull
    public WSLCommandLineOptions setExecuteCommandInShell(boolean executeCommandInShell) {
        this.myExecuteCommandInShell = executeCommandInShell;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(1);
        }
        return wSLCommandLineOptions;
    }

    public boolean isExecuteCommandInInteractiveShell() {
        return this.myExecuteCommandInInteractiveShell;
    }

    @NotNull
    public WSLCommandLineOptions setExecuteCommandInInteractiveShell(boolean executeCommandInInteractiveShell) {
        this.myExecuteCommandInInteractiveShell = executeCommandInInteractiveShell;
        if (this.myExecuteCommandInInteractiveShell) {
            this.myExecuteCommandInShell = true;
        }
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(2);
        }
        return wSLCommandLineOptions;
    }

    public boolean isExecuteCommandInLoginShell() {
        return this.myExecuteCommandInLoginShell;
    }

    @NotNull
    public WSLCommandLineOptions setExecuteCommandInLoginShell(boolean executeCommandInLoginShell) {
        this.myExecuteCommandInLoginShell = executeCommandInLoginShell;
        if (this.myExecuteCommandInLoginShell) {
            this.myExecuteCommandInShell = true;
        }
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(3);
        }
        return wSLCommandLineOptions;
    }

    public boolean isExecuteCommandInDefaultShell() {
        return this.myExecuteCommandInDefaultShell;
    }

    @ApiStatus.Experimental
    @NotNull
    public WSLCommandLineOptions setExecuteCommandInDefaultShell(boolean executeCommandInDefaultShell) {
        this.myExecuteCommandInDefaultShell = executeCommandInDefaultShell;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(4);
        }
        return wSLCommandLineOptions;
    }

    public boolean isSudo() {
        return this.mySudo;
    }

    @NotNull
    public WSLCommandLineOptions setSudo(boolean sudo) {
        this.mySudo = sudo;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(5);
        }
        return wSLCommandLineOptions;
    }

    @Nullable
    public String getRemoteWorkingDirectory() {
        return this.myRemoteWorkingDirectory;
    }

    @NotNull
    public WSLCommandLineOptions setRemoteWorkingDirectory(@Nullable String remoteWorkingDirectory) {
        this.myRemoteWorkingDirectory = remoteWorkingDirectory;
        if (remoteWorkingDirectory != null && !remoteWorkingDirectory.startsWith("/")) {
            throw new AssertionError((Object)("Linux path was expected, but got " + remoteWorkingDirectory));
        }
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(6);
        }
        return wSLCommandLineOptions;
    }

    public boolean isPassEnvVarsUsingInterop() {
        return this.myPassEnvVarsUsingInterop;
    }

    @NotNull
    public WSLCommandLineOptions setPassEnvVarsUsingInterop(boolean passEnvVarsUsingInterop) {
        this.myPassEnvVarsUsingInterop = passEnvVarsUsingInterop;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(7);
        }
        return wSLCommandLineOptions;
    }

    @NotNull
    public List<String> getInitShellCommands() {
        List<String> list2 = this.myInitShellCommands;
        if (list2 == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public double getSleepTimeoutSec() {
        return this.mySleepTimeoutSec;
    }

    @NotNull
    public WSLCommandLineOptions setSleepTimeoutSec(double sleepTimeoutSec) {
        this.mySleepTimeoutSec = sleepTimeoutSec;
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(9);
        }
        return wSLCommandLineOptions;
    }

    @NotNull
    public WSLCommandLineOptions addInitCommand(@NotNull String initCommand) {
        if (initCommand == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(10);
        }
        this.myInitShellCommands.add(initCommand);
        WSLCommandLineOptions wSLCommandLineOptions = this;
        if (wSLCommandLineOptions == null) {
            WSLCommandLineOptions.$$$reportNull$$$0(11);
        }
        return wSLCommandLineOptions;
    }

    public String toString() {
        return "launchWithWslExe=" + this.myLaunchWithWslExe + ", executeCommandInShell=" + this.myExecuteCommandInShell + ", sudo=" + this.mySudo + ", remoteWorkingDirectory='" + this.myRemoteWorkingDirectory + "', passEnvVarsUsingInterop=" + this.myPassEnvVarsUsingInterop + ", initCommands=" + String.valueOf(this.myInitShellCommands);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLCommandLineOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setLaunchWithWslExe";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setExecuteCommandInShell";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setExecuteCommandInInteractiveShell";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setExecuteCommandInLoginShell";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setExecuteCommandInDefaultShell";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setSudo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteWorkingDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setPassEnvVarsUsingInterop";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitShellCommands";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setSleepTimeoutSec";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLCommandLineOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addInitCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addInitCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 10 -> new IllegalArgumentException(string);
        };
    }
}

