/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CustomShortcutSet
implements ShortcutSet {
    public static final CustomShortcutSet EMPTY = new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
    private final Shortcut[] shortcuts;

    public CustomShortcutSet(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            CustomShortcutSet.$$$reportNull$$$0(0);
        }
        this(new KeyboardShortcut(keyStroke, null));
    }

    public CustomShortcutSet(Shortcut ... shortcuts) {
        if (shortcuts == null) {
            CustomShortcutSet.$$$reportNull$$$0(1);
        }
        this.shortcuts = shortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])shortcuts.clone();
    }

    public CustomShortcutSet(Integer ... keyCodes) {
        if (keyCodes == null) {
            CustomShortcutSet.$$$reportNull$$$0(2);
        }
        if (keyCodes.length == 0) {
            this.shortcuts = Shortcut.EMPTY_ARRAY;
        } else {
            this.shortcuts = Arrays.copyOf(Shortcut.EMPTY_ARRAY, keyCodes.length);
            for (int i = 0; i < keyCodes.length; ++i) {
                this.shortcuts[i] = new KeyboardShortcut(KeyStroke.getKeyStroke(keyCodes[i], 0), null);
            }
        }
    }

    @Override
    public Shortcut @NotNull [] getShortcuts() {
        Shortcut[] shortcutArray = this.shortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])this.shortcuts.clone();
        if (shortcutArray == null) {
            CustomShortcutSet.$$$reportNull$$$0(3);
        }
        return shortcutArray;
    }

    @Override
    public boolean hasShortcuts() {
        return this.shortcuts.length != 0;
    }

    @NotNull
    public static CustomShortcutSet fromString(String ... keyboardShortcuts) {
        if (keyboardShortcuts == null) {
            CustomShortcutSet.$$$reportNull$$$0(4);
        }
        Shortcut[] shortcuts = new KeyboardShortcut[keyboardShortcuts.length];
        for (int i = 0; i < keyboardShortcuts.length; ++i) {
            shortcuts[i] = KeyboardShortcut.fromString(keyboardShortcuts[i]);
        }
        return new CustomShortcutSet(shortcuts);
    }

    @NotNull
    public static CustomShortcutSet fromStrings(@NotNull Collection<@NonNls String> shortcuts) {
        if (shortcuts == null) {
            CustomShortcutSet.$$$reportNull$$$0(5);
        }
        return new CustomShortcutSet((Shortcut[])shortcuts.stream().map(KeyboardShortcut::fromString).toArray(KeyboardShortcut[]::new));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/CustomShortcutSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyboardShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/CustomShortcutSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromStrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

