/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/actionSystem/toolbarLayout/NoWrapLayoutStrategy;", "Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;", "myAdjustTheSameSize", "", "<init>", "(Z)V", "doCalculateBounds", "", "Ljava/awt/Rectangle;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "calculateBounds", "calcPreferredSize", "Ljava/awt/Dimension;", "calcMinimumSize", "intellij.platform.editor.ui"})
@SourceDebugExtension(value={"SMAP\nNoWrapLayoutStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoWrapLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/NoWrapLayoutStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1#2:91\n2829#3,7:92\n*S KotlinDebug\n*F\n+ 1 NoWrapLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/NoWrapLayoutStrategy\n*L\n79#1:92,7\n*E\n"})
public final class NoWrapLayoutStrategy
implements ToolbarLayoutStrategy {
    private final boolean myAdjustTheSameSize;

    public NoWrapLayoutStrategy(boolean myAdjustTheSameSize) {
        this.myAdjustTheSameSize = myAdjustTheSameSize;
    }

    private final List<Rectangle> doCalculateBounds(ActionToolbar toolbar) {
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent toolbarComponent = jComponent;
        int componentsCount = toolbarComponent.getComponentCount();
        int width = toolbarComponent.getWidth();
        int height = toolbarComponent.getHeight();
        Insets insets = toolbarComponent.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        int orientation = toolbar.getOrientation();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(componentsCount);
        int n = 0;
        while (n < componentsCount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Rectangle> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new Rectangle());
        }
        List res = arrayList;
        if (this.myAdjustTheSameSize) {
            int maxWidth = ToolbarLayoutUtilKt.maxComponentPreferredWidth(toolbarComponent);
            int maxHeight = ToolbarLayoutUtilKt.maxComponentPreferredHeight(toolbarComponent);
            int offset = 0;
            if (orientation == 0) {
                for (i = 0; i < componentsCount; ++i) {
                    Rectangle r = (Rectangle)res.get(i);
                    r.setBounds(insets2.left + offset, insets2.top + (height - maxHeight) / 2, maxWidth, maxHeight);
                    offset += maxWidth;
                }
            } else {
                for (i = 0; i < componentsCount; ++i) {
                    Rectangle r = (Rectangle)res.get(i);
                    r.setBounds(insets2.left + (width - maxWidth) / 2, insets2.top + offset, maxWidth, maxHeight);
                    offset += maxHeight;
                }
            }
        } else if (orientation == 0) {
            int maxHeight = ToolbarLayoutUtilKt.maxComponentPreferredHeight(toolbarComponent);
            offset = 0;
            for (i = 0; i < componentsCount; ++i) {
                Dimension d = ToolbarLayoutUtilKt.getChildPreferredSize(toolbarComponent, i);
                Rectangle r = (Rectangle)res.get(i);
                r.setBounds(insets2.left + offset, insets2.top + (maxHeight - d.height) / 2, d.width, d.height);
                offset += d.width;
            }
        } else {
            int maxWidth = ToolbarLayoutUtilKt.maxComponentPreferredWidth(toolbarComponent);
            offset = 0;
            for (i = 0; i < componentsCount; ++i) {
                Dimension d = ToolbarLayoutUtilKt.getChildPreferredSize(toolbarComponent, i);
                Rectangle r = (Rectangle)res.get(i);
                r.setBounds(insets2.left + (maxWidth - d.width) / 2, insets2.top + offset, d.width, d.height);
                offset += d.height;
            }
        }
        return res;
    }

    @Override
    @NotNull
    public List<Rectangle> calculateBounds(@NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        return this.doCalculateBounds(toolbar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension calcPreferredSize(@NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        List<Rectangle> bounds = this.doCalculateBounds(toolbar);
        if (bounds.isEmpty()) {
            JBDimension jBDimension = JBUI.emptySize();
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
            return (Dimension)jBDimension;
        }
        Iterable $this$reduce$iv = bounds;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void rect;
            Rectangle rectangle = (Rectangle)iterator$iv.next();
            Rectangle acc = (Rectangle)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.union((Rectangle)rect), (String)"union(...)");
        }
        Dimension dimension = ((Rectangle)accumulator$iv).getSize();
        JBInsets.addTo((Dimension)dimension, (Insets)toolbar.getComponent().getInsets());
        Intrinsics.checkNotNull((Object)dimension);
        return dimension;
    }

    @Override
    @NotNull
    public Dimension calcMinimumSize(@NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        JBDimension jBDimension = JBUI.emptySize();
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
        return (Dimension)jBDimension;
    }
}

