/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend.model;

import com.intellij.icons.AllIcons;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.platform.recentFiles.frontend.FrontendRecentFilesRequestFactoryKt;
import com.intellij.platform.recentFiles.frontend.RecentFilesExcluder;
import com.intellij.platform.recentFiles.frontend.SwitcherVirtualFile;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesModel;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesModelKt;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesMutableState;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesMutableStateKt;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import com.intellij.platform.recentFiles.shared.FileSwitcherApi;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import com.intellij.platform.recentFiles.shared.RecentFilesBackendRequest;
import com.intellij.platform.recentFiles.shared.RecentFilesCoroutineScopeProvider;
import com.intellij.platform.recentFiles.shared.RecentFilesEvent;
import com.intellij.platform.recentFiles.shared.RecentFilesState;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modelUpdateScope", "Lkotlinx/coroutines/CoroutineScope;", "modelState", "Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesMutableState;", "getRecentFiles", "", "Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "fileKind", "Lcom/intellij/platform/recentFiles/shared/RecentFileKind;", "filterOutExcludedFiles", "capturedModelState", "considerOpenedEditorWindowsForFiles", "filteredModel", "applyFrontendChanges", "", "filesKind", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "changeKind", "Lcom/intellij/platform/recentFiles/shared/FileChangeKind;", "fetchInitialData", "targetFilesKind", "(Lcom/intellij/platform/recentFiles/shared/RecentFileKind;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribeToBackendRecentFilesUpdates", "(Lcom/intellij/platform/recentFiles/shared/RecentFileKind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyChangesToModel", "event", "Lcom/intellij/platform/recentFiles/shared/RecentFilesEvent;", "(Lcom/intellij/platform/recentFiles/shared/RecentFilesEvent;Lcom/intellij/platform/recentFiles/shared/RecentFileKind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertDtoToModel", "rpcDto", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto;", "convertVirtualFileIdToModel", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "Companion", "intellij.platform.recentFiles.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFrontendRecentFilesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendRecentFilesModel.kt\ncom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n777#2:164\n873#2,2:165\n1525#2:171\n1557#2,3:172\n1560#2,3:182\n1586#2:189\n1661#2,3:190\n1586#2:193\n1661#2,3:194\n1642#2,10:197\n1915#2:207\n1916#2:209\n1652#2:210\n67#3,4:167\n67#3,4:185\n383#4,7:175\n1#5:208\n*S KotlinDebug\n*F\n+ 1 FrontendRecentFilesModel.kt\ncom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel\n*L\n46#1:164\n46#1:165,2\n69#1:171\n69#1:172,3\n69#1:182,3\n136#1:189\n136#1:190,3\n137#1:193\n137#1:194,3\n138#1:197,10\n138#1:207\n138#1:209\n138#1:210\n56#1:167,4\n88#1:185,4\n69#1:175,7\n138#1:208\n*E\n"})
public final class FrontendRecentFilesModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope modelUpdateScope;
    @NotNull
    private final FrontendRecentFilesMutableState modelState;

    public FrontendRecentFilesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelUpdateScope = CoroutineScopeKt.childScope$default((CoroutineScope)RecentFilesCoroutineScopeProvider.Companion.getInstance(this.project).getCoroutineScope(), (String)"RecentFilesModel updates", null, (boolean)false, (int)6, null);
        this.modelState = new FrontendRecentFilesMutableState(this.project);
    }

    @NotNull
    public final List<SwitcherVirtualFile> getRecentFiles(@NotNull RecentFileKind fileKind) {
        Intrinsics.checkNotNullParameter((Object)fileKind, (String)"fileKind");
        List capturedModelState = ((RecentFilesState)this.modelState.chooseStateToReadFrom(fileKind).getValue()).getEntries();
        List<SwitcherVirtualFile> filteredModel = this.filterOutExcludedFiles(capturedModelState, fileKind);
        return WhenMappings.$EnumSwitchMapping$0[fileKind.ordinal()] == 1 ? this.considerOpenedEditorWindowsForFiles(filteredModel) : filteredModel;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SwitcherVirtualFile> filterOutExcludedFiles(List<SwitcherVirtualFile> capturedModelState, RecentFileKind fileKind) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = capturedModelState;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile file;
            RecentFilesExcluder excluder;
            SwitcherVirtualFile fileModel = (SwitcherVirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(fileModel.getVirtualFile() == null ? true : (excluder = (RecentFilesExcluder)RecentFilesExcluder.EP_NAME.findFirstSafe(arg_0 -> FrontendRecentFilesModel.filterOutExcludedFiles$lambda$0$1(arg_0 -> FrontendRecentFilesModel.filterOutExcludedFiles$lambda$0$0(fileKind, this, file, arg_0), arg_0))) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredModel = (List)destination$iv$iv;
        Logger $this$trace$iv = FrontendRecentFilesModelKt.access$getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            String modelData = filteredModel.size() != capturedModelState.size() ? "After filtering: " + CollectionsKt.joinToString$default((Iterable)filteredModel, null, null, null, (int)0, null, FrontendRecentFilesModel::filterOutExcludedFiles$lambda$1$0, (int)31, null) : "";
            logger.trace("Return requested " + fileKind + " list: " + CollectionsKt.joinToString$default((Iterable)capturedModelState, null, null, null, (int)0, null, FrontendRecentFilesModel::filterOutExcludedFiles$lambda$1$1, (int)31, null) + " " + modelData);
        }
        return filteredModel;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SwitcherVirtualFile> considerOpenedEditorWindowsForFiles(List<SwitcherVirtualFile> filteredModel) {
        void $this$groupByTo$iv$iv;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        FileEditorManagerImpl fileEditorManagerImpl = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
        Collection collection = fileEditorManagerImpl != null ? fileEditorManagerImpl.getSelectionHistoryList() : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable $this$groupBy$iv = collection;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            VirtualFile file;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            VirtualFile key$iv$iv = file = (VirtualFile)pair.component1();
            Map map = destination$iv$iv;
            VirtualFile key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair pair2 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            EditorWindow editor = (EditorWindow)pair2.component2();
            list.add(editor);
        }
        Map editorsByFile = destination$iv$iv;
        return SequencesKt.toList((Sequence)SequencesKt.flatten((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)filteredModel)), arg_0 -> FrontendRecentFilesModel.considerOpenedEditorWindowsForFiles$lambda$2(editorsByFile, arg_0))));
    }

    public final void applyFrontendChanges(@NotNull RecentFileKind filesKind, @NotNull List<? extends VirtualFile> files, @NotNull FileChangeKind changeKind) {
        Intrinsics.checkNotNullParameter((Object)filesKind, (String)"filesKind");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changeKind, (String)"changeKind");
        if (files.isEmpty()) {
            return;
        }
        Logger $this$trace$iv = FrontendRecentFilesModelKt.access$getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying frontend changes for kind: " + filesKind + ", changeKind: " + changeKind + ", files: " + CollectionsKt.joinToString$default((Iterable)files, null, null, null, (int)0, null, FrontendRecentFilesModel::applyFrontendChanges$lambda$0$0, (int)31, null));
        }
        BuildersKt.launch$default((CoroutineScope)this.modelUpdateScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, filesKind, files, changeKind, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int I$2;
            int label;
            final /* synthetic */ FrontendRecentFilesModel this$0;
            final /* synthetic */ RecentFileKind $filesKind;
            final /* synthetic */ List<VirtualFile> $files;
            final /* synthetic */ FileChangeKind $changeKind;
            {
                this.this$0 = $receiver;
                this.$filesKind = $filesKind;
                this.$files = $files;
                this.$changeKind = $changeKind;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block23: {
                    var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            frontendStateToUpdate = FrontendRecentFilesModel.access$getModelState$p(this.this$0).chooseStateToWriteTo(this.$filesKind);
                            var4_6 = this.$files;
                            var5_7 = this.this$0;
                            $i$f$map = 0;
                            var7_9 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = 0;
                            var10_12 = $this$mapTo$iv$iv.iterator();
lbl13:
                            // 2 sources

                            while (var10_12.hasNext()) {
                                item$iv$iv = var10_12.next();
                                var12_15 = (VirtualFile)item$iv$iv;
                                var23_21 = destination$iv$iv;
                                $i$a$-map-FrontendRecentFilesModel$applyFrontendChanges$2$fileModels$1 = 0;
                                this.L$0 = frontendStateToUpdate;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                                this.L$2 = var5_7;
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                                this.L$4 = destination$iv$iv;
                                this.L$5 = var10_12;
                                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)item$iv$iv);
                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.L$8 = var23_21;
                                this.I$0 = $i$f$map;
                                this.I$1 = $i$f$mapTo;
                                this.I$2 = $i$a$-map-FrontendRecentFilesModel$applyFrontendChanges$2$fileModels$1;
                                this.label = 1;
                                v0 = FrontendRecentFilesMutableStateKt.convertVirtualFileToViewModel(it, FrontendRecentFilesModel.access$getProject$p(var5_7), (Continuation<? super SwitcherVirtualFile>)this);
                                if (v0 == var24_2) {
                                    return var24_2;
                                }
                                ** GOTO lbl51
                            }
                            break;
                        }
                        case 1: {
                            $i$a$-map-FrontendRecentFilesModel$applyFrontendChanges$2$fileModels$1 = this.I$2;
                            $i$f$mapTo = this.I$1;
                            $i$f$map = this.I$0;
                            var23_21 = (Collection)this.L$8;
                            it = (VirtualFile)this.L$7;
                            item$iv$iv = this.L$6;
                            var10_12 = (Iterator<T>)this.L$5;
                            destination$iv$iv = (Collection)this.L$4;
                            $this$mapTo$iv$iv = (Iterable)this.L$3;
                            var5_7 = (FrontendRecentFilesModel)this.L$2;
                            $this$map$iv = (Iterable)this.L$1;
                            frontendStateToUpdate = (MutableStateFlow)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl51:
                            // 2 sources

                            var23_21.add((SwitcherVirtualFile)v0);
                            ** GOTO lbl13
                        }
                    }
                    fileModels = (List)destination$iv$iv;
                    $this$map$iv = frontendStateToUpdate;
                    var5_7 = this.$changeKind;
                    $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        oldList = (RecentFilesState)prevValue$iv;
                        $i$a$-update-FrontendRecentFilesModel$applyFrontendChanges$2$1 = false;
                        switch (applyFrontendChanges.WhenMappings.$EnumSwitchMapping$0[var5_7.ordinal()]) {
                            case 1: {
                                $this$associateBy$iv = oldList.getEntries();
                                $i$f$associateBy = false;
                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                                $i$a$-map-FrontendRecentFilesModel$applyFrontendChanges$2$fileModels$1 = $this$associateBy$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                $i$f$associateByTo = false;
                                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                                    var18_29 = (SwitcherVirtualFile)element$iv$iv;
                                    var19_30 = destination$iv$iv;
                                    $i$a$-associateBy-FrontendRecentFilesModel$applyFrontendChanges$2$1$maybeItemsWithRichMetadata$1 = false;
                                    var19_30.put(it, element$iv$iv);
                                }
                                maybeItemsWithRichMetadata = destination$iv$iv;
                                $this$map$iv = fileModels;
                                $i$f$map = false;
                                $this$associateByTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (SwitcherVirtualFile)item$iv$iv;
                                    var19_30 = destination$iv$iv;
                                    $i$a$-map-FrontendRecentFilesModel$applyFrontendChanges$2$1$effectiveModelsToInsert$1 = false;
                                    v1 = (SwitcherVirtualFile)maybeItemsWithRichMetadata.get(fileModel);
                                    if (v1 == null) {
                                        v1 = fileModel;
                                    }
                                    var19_30.add(v1);
                                }
                                effectiveModelsToInsert = (List)destination$iv$iv;
                                v2 = new RecentFilesState(CollectionsKt.plus((Collection)effectiveModelsToInsert, (Iterable)CollectionsKt.minus((Iterable)oldList.getEntries(), (Iterable)CollectionsKt.toSet((Iterable)effectiveModelsToInsert))));
                                break;
                            }
                            case 2: {
                                v2 = new RecentFilesState(CollectionsKt.minus((Iterable)oldList.getEntries(), (Iterable)CollectionsKt.toSet((Iterable)fileModels)));
                                break;
                            }
                            case 3: {
                                v2 = new RecentFilesState(CollectionsKt.minus((Iterable)CollectionsKt.plus((Collection)fileModels, (Iterable)oldList.getEntries()), (Iterable)CollectionsKt.toSet((Iterable)fileModels)));
                                break;
                            }
                            default: {
                                v2 = oldList;
                            }
                        }
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = v2)));
                    if (applyFrontendChanges.WhenMappings.$EnumSwitchMapping$0[this.$changeKind.ordinal()] != 2) break block23;
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)frontendStateToUpdate);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileModels);
                    this.L$2 = null;
                    this.L$3 = null;
                    this.L$4 = null;
                    this.L$5 = null;
                    this.L$6 = null;
                    this.L$7 = null;
                    this.L$8 = null;
                    this.label = 2;
                    v3 = FileSwitcherApi.Companion.getInstance((Continuation)this);
                    if (v3 == var24_2) {
                        return var24_2;
                    }
                    ** GOTO lbl128
                    {
                        case 2: {
                            fileModels = (List)this.L$1;
                            frontendStateToUpdate = (MutableStateFlow)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl128:
                            // 2 sources

                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)frontendStateToUpdate);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileModels);
                            this.label = 3;
                            v4 = ((FileSwitcherApi)v3).updateRecentFilesBackendState((RecentFilesBackendRequest)FrontendRecentFilesRequestFactoryKt.createHideFilesRequest(this.$filesKind, this.$files, FrontendRecentFilesModel.access$getProject$p(this.this$0)), (Continuation)this);
                            if (v4 == var24_2) {
                                return var24_2;
                            }
                            ** GOTO lbl140
                        }
                        case 3: {
                            fileModels = (List)this.L$1;
                            frontendStateToUpdate = (MutableStateFlow)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl140:
                            // 2 sources

                            v5 = (Boolean)v4;
                            ** GOTO lbl175
                        }
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)frontendStateToUpdate);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileModels);
                this.L$2 = null;
                this.L$3 = null;
                this.L$4 = null;
                this.L$5 = null;
                this.L$6 = null;
                this.L$7 = null;
                this.L$8 = null;
                this.label = 4;
                v6 = FileSwitcherApi.Companion.getInstance((Continuation)this);
                if (v6 == var24_2) {
                    return var24_2;
                }
                ** GOTO lbl162
                {
                    case 4: {
                        fileModels = (List)this.L$1;
                        frontendStateToUpdate = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl162:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)frontendStateToUpdate);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileModels);
                        this.label = 5;
                        v7 = ((FileSwitcherApi)v6).updateRecentFilesBackendState((RecentFilesBackendRequest)FrontendRecentFilesRequestFactoryKt.createFilesUpdateRequest(this.$filesKind, this.$files, true, FrontendRecentFilesModel.access$getProject$p(this.this$0)), (Continuation)this);
                        if (v7 == var24_2) {
                            return var24_2;
                        }
                        ** GOTO lbl174
                    }
                    case 5: {
                        fileModels = (List)this.L$1;
                        frontendStateToUpdate = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl174:
                        // 2 sources

                        v5 = (Boolean)v7;
lbl175:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetchInitialData(@NotNull RecentFileKind targetFilesKind, @NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof fetchInitialData.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendRecentFilesModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetchInitialData(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = targetFilesKind;
                $continuation.L$1 = project;
                $continuation.label = 1;
                v0 = FileSwitcherApi.Companion.getInstance((Continuation)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                project = (Project)$continuation.L$1;
                targetFilesKind = (RecentFileKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)targetFilesKind);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.label = 2;
                v1 = ((FileSwitcherApi)v0).updateRecentFilesBackendState((RecentFilesBackendRequest)FrontendRecentFilesRequestFactoryKt.createFilesSearchRequestRequest(targetFilesKind, project), (Continuation)$continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl36
            }
            case 2: {
                project = (Project)$continuation.L$1;
                targetFilesKind = (RecentFileKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object subscribeToBackendRecentFilesUpdates(@NotNull RecentFileKind targetFilesKind, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof subscribeToBackendRecentFilesUpdates.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendRecentFilesModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.subscribeToBackendRecentFilesUpdates(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                FrontendRecentFilesModelKt.access$getLOG().debug("Started collecting recent files updates for kind: " + targetFilesKind);
                $continuation.L$0 = targetFilesKind;
                $continuation.label = 1;
                v0 = FileSwitcherApi.Companion.getInstance((Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                targetFilesKind = (RecentFileKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                $continuation.L$0 = targetFilesKind;
                $continuation.label = 2;
                v1 = ((FileSwitcherApi)v0).getRecentFileEvents(targetFilesKind, ProjectIdKt.projectId((Project)this.project), (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                targetFilesKind = (RecentFileKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)targetFilesKind);
                $continuation.label = 3;
                v2 = ((Flow)v1).collect(new FlowCollector(this, targetFilesKind){
                    final /* synthetic */ FrontendRecentFilesModel this$0;
                    final /* synthetic */ RecentFileKind $targetFilesKind;
                    {
                        this.this$0 = $receiver;
                        this.$targetFilesKind = $targetFilesKind;
                    }

                    public final Object emit(RecentFilesEvent update, Continuation<? super Unit> $completion) {
                        Object object = FrontendRecentFilesModel.access$applyChangesToModel(this.this$0, update, this.$targetFilesKind, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl43
            }
            case 3: {
                targetFilesKind = (RecentFileKind)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final Object applyChangesToModel(RecentFilesEvent event, RecentFileKind targetFilesKind, Continuation<? super Unit> $completion) {
        RecentFilesEvent recentFilesEvent = event;
        if (recentFilesEvent instanceof RecentFilesEvent.ItemsAdded) {
            Collection<SwitcherVirtualFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((RecentFilesEvent.ItemsAdded)event).getBatch();
            RecentFileKind recentFileKind = targetFilesKind;
            FrontendRecentFilesMutableState frontendRecentFilesMutableState = this.modelState;
            boolean $i$f$map = false;
            void var7_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwitcherRpcDto switcherRpcDto = (SwitcherRpcDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertDtoToModel((SwitcherRpcDto)it));
            }
            collection = (List)destination$iv$iv;
            frontendRecentFilesMutableState.addEvent(recentFileKind, (List)collection);
        } else if (recentFilesEvent instanceof RecentFilesEvent.ItemsUpdated) {
            Collection<SwitcherVirtualFile> collection;
            Iterable $this$map$iv = ((RecentFilesEvent.ItemsUpdated)event).getBatch();
            RecentFileKind recentFileKind = targetFilesKind;
            FrontendRecentFilesMutableState frontendRecentFilesMutableState = this.modelState;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SwitcherRpcDto it = (SwitcherRpcDto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertDtoToModel(it));
            }
            collection = (List)destination$iv$iv;
            frontendRecentFilesMutableState.updateEvent(recentFileKind, (List)collection, ((RecentFilesEvent.ItemsUpdated)event).getPutOnTop());
        } else if (recentFilesEvent instanceof RecentFilesEvent.ItemsRemoved) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $this$map$iv = ((RecentFilesEvent.ItemsRemoved)event).getBatch();
            RecentFileKind recentFileKind = targetFilesKind;
            FrontendRecentFilesMutableState frontendRecentFilesMutableState = this.modelState;
            boolean $i$f$mapNotNull = false;
            void $this$mapTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SwitcherVirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFileId it = (VirtualFileId)element$iv$iv;
                boolean bl2 = false;
                if (this.convertVirtualFileIdToModel(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            frontendRecentFilesMutableState.removeEvent(recentFileKind, list);
        } else if (recentFilesEvent instanceof RecentFilesEvent.AllItemsRemoved) {
            this.modelState.removeAllEvent(targetFilesKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private final SwitcherVirtualFile convertDtoToModel(SwitcherRpcDto rpcDto) {
        if (!(rpcDto instanceof SwitcherRpcDto.File)) {
            throw new NoWhenBranchMatchedException();
        }
        return new SwitcherVirtualFile((SwitcherRpcDto.File)rpcDto);
    }

    private final SwitcherVirtualFile convertVirtualFileIdToModel(VirtualFileId virtualFileId) {
        VirtualFile virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)virtualFileId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile localFile = virtualFile;
        Icon icon = AllIcons.FileTypes.Unknown;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Unknown");
        return new SwitcherVirtualFile(localFile, "deleted file", icon);
    }

    private static final boolean filterOutExcludedFiles$lambda$0$0(RecentFileKind $fileKind, FrontendRecentFilesModel this$0, VirtualFile $file, RecentFilesExcluder ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return switch (WhenMappings.$EnumSwitchMapping$0[$fileKind.ordinal()]) {
            case 2 -> ext.isExcludedFromRecentlyEdited(this$0.project, $file);
            case 1, 3 -> ext.isExcludedFromRecentlyOpened(this$0.project, $file);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean filterOutExcludedFiles$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence filterOutExcludedFiles$lambda$1$0(SwitcherVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getVirtualFile();
        return object != null && (object = object.getName()) != null ? (CharSequence)object : (CharSequence)"null";
    }

    private static final CharSequence filterOutExcludedFiles$lambda$1$1(SwitcherVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getVirtualFile();
        return object != null && (object = object.getName()) != null ? (CharSequence)object : (CharSequence)"null";
    }

    private static final SwitcherVirtualFile considerOpenedEditorWindowsForFiles$lambda$2$0(SwitcherVirtualFile $fileModel, EditorWindow editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return $fileModel.withAssociatedEditorWindow(editor);
    }

    private static final Sequence considerOpenedEditorWindowsForFiles$lambda$2(Map $editorsByFile, SwitcherVirtualFile fileModel) {
        Intrinsics.checkNotNullParameter((Object)fileModel, (String)"fileModel");
        List editorsForSpecificFile = (List)$editorsByFile.get(fileModel.getVirtualFile());
        Collection collection = editorsForSpecificFile;
        if (collection == null || collection.isEmpty()) {
            return SequencesKt.sequenceOf((Object)fileModel);
        }
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)editorsForSpecificFile), arg_0 -> FrontendRecentFilesModel.considerOpenedEditorWindowsForFiles$lambda$2$0(fileModel, arg_0));
    }

    private static final CharSequence applyFrontendChanges$lambda$0$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static final /* synthetic */ FrontendRecentFilesMutableState access$getModelState$p(FrontendRecentFilesModel $this) {
        return $this.modelState;
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendRecentFilesModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$applyChangesToModel(FrontendRecentFilesModel $this, RecentFilesEvent event, RecentFileKind targetFilesKind, Continuation $completion) {
        return $this.applyChangesToModel(event, targetFilesKind, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.recentFiles.frontend"})
    @SourceDebugExtension(value={"SMAP\nFrontendRecentFilesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendRecentFilesModel.kt\ncom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,163:1\n30#2,2:164\n75#2:166\n*S KotlinDebug\n*F\n+ 1 FrontendRecentFilesModel.kt\ncom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesModel$Companion\n*L\n156#1:164,2\n160#1:166\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendRecentFilesModel getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FrontendRecentFilesModel> serviceClass$iv = FrontendRecentFilesModel.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendRecentFilesModel)object;
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super FrontendRecentFilesModel> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(FrontendRecentFilesModel.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecentFileKind.values().length];
            try {
                nArray[RecentFileKind.RECENTLY_OPENED_UNPINNED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_EDITED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

