/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.frontend;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.python.frontend.PyAstFileImpl;
import com.intellij.python.frontend.PyFrontendFileElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/frontend/PyFrontendParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getWhitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createParser", "Lcom/intellij/lang/PsiParser;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "intellij.python.frontend"})
public class PyFrontendParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Lexer)new PythonIndentingLexer();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return PyFrontendFileElementType.INSTANCE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{PyTokenTypes.LINE_BREAK, PyTokenTypes.SPACE, PyTokenTypes.TAB, PyTokenTypes.FORMFEED};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{PyTokenTypes.END_OF_LINE_COMMENT};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet[] tokenSetArray = new TokenSet[]{PyTokenTypes.STRING_NODES, PyTokenTypes.FSTRING_TOKENS};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (PsiParser)new PyParser();
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (type instanceof PyElementType) {
            PsiElement psiElement = ((PyElementType)type).createElement(node);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
            return psiElement;
        }
        return (PsiElement)new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        PythonLanguage pythonLanguage = PythonLanguage.INSTANCE;
        return (PsiFile)new PyAstFileImpl(viewProvider, pythonLanguage){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($viewProvider, (Language)$super_call_param$1);
            }

            public FileType getFileType() {
                PythonFileType pythonFileType = PythonFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)pythonFileType, (String)"INSTANCE");
                return (FileType)pythonFileType;
            }

            public LanguageLevel getLanguageLevel() {
                LanguageLevel languageLevel = LanguageLevel.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getDefault(...)");
                return languageLevel;
            }
        };
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

