/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateOperationType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateType;
import com.intellij.database.explorer.structure.DvViewOptions;
import com.intellij.database.explorer.structure.DvViewOptionsFun;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u0010\u0016\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00102\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u000209H\u0002\u00a8\u0006:"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "options", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "content", "describeMsSequence", "sequence", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "describeMsAliasType", "type", "Lcom/intellij/database/dialects/mssql/model/MsAliasType;", "describeMsTableType", "Lcom/intellij/database/dialects/mssql/model/MsTableType;", "describeMsTable", "table", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "describeMsLikeIndex", "index", "Lcom/intellij/database/dialects/mssql/model/MsLikeIndex;", "describeMsDefaultConstraint", "def", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "describeMsStoredColumn", "col", "Lcom/intellij/database/dialects/mssql/model/MsStoredColumn;", "describeMsTrigger", "trigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "describeMsRoutine", "routine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "describeMsRole", "role", "Lcom/intellij/database/dialects/mssql/model/MsRole;", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/explorer/structure/DvViewOptions;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeMsSecurityPredicate", "predicate", "Lcom/intellij/database/dialects/mssql/model/MsSecurityPredicate;", "describeMsDatabase", "database", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "describeExtProps", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDescriptionService.kt\ncom/intellij/database/dialects/mssql/model/MsDescriptionService\n+ 2 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n75#2:188\n75#2:189\n75#2:190\n1#3:191\n*S KotlinDebug\n*F\n+ 1 MsDescriptionService.kt\ncom/intellij/database/dialects/mssql/model/MsDescriptionService\n*L\n50#1:188\n57#1:189\n62#1:190\n*E\n"})
public final class MsDescriptionService
extends DescriptionService {
    @NotNull
    public String options(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(MsSourceAware.ENCRYPTED);
        ((Collection)context.getDescribed()).add(MsTableColumn.HIDDEN);
        return super.options(e, context) + (e instanceof MsSourceAware && ((MsSourceAware)e).isEncrypted() ? " [encrypted]" : "") + (e instanceof MsTableColumn && ((MsTableColumn)e).isHidden() ? " [hidden]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return (basicElement instanceof MsSequence ? this.describeMsSequence((MsSequence)e, context) : (basicElement instanceof MsAliasType ? this.describeMsAliasType((MsAliasType)e, context) : (basicElement instanceof MsTableType ? this.describeMsTableType((MsTableType)e, context) : (basicElement instanceof MsTable ? this.describeMsTable((MsTable)e, context) : (basicElement instanceof MsStoredColumn ? this.describeMsStoredColumn((MsStoredColumn)e, context) : (basicElement instanceof MsDefaultConstraint ? this.describeMsDefaultConstraint((MsDefaultConstraint)e, context) : (basicElement instanceof MsLikeIndex ? this.describeMsLikeIndex((MsLikeIndex)e, context) : (basicElement instanceof MsTrigger ? this.describeMsTrigger((MsTrigger)e, context) : (basicElement instanceof MsRoutine ? this.describeMsRoutine((MsRoutine)e, context) : (basicElement instanceof MsRole ? this.describeMsRole((MsRole)e, context) : super.content(e, context))))))))))) + (e instanceof MsExtendedPropertiesHolder ? this.describeExtProps((MsExtendedPropertiesHolder)e) : "");
    }

    private final String describeMsSequence(MsSequence sequence, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsSequence.CYCLED);
        ((Collection)context.getDescribed()).add(MsSequence.CACHE_SIZE);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsSequence.STORED_TYPE);
        }
        return super.content((BasicElement)sequence, context);
    }

    private final String describeMsAliasType(MsAliasType type, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsAliasType.STORED_TYPE);
        ((Collection)context.getDescribed()).add(MsAliasType.NOT_NULL);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsAliasType.TYPE_ID);
        }
        return type.getDasType().getSpecification() + (type.isNotNull() ? " NN" : "");
    }

    private final String describeMsTableType(MsTableType type, DescriptionService.Context context) {
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsTableType.TYPE_ID);
        }
        return super.content((BasicElement)type, context);
    }

    private final String describeMsTable(MsTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTable.EXTENDED_PROPERTIES);
        return super.content((BasicElement)table, context);
    }

    private final String describeMsLikeIndex(MsLikeIndex index, DescriptionService.Context context) {
        String condition;
        ((Collection)context.getDescribed()).add(MsLikeIndex.CLUSTERING);
        ((Collection)context.getDescribed()).add(MsLikeIndex.FULLTEXT);
        ((Collection)context.getDescribed()).add(MsLikeIndex.CONDITION);
        ((Collection)context.getDescribed()).add(MsLikeIndex.UNIQUE);
        ((Collection)context.getDescribed()).add(MsLikeIndex.COLUMNSTORE);
        ((Collection)context.getDescribed()).add(MsLikeIndex.INCLUDED_COL_NAMES);
        ((Collection)context.getDescribed()).add(MsLikeIndex.COL_NAMES);
        ((Collection)context.getDescribed()).add(MsLikeIndex.REVERSE_COL_NAMES);
        String prefix = index.isClustering() ? "clustered " : (index.isFulltext() ? "fulltext " : "");
        Object d = index.isUnique() ? "unique" : "index";
        String inner = this.describeIndexingItems((BasicIndex)index);
        if (inner != null) {
            d = (String)d + " (" + inner + ")";
        }
        List<String> list = index.getIncludedColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIncludedColNames(...)");
        if (!((Collection)list).isEmpty()) {
            List<String> list2 = index.getIncludedColNames();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getIncludedColNames(...)");
            d = (String)d + " include (" + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
        }
        if ((condition = index.getCondition()) != null) {
            d = (String)d + " when " + condition;
        }
        return prefix + (String)d;
    }

    private final String describeMsDefaultConstraint(MsDefaultConstraint def, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsDefaultConstraint.COL_NAMES);
        ((Collection)context.getDescribed()).add(MsDefaultConstraint.DEFAULT_EXPRESSION);
        String string = StringUtil.join((Collection)def.getColNames(), (String)",");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String columnName = string;
        String string2 = def.getDefaultExpression();
        if (string2 == null) {
            string2 = "???";
        }
        String defaultExpression = string2;
        return columnName + " = " + defaultExpression;
    }

    private final String describeMsStoredColumn(MsStoredColumn col, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTableColumn.SPARSE);
        ((Collection)context.getDescribed()).add(MsTableColumn.COLUMN_SET);
        ((Collection)context.getDescribed()).add(MsTableColumn.DEFAULT_CONSTRAINT_REF);
        String s = super.content((BasicElement)col, context);
        return col instanceof MsTableColumn && ((MsTableColumn)col).isSparse() ? s + " sparse" : (col instanceof MsTableColumn && ((MsTableColumn)col).isColumnSet() ? s + " column_set for all_sparse_columns" : s);
    }

    private final String describeMsTrigger(MsTrigger trigger, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTrigger.DISABLED);
        ((Collection)context.getDescribed()).add(MsTrigger.NOT_FOR_REPLICATION);
        return super.content((BasicElement)trigger, context);
    }

    private final String describeMsRoutine(MsRoutine routine, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsRoutine.ROUTINE_TYPE);
        return super.content((BasicElement)routine, context);
    }

    private final String describeMsRole(MsRole role, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsRole.OWNER_REF);
        ((Collection)context.getDescribed()).add(MsRole.TYPE);
        ((Collection)context.getDescribed()).add(MsRole.AUTH_TYPE);
        return super.content((BasicElement)role, context);
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof MsLikeIndex) {
            this.describeMsLikeIndex(presentation, (MsLikeIndex)o, viewOptions);
        } else if (dasObject instanceof MsSecurityPredicate) {
            this.describeMsSecurityPredicate(presentation, (MsSecurityPredicate)o);
        } else if (dasObject instanceof MsDatabase) {
            this.describeMsDatabase(presentation, (MsDatabase)o);
        } else {
            super.updatePresentation(project, o, viewOptions, presentation);
        }
    }

    private final void describeMsLikeIndex(PresentationData presentation, MsLikeIndex index, DvViewOptions viewOptions) {
        String indexingItems;
        Object text = " ";
        if (DvViewOptionsFun.getUnnestTableSubObjectsAndGroupSchemaObjects((DvViewOptions)viewOptions)) {
            MsLikeTable msLikeTable = index.getLikeTable();
            String tableName = StringKt.nullize((String)(msLikeTable != null ? msLikeTable.getName() : null), (boolean)true);
            if (tableName != null) {
                text = (String)text + "on " + tableName + " ";
            }
        }
        if ((indexingItems = this.describeIndexingItems((BasicIndex)index)) != null) {
            text = (String)text + "(" + indexingItems + ")";
        }
        String unique = index.isUnique() ? " UNIQUE" : "";
        text = (String)text + unique;
        List<String> list = index.getIncludedColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIncludedColNames(...)");
        List<String> includingColNames = list;
        if (!((Collection)includingColNames).isEmpty()) {
            String string = StringUtil.join((Collection)includingColNames, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String icn = string;
            text = (String)text + " include (" + icn + ")";
        }
        presentation.addText((String)text, DbPresentationCore.INFO_ATTRS);
        String condition = index.getCondition();
        if (condition != null) {
            String conditionClause = " where " + condition;
            presentation.addText(conditionClause, DbPresentationCore.INFO_ATTRS);
        }
    }

    private final void describeMsSecurityPredicate(PresentationData presentation, MsSecurityPredicate predicate) {
        String string;
        Enum it;
        StringBuilder stringBuilder;
        StringBuilder $this$describeMsSecurityPredicate_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        MsSecurityPredicateType msSecurityPredicateType = predicate.getPredicateType();
        if (msSecurityPredicateType != null) {
            it = msSecurityPredicateType;
            boolean bl2 = false;
            string = it.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$describeMsSecurityPredicate_u24lambda_u240.append(string2).append(" ");
        }
        MsSecurityPredicateOperationType msSecurityPredicateOperationType = predicate.getOperationType();
        if (msSecurityPredicateOperationType != null) {
            it = msSecurityPredicateOperationType;
            boolean bl3 = false;
            StringBuilder stringBuilder2 = $this$describeMsSecurityPredicate_u24lambda_u240.append(" ");
            string = it.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            stringBuilder2.append(StringsKt.replace$default((String)string3, (char)'_', (char)' ', (boolean)false, (int)4, null));
        }
        String text = stringBuilder.toString();
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    private final void describeMsDatabase(PresentationData presentation, MsDatabase database) {
        if (!database.isOnline()) {
            Icon icon = DatabaseIcons.Database;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Database");
            presentation.setIcon(IconLoader.getDisabledIcon((Icon)icon));
        }
    }

    private final String describeExtProps(MsExtendedPropertiesHolder e) {
        Object object;
        if (e.getExtendedProperties().isEmpty()) {
            object = "";
        } else {
            List<NameValueType> list = e.getExtendedProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExtendedProperties(...)");
            object = " [" + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, MsDescriptionService::describeExtProps$lambda$0, (int)31, null) + "]";
        }
        return object;
    }

    private static final CharSequence describeExtProps$lambda$0(NameValueType it) {
        return it.getName() + ":" + it.getType() + "=" + it.getValue();
    }
}

