/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.users;

import com.intellij.cwm.frontend.notifications.GuestNotifications;
import com.intellij.cwm.frontend.users.ControllerUserActionsKt;
import com.intellij.cwm.plugin.common.users.ConnectableUser;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.cwm.plugin.common.users.UserNotifications;
import com.intellij.cwm.plugin.common.users.UserRequestFollowingCookie;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.RdUserFollowingRequest;
import com.jetbrains.codeWithMe.model.RdUserFollowingRetarget;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.codeWithMe.model.RemoteControlSession;
import com.jetbrains.codeWithMe.model.UserModel;
import com.jetbrains.rd.platform.RdConstants;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.thinclient.unattendedHost.ThinClientUnattendedHostControlHost;
import com.jetbrains.thinclient.unattendedHost.UnattendedHostSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/intellij/cwm/frontend/users/ThinClientUserManager;", "Lcom/intellij/cwm/plugin/common/users/UserManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/jetbrains/codeWithMe/model/UserModel;", "cwmActionsAllowed", "", "getCwmActionsAllowed", "()Z", "bindWithModel", "", "userModel", "bindWithModel$intellij_cwm_frontend", "sanitizeUser", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "user", "jumpTo", "startFollowing", "stopFollowing", "requestFollowing", "force", "requestStopFollowing", "getUserById", "id", "Lcom/jetbrains/codeWithMe/model/RdUserId;", "getUserProperties", "Lcom/jetbrains/codeWithMe/model/RdUserProperties;", "createUserActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "intellij.cwm.frontend"})
@SourceDebugExtension(value={"SMAP\nThinClientUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientUserManager.kt\ncom/intellij/cwm/frontend/users/ThinClientUserManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n60#2,5:157\n60#2,5:173\n60#2,5:178\n60#2,5:183\n60#2,5:189\n60#2,5:194\n13#2:199\n672#3,11:162\n1#4:188\n*S KotlinDebug\n*F\n+ 1 ThinClientUserManager.kt\ncom/intellij/cwm/frontend/users/ThinClientUserManager\n*L\n106#1:157,5\n58#1:173,5\n64#1:178,5\n66#1:183,5\n73#1:189,5\n86#1:194,5\n154#1:199\n111#1:162,11\n*E\n"})
public final class ThinClientUserManager
extends UserManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private UserModel model;
    @NotNull
    private static final Logger logger;

    public ThinClientUserManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    public boolean getCwmActionsAllowed() {
        return !FrontendProcessInfo.INSTANCE.isController();
    }

    public final void bindWithModel$intellij_cwm_frontend(@NotNull UserModel userModel) {
        Intrinsics.checkNotNullParameter((Object)userModel, (String)"userModel");
        this.model = userModel;
        this.getConnectableUsers().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientUserManager.bindWithModel$lambda$0(this, arg_0, arg_1, arg_2));
        UserModel userModel2 = this.model;
        if (userModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel2 = null;
        }
        userModel2.getUsers().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientUserManager.bindWithModel$lambda$1(this, arg_0, arg_1, arg_2));
        UserModel userModel3 = this.model;
        if (userModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel3 = null;
        }
        userModel3.getFollowers().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientUserManager.bindWithModel$lambda$2(this, arg_0, arg_1, arg_2));
        UserModel userModel4 = this.model;
        if (userModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel4 = null;
        }
        userModel4.getFollow().advise(this.getServiceLifetime(), arg_0 -> ThinClientUserManager.bindWithModel$lambda$3(this, arg_0));
        UserModel userModel5 = this.model;
        if (userModel5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel5 = null;
        }
        userModel5.getFollowingRequest().advise(this.getServiceLifetime(), arg_0 -> ThinClientUserManager.bindWithModel$lambda$4(this, arg_0));
        UserModel userModel6 = this.model;
        if (userModel6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel6 = null;
        }
        userModel6.getStopFollowingRequest().advise(this.getServiceLifetime(), arg_0 -> ThinClientUserManager.bindWithModel$lambda$5(this, arg_0));
        UserModel userModel7 = this.model;
        if (userModel7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel7 = null;
        }
        userModel7.getFollowingRetarget().advise(this.getServiceLifetime(), arg_0 -> ThinClientUserManager.bindWithModel$lambda$6(this, arg_0));
        ApplicationKt.getApplication().invokeLater(() -> ThinClientUserManager.bindWithModel$lambda$7(this));
    }

    private final RdUserModel sanitizeUser(RdUserModel user) {
        CharSequence charSequence = user.getName();
        Regex regex = RdConstants.INSTANCE.getNotAllowedNameCharactersRegex();
        String string = "_";
        return new RdUserModel(user.getUserId(), regex.replace(charSequence, string), user.getColorBucket());
    }

    public void jumpTo(@NotNull RdUserModel user) {
        UserModel userModel;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Jump to " + user.getUserId(), t$iv);
        }
        if ((userModel = this.model) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        userModel.getJumpTo().fire((Object)user.getUserId());
    }

    public void startFollowing(@NotNull RdUserModel user) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            UserModel userModel = this.model;
            if (userModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
                userModel = null;
            }
            Iterable $this$singleOrNull$iv = userModel.getUsers().entrySet();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)user)) continue;
                if (found$iv) {
                    v1 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Map.Entry entry = v1;
        RdUserId userId = entry != null ? (RdUserId)entry.getKey() : null;
        UserModel userModel = this.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        userModel.getFollow().setValue((Object)userId);
        this.setRecentLead((IPropertyView)new Property(this.getLead().getValue()));
    }

    public void stopFollowing() {
        IPropertyView tmpLead = (IPropertyView)new Property(this.getLead().getValue());
        UserModel userModel = this.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        userModel.getFollow().setValue(null);
        this.setRecentLead(tmpLead);
    }

    public void requestFollowing(@NotNull RdUserModel user, boolean force) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserRequestFollowingCookie.INSTANCE.using(() -> ThinClientUserManager.requestFollowing$lambda$0(this, user, force));
    }

    public void requestStopFollowing(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserRequestFollowingCookie.INSTANCE.using(() -> ThinClientUserManager.requestStopFollowing$lambda$0(this, user));
    }

    @Nullable
    public RdUserModel getUserById(@NotNull RdUserId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        UserModel userModel = this.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        return (RdUserModel)userModel.getUsers().get((Object)id);
    }

    @Nullable
    public RdUserProperties getUserProperties(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserModel userModel = this.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        return (RdUserProperties)userModel.getUserProperties().get((Object)user.getUserId());
    }

    @NotNull
    public List<AnAction> createUserActions(@NotNull RdUserModel user) {
        RemoteControlSession session;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UnattendedHostSession unattendedHostSession = (UnattendedHostSession)ThinClientUnattendedHostControlHost.Companion.getInstance().getSession().getValue();
        RemoteControlSession remoteControlSession = unattendedHostSession != null && (unattendedHostSession = unattendedHostSession.getModel()) != null && (unattendedHostSession = unattendedHostSession.getSession()) != null ? (RemoteControlSession)unattendedHostSession.getValue() : (session = null);
        if (session == null || UserManagerKt.isHost((RdUserModel)user)) {
            return super.createUserActions(user);
        }
        Object[] objectArray = new AnAction[]{new Separator(), ControllerUserActionsKt.createKickAction(session, user)};
        return CollectionsKt.plus((Collection)super.createUserActions(user), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private static final Unit bindWithModel$lambda$4$1(ThinClientUserManager this$0, RdUserModel $user) {
        this$0.startFollowing($user);
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$0(ThinClientUserManager this$0, Lifetime connectableUserLt, int n, ConnectableUser connectableUser) {
        RdUserProperties userProperties;
        Intrinsics.checkNotNullParameter((Object)connectableUserLt, (String)"connectableUserLt");
        Intrinsics.checkNotNullParameter((Object)connectableUser, (String)"connectableUser");
        UserModel userModel = this$0.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        if ((userProperties = (RdUserProperties)userModel.getUserProperties().get((Object)connectableUser.getUser().getUserId())) == null) {
            return Unit.INSTANCE;
        }
        SourceExKt.flowInto((ISource)((ISource)userProperties.getConnected()), (Lifetime)connectableUserLt, (IMutablePropertyBase)((IMutablePropertyBase)connectableUser.getConnected()));
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$1(ThinClientUserManager this$0, Lifetime lt, RdUserId rdUserId, RdUserModel rdUserModel) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)rdUserId, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)rdUserModel, (String)"rdUserModel");
        this$0.registerUser(lt, this$0.sanitizeUser(rdUserModel));
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$2(ThinClientUserManager this$0, Lifetime lt, int n, RdUserId userId) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserModel userModel = this$0.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        RdUserModel rdUserModel = (RdUserModel)userModel.getUsers().get((Object)userId);
        if (rdUserModel == null) {
            throw new IllegalStateException(("Can not find user with ID " + userId + ". Aru you following yourself?").toString());
        }
        RdUserModel user = rdUserModel;
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("New follower: " + user.getUserId().getClientIdValue() + " : " + user.getName(), t$iv);
        }
        CollectionExKt.addUnique((Collection)((Collection)this$0.getFollowersList()), (Lifetime)lt, (Object)user);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit bindWithModel$lambda$3(ThinClientUserManager this$0, RdUserId userId) {
        RdUserModel rdUserModel;
        Logger logger;
        RdUserId t$iv;
        if (userId == null) {
            Logger $this$debug_u24default$iv = ThinClientUserManager.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Stop following", (Throwable)t$iv);
            }
        } else {
            Logger $this$debug_u24default$iv = ThinClientUserManager.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Follower user " + userId, (Throwable)t$iv);
            }
        }
        Property property = this$0.getLeadProperty();
        RdUserId rdUserId = userId;
        if (rdUserId != null) {
            void it;
            t$iv = rdUserId;
            logger = property;
            boolean bl = false;
            UserModel userModel = this$0.model;
            if (userModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
                userModel = null;
            }
            rdUserModel = (RdUserModel)userModel.getUsers().get((Object)it);
            property = logger;
        } else {
            rdUserModel = null;
        }
        property.setValue(rdUserModel);
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$4(ThinClientUserManager this$0, RdUserFollowingRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (UserRequestFollowingCookie.INSTANCE.isLocalChange()) {
            return Unit.INSTANCE;
        }
        UserModel userModel = this$0.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        RdUserModel rdUserModel = (RdUserModel)userModel.getUsers().get((Object)request.getUserId());
        if (rdUserModel == null) {
            throw new IllegalStateException(("Can not find user with ID " + request.getUserId() + ". Are you following yourself?").toString());
        }
        RdUserModel user = rdUserModel;
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("New follow request: " + user.getUserId().getClientIdValue() + " : " + user.getName(), t$iv);
        }
        UserNotifications.INSTANCE.askForFollowOtherUser(this$0.getProject(), user, request.getForce(), () -> ThinClientUserManager.bindWithModel$lambda$4$1(this$0, user));
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$5(ThinClientUserManager this$0, RdUserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (UserRequestFollowingCookie.INSTANCE.isLocalChange()) {
            return Unit.INSTANCE;
        }
        RdUserModel rdUserModel = (RdUserModel)this$0.getMe().getValue();
        if (!Intrinsics.areEqual((Object)(rdUserModel != null ? rdUserModel.getUserId() : null), (Object)userId)) {
            throw new IllegalStateException("This request should be addressed to me. Instead we are trying to stop other user's following.".toString());
        }
        if (this$0.getLead().getValue() != null) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Stop following request", t$iv);
            }
            this$0.stopFollowing();
            GuestNotifications.INSTANCE.showFollowingStoppedNotification(this$0.getProject());
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$6(ThinClientUserManager this$0, RdUserFollowingRetarget retarget) {
        Intrinsics.checkNotNullParameter((Object)retarget, (String)"retarget");
        UserNotifications.INSTANCE.showFollowingRetargetNotification(this$0.getProject(), retarget.getFromUser(), retarget.getToUser());
        return Unit.INSTANCE;
    }

    private static final void bindWithModel$lambda$7(ThinClientUserManager this$0) {
        this$0.getSessionEnabledProperty().set((Object)true);
    }

    private static final Unit requestFollowing$lambda$0(ThinClientUserManager this$0, RdUserModel $user, boolean $force) {
        UserModel userModel = this$0.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        userModel.getFollowingRequest().fire((Object)new RdUserFollowingRequest($user.getUserId(), $force));
        return Unit.INSTANCE;
    }

    private static final Unit requestStopFollowing$lambda$0(ThinClientUserManager this$0, RdUserModel $user) {
        UserModel userModel = this$0.model;
        if (userModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            userModel = null;
        }
        userModel.getStopFollowingRequest().fire((Object)$user.getUserId());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientUserManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientUserManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/frontend/users/ThinClientUserManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

