/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.python.django.run.EditDjangoSettingsFix;
import com.intellij.util.PlatformUtils;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001aB\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u000b"}, d2={"reportNoDjangoOnModule", "", "project", "Lcom/intellij/openapi/project/Project;", "fixEnvsIfNeeded", "", "", "isWin10OrNewer", "", "configurationEnvs", "systemEnvs", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoRunnerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoRunnerUtils.kt\ncom/intellij/python/django/DjangoRunnerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1807#2,3:46\n*S KotlinDebug\n*F\n+ 1 DjangoRunnerUtils.kt\ncom/intellij/python/django/DjangoRunnerUtilsKt\n*L\n40#1:46,3\n*E\n"})
public final class DjangoRunnerUtilsKt {
    public static final void reportNoDjangoOnModule(@NotNull Project project) throws RuntimeConfigurationError {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (PlatformUtils.isPyCharm()) {
            RuntimeConfigurationError exc = new RuntimeConfigurationError(DjangoBundle.message((String)"dialog.message.please.enable.django.support.for.project", (Object[])new Object[0]));
            exc.setQuickFix((ConfigurationQuickFix)new EditDjangoSettingsFix(project));
            throw exc;
        }
        throw new RuntimeConfigurationError(DjangoBundle.message((String)"dialog.message.please.select.django.module", (Object[])new Object[0]));
    }

    @NotNull
    public static final Map<String, String> fixEnvsIfNeeded(boolean isWin10OrNewer, @NotNull Map<String, String> configurationEnvs, @NotNull Map<String, String> systemEnvs) {
        Intrinsics.checkNotNullParameter(configurationEnvs, (String)"configurationEnvs");
        Intrinsics.checkNotNullParameter(systemEnvs, (String)"systemEnvs");
        if (isWin10OrNewer) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = systemEnvs.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"=", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                Logger.getInstance((String)"Django").warn("Fixing environment");
                return MapsKt.plus(configurationEnvs, (Map)MapsKt.mapOf((Pair)new Pair((Object)"=C:", (Object)"C:\\")));
            }
        }
        return configurationEnvs;
    }
}

