/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight.djangoForms;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormsCompletionProviderKt;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.model.DjangoMeta;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/django/codeInsight/djangoForms/DjangoFormsCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python.django"})
public final class DjangoFormsCompletionProvider
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        ASTNode aSTNode = position.getNode();
        if (aSTNode == null) {
            return;
        }
        ASTNode node = aSTNode;
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)position.getProject(), (PsiFile)position.getContainingFile());
        boolean elementIsId = Intrinsics.areEqual((Object)node.getElementType(), (Object)PyTokenTypes.IDENTIFIER);
        boolean elementIsString = Intrinsics.areEqual((Object)node.getElementType(), (Object)PyTokenTypes.SINGLE_QUOTED_STRING);
        if (!elementIsId && !elementIsString) {
            return;
        }
        PyClass pyClass = (PyClass)new PsiQuery(position).ancestors(PyClass.class).ancestors(PyStatementList.class).ancestors(PyClass.class).getFirstElement();
        if (pyClass == null) {
            return;
        }
        PyClass formClass = pyClass;
        if (!NameResolverTools.isSubclass((PyClass)formClass, (FQNamesProvider)((FQNamesProvider)DjangoFQNamesProvider.MODEL_FORM_CLASS), (TypeEvalContext)context)) {
            return;
        }
        DjangoMeta meta = DjangoMeta.fromAnyClass((PyClass)formClass);
        PsiElement positionParent = position.getParent();
        if (meta == null && positionParent instanceof PyClass) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"Meta").withIcon(AllIcons.Nodes.Class));
        }
        if (meta != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)meta.getMetaClass()), (PsiElement)position, (boolean)true)) {
            if (elementIsId) {
                for (String field : DjangoFormsCompletionProviderKt.access$getMETA_FIELDS$p()) {
                    if (meta.getMetaClass().findClassAttribute(field, false, context) != null) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)field).withIcon(AllIcons.Nodes.Field));
                }
            } else {
                PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)new PsiQuery(position).ancestors(PyStringLiteralExpression.class).ancestors(PyAssignmentStatement.class).getFirstElement();
                if (pyAssignmentStatement == null) {
                    return;
                }
                PyAssignmentStatement assignmentStatement = pyAssignmentStatement;
                PyExpression pyExpression = assignmentStatement.getLeftHandSideExpression();
                if (pyExpression == null) {
                    return;
                }
                PyExpression sideExpression = pyExpression;
                if (!(assignmentStatement.getAssignedValue() instanceof PyStringLiteralExpression)) {
                    return;
                }
                String fieldName = sideExpression.getName();
                if (Intrinsics.areEqual((Object)"fields", (Object)fieldName) || Intrinsics.areEqual((Object)"localized_fields", (Object)fieldName)) {
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)"__all__");
                    Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
                    LookupElementBuilder builder = lookupElementBuilder;
                    result.addElement(builder.withBoldness(true).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE));
                }
            }
        }
    }
}

