/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.livepreview;

import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.lang.template.livepreview.DjangoTemplateEditorWithPreview;
import com.intellij.python.django.lang.template.livepreview.DjangoTemplatePreviewFileEditor;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.jetbrains.django.facet.DjangoFacet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/django/lang/template/livepreview/DjangoTemplatePreviewFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoTemplatePreviewFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoTemplatePreviewFileEditorProvider.kt\ncom/intellij/python/django/lang/template/livepreview/DjangoTemplatePreviewFileEditorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class DjangoTemplatePreviewFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)file, (Project)project);
        if (!((psiFile != null ? psiFile.getViewProvider() : null) instanceof DjangoTemplateFileViewProvider)) {
            return false;
        }
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (DjangoFacet.isPresent((Module)moduleForFile)) {
            Set set;
            Module module = moduleForFile;
            if (module != null) {
                Module it = module;
                boolean bl = false;
                List list = TemplatesService.getInstance((Module)it).getTemplateFolders();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTemplateFolders(...)");
                set = CollectionsKt.toSet((Iterable)list);
            } else {
                set = null;
            }
            Set templateFolders = set;
            return VfsUtilCore.isUnder((VirtualFile)file, templateFolders);
        }
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (FileEditor)new DjangoTemplateEditorWithPreview(project, file, new DjangoTemplatePreviewFileEditor(project, file));
    }

    @NotNull
    public String getEditorTypeId() {
        return "DjangoTemplatePreviewFileEditor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_OTHER_EDITORS;
    }
}

