/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.constance.lang;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.packages.constance.ConstanceUtils;
import com.intellij.python.django.packages.constance.lang.ConstanceFieldsetsMissingQuickFix;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/django/packages/constance/lang/ConstanceFieldsetsVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getTypeEvalContext", "()Lcom/jetbrains/python/psi/types/TypeEvalContext;", "visitPyStringLiteralExpression", "", "node", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "intellij.python.django"})
final class ConstanceFieldsetsVisitor
extends PyInspectionVisitor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final TypeEvalContext typeEvalContext;

    public ConstanceFieldsetsVisitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext typeEvalContext) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        super(holder, typeEvalContext);
        this.holder = holder;
        this.typeEvalContext = typeEvalContext;
    }

    @NotNull
    public final TypeEvalContext getTypeEvalContext() {
        return this.typeEvalContext;
    }

    public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super.visitPyStringLiteralExpression(node);
        if (ConstanceUtils.INSTANCE.getConfigDeclaration(node) == null) {
            return;
        }
        String string = node.getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        if (ConstanceUtils.INSTANCE.isFieldsetMissing(string, (PsiElement)node, this.typeEvalContext)) {
            PsiElement psiElement = (PsiElement)node;
            TextRange textRange = node.getStringValueTextRange();
            Object[] objectArray = new Object[]{node.getStringValue()};
            String string2 = DjangoBundle.message((String)"constance.add.missing.constants.description", (Object[])objectArray);
            objectArray = new LocalQuickFix[1];
            Intrinsics.checkNotNull((Object)LocalQuickFix.from((ModCommandAction)((ModCommandAction)new ConstanceFieldsetsMissingQuickFix(node, null, 2, null))));
            this.holder.registerProblem(psiElement, textRange, string2, (LocalQuickFix[])objectArray);
        }
    }
}

