/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.constance.lang;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.intellij.python.django.packages.constance.ConstanceConfigElement;
import com.intellij.python.django.packages.constance.ConstanceUtils;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/python/django/packages/constance/lang/ConstanceSettingUsageInspection;", "Lcom/intellij/python/django/lang/template/inspection/DjangoLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.django"})
@ApiStatus.Internal
public final class ConstanceSettingUsageInspection
extends DjangoLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!ConstanceUtils.INSTANCE.isConstanceSupportEnabled()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiFile psiFile = holder.getFile();
        PyFile pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        if (pyFile == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PyFile file = pyFile;
        if (DjangoModelApi.Companion.notDjangoModule((PsiElement)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext((LocalInspectionToolSession)session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/django/packages/constance/lang/ConstanceSettingUsageInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "myHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "myTypeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyReferenceExpression", "", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPyKeywordArgument", "Lcom/jetbrains/python/psi/PyKeywordArgument;", "validateSetting", "name", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.python.django"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder myHolder;

        public Visitor(@NotNull ProblemsHolder myHolder, @NotNull TypeEvalContext myTypeEvalContext) {
            Intrinsics.checkNotNullParameter((Object)myHolder, (String)"myHolder");
            Intrinsics.checkNotNullParameter((Object)myTypeEvalContext, (String)"myTypeEvalContext");
            super(myHolder, myTypeEvalContext);
            this.myHolder = myHolder;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            if (ConstanceUtils.INSTANCE.isConfigSettingUsage((PyQualifiedExpression)node)) {
                ASTNode aSTNode = node.getNameElement();
                this.validateSetting(node.getReferencedName(), (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
            }
        }

        public void visitPyKeywordArgument(@NotNull PyKeywordArgument node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyKeywordArgument(node);
            if (ConstanceUtils.INSTANCE.isOverrideSettingUsage(node)) {
                ASTNode aSTNode = node.getKeywordNode();
                this.validateSetting(node.getKeyword(), (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
            }
        }

        private final void validateSetting(String name, PsiElement element) {
            if (name == null || element == null) {
                return;
            }
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            ConstanceConfigElement configElement = ConstanceUtils.INSTANCE.findConfigElement(name, element, typeEvalContext);
            if (configElement == null) {
                Object[] objectArray = new Object[]{name};
                this.myHolder.registerProblem(element, DjangoBundle.message((String)"inspection.constance-config.error", (Object[])objectArray), new LocalQuickFix[0]);
            }
        }
    }
}

