/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterListType;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyIntersectionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyTypeRenderer
extends PyTypeVisitorExt<HtmlChunk> {
    private static final int MAX_DEPTH = 6;
    protected int myDepth;
    @NotNull
    protected final TypeEvalContext myTypeEvalContext;
    protected final EnumSet<Feature> myRenderingFeatures;

    protected final boolean isRenderingFqn() {
        return this.myRenderingFeatures.contains((Object)Feature.USE_FQN);
    }

    protected final boolean isRenderingTypeVarBounds() {
        return this.myRenderingFeatures.contains((Object)Feature.TYPE_VAR_BOUNDS);
    }

    protected final boolean isRenderingUnsafeUnion() {
        return this.myRenderingFeatures.contains((Object)Feature.UNSAFE_UNION);
    }

    private PyTypeRenderer(@NotNull TypeEvalContext typeEvalContext, @NotNull EnumSet<Feature> features) {
        if (typeEvalContext == null) {
            PyTypeRenderer.$$$reportNull$$$0(0);
        }
        if (features == null) {
            PyTypeRenderer.$$$reportNull$$$0(1);
        }
        this.myDepth = 0;
        this.myTypeEvalContext = typeEvalContext;
        this.myRenderingFeatures = features;
    }

    protected boolean maxDepthExceeded() {
        return this.myDepth > 6;
    }

    @NotNull
    protected HtmlChunk render(@Nullable PyType type) {
        if (this.maxDepthExceeded()) {
            HtmlChunk htmlChunk = this.styled("...", PyHighlighter.PY_DOT);
            if (htmlChunk == null) {
                PyTypeRenderer.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }
        ++this.myDepth;
        HtmlChunk htmlChunk = (HtmlChunk)PyTypeRenderer.visit((PyType)type, (PyTypeVisitor)this);
        HtmlChunk htmlChunk2 = htmlChunk;
        if (htmlChunk2 == null) {
            PyTypeRenderer.$$$reportNull$$$0(3);
        }
        return htmlChunk2;
        finally {
            --this.myDepth;
        }
    }

    @NotNull
    protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
        if (style == null) {
            PyTypeRenderer.$$$reportNull$$$0(4);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)StringUtil.notNullize((String)text));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(5);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk escaped(@Nls String text) {
        HtmlChunk htmlChunk = HtmlChunk.raw((String)StringUtil.notNullize((String)text));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk className(@Nls String name) {
        HtmlChunk htmlChunk = this.escaped(name);
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(7);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk styledExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            PyTypeRenderer.$$$reportNull$$$0(8);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)expression.getText());
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(9);
        }
        return htmlChunk;
    }

    protected final boolean isBitwiseOrUnionAvailable() {
        return PyTypingTypeProvider.isBitwiseOrUnionAvailable(this.myTypeEvalContext);
    }

    protected final boolean isGenericBuiltinsAvailable() {
        PsiFile origin = this.myTypeEvalContext.getOrigin();
        return origin == null || PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)origin).isAtLeast(LanguageLevel.PYTHON39);
    }

    @Override
    public HtmlChunk visitPyGenericType(@NotNull PyCollectionType collectionOf) {
        if (collectionOf == null) {
            PyTypeRenderer.$$$reportNull$$$0(10);
        }
        HtmlChunk genericTypeRender = this.renderGenericType(collectionOf);
        return collectionOf.isDefinition() ? this.wrapInTypingType(genericTypeRender) : genericTypeRender;
    }

    @NotNull
    private HtmlChunk renderGenericType(@NotNull PyCollectionType genericType) {
        if (genericType == null) {
            PyTypeRenderer.$$$reportNull$$$0(11);
        }
        HtmlBuilder result = new HtmlBuilder();
        boolean renderTypeArgumentList = !genericType.getElementTypes().isEmpty();
        Object className = genericType.getName();
        if (renderTypeArgumentList && !this.isGenericBuiltinsAvailable() && PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.containsKey(className)) {
            className = (String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.get(className);
            if (this.isRenderingFqn()) {
                className = "typing." + (String)className;
            }
            result.append(this.className((String)className));
        } else {
            result.append(this.className((String)(this.isRenderingFqn() ? genericType.getClassQName() : className)));
        }
        if (renderTypeArgumentList) {
            result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result.append(this.renderList(ContainerUtil.map(genericType.getElementTypes(), this::render)));
            result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(12);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk wrapInTypingType(@NotNull HtmlChunk instanceTypeRender) {
        if (instanceTypeRender == null) {
            PyTypeRenderer.$$$reportNull$$$0(13);
        }
        HtmlChunk htmlChunk = new HtmlBuilder().append(this.isGenericBuiltinsAvailable() ? this.styled("type", PyHighlighter.PY_BUILTIN_NAME) : this.escaped(this.isRenderingFqn() ? "typing.Type" : "Type")).append(this.styled("[", PyHighlighter.PY_BRACKETS)).append(instanceTypeRender).append(this.styled("]", PyHighlighter.PY_BRACKETS)).toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(14);
        }
        return htmlChunk;
    }

    @NotNull
    public HtmlChunk visitPyClassLikeType(@NotNull PyClassLikeType classLikeType) {
        if (classLikeType == null) {
            PyTypeRenderer.$$$reportNull$$$0(15);
        }
        HtmlChunk classTypeRender = this.className(this.getTypeName((PyType)classLikeType));
        HtmlChunk htmlChunk = classLikeType.isDefinition() ? this.wrapInTypingType(classTypeRender) : classTypeRender;
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(16);
        }
        return htmlChunk;
    }

    @Override
    public HtmlChunk visitPyNarrowedType(@NotNull PyNarrowedType narrowedType) {
        if (narrowedType == null) {
            PyTypeRenderer.$$$reportNull$$$0(17);
        }
        HtmlBuilder result = new HtmlBuilder();
        if (narrowedType.getTypeIs()) {
            result.append(this.styled(this.isRenderingFqn() ? "typing.TypeIs" : "TypeIs", PyHighlighter.PY_CLASS_DEFINITION));
        } else {
            result.append(this.styled(this.isRenderingFqn() ? "typing.TypeGuard" : "TypeGuard", PyHighlighter.PY_CLASS_DEFINITION));
        }
        result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
        result.append(this.render(narrowedType.getNarrowedType()));
        result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        return result.toFragment();
    }

    @NotNull
    public HtmlChunk visitPyNeverType(@NotNull PyNeverType neverType) {
        if (neverType == null) {
            PyTypeRenderer.$$$reportNull$$$0(18);
        }
        HtmlChunk htmlChunk = this.className(neverType.getName());
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(19);
        }
        return htmlChunk;
    }

    @Override
    public HtmlChunk visitPyUnionType(@NotNull PyUnionType unionType) {
        if (unionType == null) {
            PyTypeRenderer.$$$reportNull$$$0(20);
        }
        if (PyTypeRenderer.isOptional(unionType)) {
            return this.renderOptional(unionType);
        }
        Pair<List<PyLiteralType>, List<PyType>> literalsAndOthers = PyTypeRenderer.extractLiterals(unionType);
        if (literalsAndOthers != null) {
            if (((List)literalsAndOthers.second).isEmpty()) {
                return this.renderUnionOfLiterals((List)literalsAndOthers.first);
            }
            return this.renderUnion(ContainerUtil.prepend((List)ContainerUtil.map((Collection)((Collection)literalsAndOthers.second), this::render), (Object[])new HtmlChunk[]{this.renderUnionOfLiterals((List)literalsAndOthers.first)}));
        }
        if (ContainerUtil.all(unionType.getMembers(), t -> {
            PyClassType ct;
            return t instanceof PyClassType && (ct = (PyClassType)t).isDefinition();
        })) {
            return this.wrapInTypingType(this.render(unionType.map(type -> type != null ? ((PyClassType)type).toInstance() : null)));
        }
        if (unionType.getMembers().contains(null)) {
            return this.renderUnion(List.of(this.render(PyUnionType.union(ContainerUtil.skipNulls(unionType.getMembers()))), this.visitUnknownType()));
        }
        return this.renderUnion(ContainerUtil.map(unionType.getMembers(), this::render));
    }

    @Override
    @NotNull
    public HtmlChunk visitPyUnsafeUnionType(@NotNull PyUnsafeUnionType unsafeUnionType) {
        if (unsafeUnionType == null) {
            PyTypeRenderer.$$$reportNull$$$0(21);
        }
        if (this.isRenderingUnsafeUnion()) {
            HtmlBuilder result = new HtmlBuilder();
            result.append(this.escaped("UnsafeUnion"));
            result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result.append(this.renderList(ContainerUtil.map(unsafeUnionType.getMembers(), this::render)));
            result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
            HtmlChunk htmlChunk = result.toFragment();
            if (htmlChunk == null) {
                PyTypeRenderer.$$$reportNull$$$0(22);
            }
            return htmlChunk;
        }
        return this.renderUnion(ContainerUtil.map(unsafeUnionType.getMembers(), this::render));
    }

    @NotNull
    private HtmlChunk renderUnionOfLiterals(@NotNull List<PyLiteralType> literals) {
        if (literals == null) {
            PyTypeRenderer.$$$reportNull$$$0(23);
        }
        HtmlChunk htmlChunk = new HtmlBuilder().append(this.escaped(this.isRenderingFqn() ? "typing.Literal" : "Literal")).append(this.styled("[", PyHighlighter.PY_BRACKETS)).append((HtmlChunk)StreamEx.of(literals).map(PyLiteralType::getExpression).map(expr -> this.styledExpression((PyExpression)expr)).collect(HtmlChunk.toFragment((HtmlChunk)this.styled(", ", PyHighlighter.PY_COMMA)))).append(this.styled("]", PyHighlighter.PY_BRACKETS)).toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(24);
        }
        return htmlChunk;
    }

    @NotNull
    private HtmlChunk renderUnion(@NotNull List<HtmlChunk> renderedUnionMembers) {
        if (renderedUnionMembers == null) {
            PyTypeRenderer.$$$reportNull$$$0(25);
        }
        HtmlBuilder result = new HtmlBuilder();
        if (this.isBitwiseOrUnionAvailable()) {
            result.append(this.renderList(renderedUnionMembers, " | "));
        } else {
            result.append(this.escaped(this.isRenderingFqn() ? "typing.Union" : "Union"));
            result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result.append(this.renderList(renderedUnionMembers));
            result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(26);
        }
        return htmlChunk;
    }

    @NotNull
    private HtmlChunk renderOptional(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeRenderer.$$$reportNull$$$0(27);
        }
        HtmlBuilder result = new HtmlBuilder();
        if (this.isBitwiseOrUnionAvailable()) {
            result.append(this.render((PyType)ContainerUtil.find(type.getMembers(), t -> !PyNoneTypeKt.isNoneType(t))));
            result.append(this.styled(" | ", PyHighlighter.PY_OPERATION_SIGN));
            result.append(this.render((PyType)ContainerUtil.find(type.getMembers(), t -> PyNoneTypeKt.isNoneType(t))));
        } else {
            result.append(this.escaped(this.isRenderingFqn() ? "typing.Optional" : "Optional"));
            result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            result.append(this.render((PyType)ContainerUtil.find(type.getMembers(), t -> !PyNoneTypeKt.isNoneType(t))));
            result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(28);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    public HtmlChunk visitPyIntersectionType(@NotNull PyIntersectionType intersectionType) {
        if (intersectionType == null) {
            PyTypeRenderer.$$$reportNull$$$0(29);
        }
        HtmlChunk htmlChunk = this.renderList(ContainerUtil.map(intersectionType.getMembers(), this::render), " & ");
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(30);
        }
        return htmlChunk;
    }

    private static @Nullable Pair<@NotNull List<PyLiteralType>, @NotNull List<PyType>> extractLiterals(@NotNull PyUnionType type) {
        Collection<PyType> members;
        List literalTypes;
        if (type == null) {
            PyTypeRenderer.$$$reportNull$$$0(31);
        }
        if ((literalTypes = ContainerUtil.filterIsInstance(members = type.getMembers(), PyLiteralType.class)).size() < 2) {
            return null;
        }
        List otherTypes = ContainerUtil.filter(members, m -> !(m instanceof PyLiteralType));
        return Pair.create((Object)literalTypes, (Object)otherTypes);
    }

    private static boolean isOptional(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeRenderer.$$$reportNull$$$0(32);
        }
        return type.getMembers().size() == 2 && ContainerUtil.find(type.getMembers(), m -> PyNoneTypeKt.isNoneType(m)) != null;
    }

    @Override
    public HtmlChunk visitPyTupleType(@NotNull PyTupleType tupleType) {
        if (tupleType == null) {
            PyTypeRenderer.$$$reportNull$$$0(33);
        }
        HtmlBuilder result = new HtmlBuilder();
        if (this.isGenericBuiltinsAvailable()) {
            result.append(this.styled("tuple", PyHighlighter.PY_BUILTIN_NAME));
        } else {
            result.append(this.escaped(this.isRenderingFqn() ? "typing.Tuple" : "Tuple"));
        }
        result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
        if (!tupleType.getElementTypes().isEmpty()) {
            result.append(this.renderList(ContainerUtil.map(tupleType.getElementTypes(), this::render)));
            if (tupleType.isHomogeneous()) {
                result.append(this.styled(", ", PyHighlighter.PY_COMMA));
                result.append(this.styled("...", PyHighlighter.PY_DOT));
            }
        } else {
            result.append(this.styled("()", PyHighlighter.PY_PARENTHS));
        }
        result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
        return result.toFragment();
    }

    public HtmlChunk visitUnknownType() {
        return HtmlChunk.raw((String)(this.isRenderingFqn() ? "typing.Any" : "Any"));
    }

    public HtmlChunk visitPyType(@NotNull PyType type) {
        if (type == null) {
            PyTypeRenderer.$$$reportNull$$$0(34);
        }
        return this.escaped(type.getName());
    }

    public HtmlChunk visitPyCallableType(@NotNull PyCallableType callableType) {
        if (callableType == null) {
            PyTypeRenderer.$$$reportNull$$$0(35);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(this.styled("(", PyHighlighter.PY_PARENTHS));
        List parameters = callableType.getParameters(this.myTypeEvalContext);
        if (parameters != null) {
            result.append(this.renderList(ContainerUtil.map((Collection)parameters, this::visitPyCallableParameter)));
        } else {
            result.append(this.styled("...", PyHighlighter.PY_DOT));
        }
        result.append(this.styled(")", PyHighlighter.PY_PARENTHS));
        result.append(this.escaped(" -> "));
        result.append(this.render(callableType.getReturnType(this.myTypeEvalContext)));
        return result.toFragment();
    }

    @NotNull
    protected HtmlChunk visitPyCallableParameter(@NotNull PyCallableParameter param) {
        if (param == null) {
            PyTypeRenderer.$$$reportNull$$$0(36);
        }
        HtmlBuilder result = new HtmlBuilder();
        if (param.isPositionOnlySeparator()) {
            result.append(this.escaped("/"));
        } else if (param.isKeywordOnlySeparator()) {
            result.append(this.escaped("*"));
        } else if (param.isPositionalContainer() || param.isKeywordContainer()) {
            PyType type = param.getArgumentType(this.myTypeEvalContext);
            if (param.getName() != null) {
                result.append(this.escaped(param.isPositionalContainer() ? "*" : "**"));
                result.append(this.styled(param.getName(), PyHighlighter.PY_PARAMETER));
                result.append(this.styled(": ", PyHighlighter.PY_OPERATION_SIGN));
            }
            result.append(this.render(type));
        } else {
            PyType type = param.getType(this.myTypeEvalContext);
            if (!(type instanceof PyParamSpecType) && !(type instanceof PyConcatenateType) && param.getName() != null) {
                result.append(this.styled(param.getName(), PyHighlighter.PY_PARAMETER));
                result.append(this.styled(": ", PyHighlighter.PY_OPERATION_SIGN));
            }
            result.append(this.render(type));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(37);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk renderList(@NotNull Collection<HtmlChunk> list) {
        if (list == null) {
            PyTypeRenderer.$$$reportNull$$$0(38);
        }
        HtmlChunk htmlChunk = this.renderList(list, ", ");
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(39);
        }
        return htmlChunk;
    }

    @NotNull
    protected HtmlChunk renderList(@NotNull Collection<HtmlChunk> list, @NotNull @Nls String separator) {
        if (list == null) {
            PyTypeRenderer.$$$reportNull$$$0(40);
        }
        if (separator == null) {
            PyTypeRenderer.$$$reportNull$$$0(41);
        }
        StreamEx streamEx = StreamEx.of(list);
        HtmlChunk htmlChunk = (HtmlChunk)streamEx.collect(HtmlChunk.toFragment((HtmlChunk)(switch (separator) {
            case ", " -> this.styled(separator, PyHighlighter.PY_COMMA);
            case " | " -> this.styled(separator, PyHighlighter.PY_OPERATION_SIGN);
            case " & " -> this.styled(separator, PyHighlighter.PY_OPERATION_SIGN);
            default -> this.escaped(separator);
        })));
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(42);
        }
        return htmlChunk;
    }

    @NotNull
    public HtmlChunk visitPyTypeVarType(@NotNull PyTypeVarType typeVarType) {
        PyType effectiveBound;
        if (typeVarType == null) {
            PyTypeRenderer.$$$reportNull$$$0(43);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(this.escaped(this.getTypeName((PyType)typeVarType)));
        if (this.isRenderingTypeVarBounds() && (effectiveBound = PyTypeUtil.getEffectiveBound(typeVarType)) != null) {
            result.append(this.escaped(" \u2264: "));
            result.append(this.render(effectiveBound));
        }
        HtmlChunk htmlChunk = typeVarType.isDefinition() ? this.wrapInTypingType(result.toFragment()) : result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(44);
        }
        return htmlChunk;
    }

    public HtmlChunk visitPyTypeParameterType(@NotNull PyTypeParameterType typeParameterType) {
        if (typeParameterType == null) {
            PyTypeRenderer.$$$reportNull$$$0(45);
        }
        return this.escaped(typeParameterType.getName());
    }

    @Override
    @NotNull
    public HtmlChunk visitPySelfType(@NotNull PySelfType selfType) {
        if (selfType == null) {
            PyTypeRenderer.$$$reportNull$$$0(46);
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(this.className(this.isRenderingFqn() ? "typing.Self" : "Self"));
        builder.append("@");
        builder.append(this.render((PyType)selfType.getScopeClassType().toInstance()));
        HtmlChunk htmlChunk = selfType.isDefinition() ? this.wrapInTypingType(builder.toFragment()) : builder.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(47);
        }
        return htmlChunk;
    }

    @NotNull
    public HtmlChunk visitPyCallableParameterListType(@NotNull PyCallableParameterListType callableParameterListType) {
        if (callableParameterListType == null) {
            PyTypeRenderer.$$$reportNull$$$0(48);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append("[");
        result.append(this.renderList(ContainerUtil.map((Collection)callableParameterListType.getParameters(), this::visitPyCallableParameter)));
        result.append("]");
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(49);
        }
        return htmlChunk;
    }

    @Override
    @NotNull
    public HtmlChunk visitPyLiteralType(@NotNull PyLiteralType literalType) {
        PyExpression pyExpression;
        if (literalType == null) {
            PyTypeRenderer.$$$reportNull$$$0(50);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(HtmlChunk.raw((String)(this.isRenderingFqn() ? "typing.Literal" : "Literal")));
        result.append("[");
        @Nullable String classQName = literalType.getClassQName();
        if (this.isRenderingFqn() && classQName != null && (pyExpression = literalType.getExpression()) instanceof PyReferenceExpression) {
            PyReferenceExpression refExpr = (PyReferenceExpression)pyExpression;
            result.append(classQName);
            if (refExpr.getName() != null) {
                result.append(".");
                result.append(refExpr.getName());
            }
        } else {
            String enumOrLiteral = StringUtil.notNullize((String)literalType.getExpression().getText()).trim();
            result.appendRaw(enumOrLiteral);
        }
        result.append("]");
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyTypeRenderer.$$$reportNull$$$0(51);
        }
        return htmlChunk;
    }

    @Nullable
    @NlsSafe
    protected final String getTypeName(@NotNull PyType type) {
        if (type == null) {
            PyTypeRenderer.$$$reportNull$$$0(52);
        }
        if (PyNoneTypeKt.isNoneType(type)) {
            return "None";
        }
        if (this.isRenderingFqn()) {
            PyQualifiedNameOwner declarationElement = type.getDeclarationElement();
            return declarationElement != null ? declarationElement.getQualifiedName() : null;
        }
        return type.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7, 9, 12, 14, 16, 19, 22, 24, 26, 28, 30, 37, 39, 42, 44, 47, 49, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionOf";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceTypeRender";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "narrowedType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neverType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsafeUnionType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literals";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedUnionMembers";
                break;
            }
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterType";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableParameterListType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "styled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escaped";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "className";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "styledExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "renderGenericType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInTypingType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyClassLikeType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyNeverType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyUnsafeUnionType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "renderUnionOfLiterals";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "renderUnion";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "renderOptional";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyIntersectionType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyCallableParameter";
                break;
            }
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "renderList";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyTypeVarType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPySelfType";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyCallableParameterListType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPyLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 39: 
            case 42: 
            case 44: 
            case 47: 
            case 49: 
            case 51: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "styled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "styledExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitPyGenericType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderGenericType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapInTypingType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitPyClassLikeType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNarrowedType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNeverType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPyUnionType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitPyUnsafeUnionType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "renderUnionOfLiterals";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "renderUnion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "renderOptional";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitPyIntersectionType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "extractLiterals";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isOptional";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTupleType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitPyType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableParameter";
                break;
            }
            case 38: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "renderList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeVarType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeParameterType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitPySelfType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallableParameterListType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitPyLiteralType";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7, 9, 12, 14, 16, 19, 22, 24, 26, 28, 30, 37, 39, 42, 44, 47, 49, 51 -> new IllegalStateException(string);
        };
    }

    public static enum Feature {
        USE_FQN,
        UNSAFE_UNION,
        TYPE_VAR_BOUNDS;

    }

    public static final class TypeHint
    extends PyTypeRenderer {
        private static final EnumSet<Feature> SUPPORTED_FEATURES = EnumSet.of(Feature.USE_FQN);

        public TypeHint(@NotNull TypeEvalContext typeEvalContext, @NotNull EnumSet<Feature> features) {
            if (typeEvalContext == null) {
                TypeHint.$$$reportNull$$$0(0);
            }
            if (features == null) {
                TypeHint.$$$reportNull$$$0(1);
            }
            super(typeEvalContext, TypeHint.validateFeatures(features));
        }

        @NotNull
        private static EnumSet<Feature> validateFeatures(@NotNull EnumSet<Feature> features) {
            if (features == null) {
                TypeHint.$$$reportNull$$$0(2);
            }
            EnumSet<Feature> unsupported = EnumSet.copyOf(features);
            unsupported.removeAll(SUPPORTED_FEATURES);
            if (!unsupported.isEmpty()) {
                throw new IllegalArgumentException("Unsupported features for type hint rendering " + String.valueOf(unsupported));
            }
            EnumSet<Feature> enumSet = features;
            if (enumSet == null) {
                TypeHint.$$$reportNull$$$0(3);
            }
            return enumSet;
        }

        @Override
        protected boolean maxDepthExceeded() {
            return false;
        }

        @Override
        public HtmlChunk visitPyCallableType(@NotNull PyCallableType callableType) {
            if (callableType == null) {
                TypeHint.$$$reportNull$$$0(4);
            }
            HtmlBuilder result = new HtmlBuilder();
            result.append(HtmlChunk.raw((String)(this.isRenderingFqn() ? "typing.Callable" : "Callable")));
            result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
            List<PyCallableParameter> parameters = this.getParameters(callableType);
            if (parameters != null) {
                result.append(this.styled("[", PyHighlighter.PY_BRACKETS));
                result.append(this.renderList(ContainerUtil.map(parameters, this::visitPyCallableParameter)));
                result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
            } else {
                result.append(this.styled("...", PyHighlighter.PY_DOT));
            }
            result.append(HtmlChunk.raw((String)", "));
            result.append(this.render(callableType.getReturnType(this.myTypeEvalContext)));
            result.append(this.styled("]", PyHighlighter.PY_BRACKETS));
            return result.toFragment();
        }

        @Nullable
        private List<PyCallableParameter> getParameters(@NotNull PyCallableType callableType) {
            List parameters;
            if (callableType == null) {
                TypeHint.$$$reportNull$$$0(5);
            }
            if ((parameters = callableType.getParameters(this.myTypeEvalContext)) == null) {
                return null;
            }
            if (parameters.isEmpty()) {
                return List.of();
            }
            for (int i = 0; i < parameters.size(); ++i) {
                PyCallableParameter parameter2 = (PyCallableParameter)parameters.get(i);
                if (parameter2.isPositionalContainer()) {
                    return null;
                }
                if (parameter2.isKeywordOnlySeparator()) {
                    return null;
                }
                if (!parameter2.isPositionOnlySeparator()) continue;
                if (i == parameters.size() - 1) {
                    return parameters.subList(0, i);
                }
                return null;
            }
            if (ContainerUtil.all((Collection)parameters, parameter -> parameter.getName() == null)) {
                return parameters;
            }
            return null;
        }

        @Override
        @NotNull
        protected HtmlChunk visitPyCallableParameter(@NotNull PyCallableParameter param) {
            if (param == null) {
                TypeHint.$$$reportNull$$$0(6);
            }
            HtmlChunk htmlChunk = this.render(param.getType(this.myTypeEvalContext));
            if (htmlChunk == null) {
                TypeHint.$$$reportNull$$$0(7);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        public HtmlChunk visitPyUnsafeUnionType(@NotNull PyUnsafeUnionType unsafeUnionType) {
            if (unsafeUnionType == null) {
                TypeHint.$$$reportNull$$$0(8);
            }
            HtmlChunk htmlChunk = this.visitUnknownType();
            if (htmlChunk == null) {
                TypeHint.$$$reportNull$$$0(9);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        public HtmlChunk visitPyIntersectionType(@NotNull PyIntersectionType intersectionType) {
            if (intersectionType == null) {
                TypeHint.$$$reportNull$$$0(10);
            }
            HtmlChunk htmlChunk = this.visitUnknownType();
            if (htmlChunk == null) {
                TypeHint.$$$reportNull$$$0(11);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        public HtmlChunk visitPySelfType(@NotNull PySelfType selfType) {
            if (selfType == null) {
                TypeHint.$$$reportNull$$$0(12);
            }
            HtmlChunk selfTypeRender = this.className(this.isRenderingFqn() ? "typing.Self" : "Self");
            HtmlChunk htmlChunk = selfType.isDefinition() ? this.wrapInTypingType(selfTypeRender) : selfTypeRender;
            if (htmlChunk == null) {
                TypeHint.$$$reportNull$$$0(13);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7, 9, 11, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "features";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer$TypeHint";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsafeUnionType";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intersectionType";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer$TypeHint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateFeatures";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPyCallableParameter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPyUnsafeUnionType";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPyIntersectionType";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitPySelfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "validateFeatures";
                    break;
                }
                case 3: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallableType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameters";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallableParameter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyUnsafeUnionType";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyIntersectionType";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPySelfType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 7, 9, 11, 13 -> new IllegalStateException(string);
            };
        }
    }

    static final class Documentation
    extends PyTypeRenderer {
        Documentation(@NotNull TypeEvalContext typeEvalContext, @NotNull EnumSet<Feature> features) {
            if (typeEvalContext == null) {
                Documentation.$$$reportNull$$$0(0);
            }
            if (features == null) {
                Documentation.$$$reportNull$$$0(1);
            }
            super(typeEvalContext, features);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "features";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/documentation/PyTypeRenderer$Documentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class RichDocumentation
    extends HtmlRenderer {
        RichDocumentation(@NotNull TypeEvalContext typeEvalContext, @NotNull PsiElement anchor) {
            if (typeEvalContext == null) {
                RichDocumentation.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                RichDocumentation.$$$reportNull$$$0(1);
            }
            super(typeEvalContext, anchor, EnumSet.noneOf(Feature.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/documentation/PyTypeRenderer$RichDocumentation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class HtmlRenderer
    extends PyTypeRenderer {
        @NotNull
        private final PsiElement myAnchor;

        private HtmlRenderer(@NotNull TypeEvalContext typeEvalContext, @NotNull PsiElement anchor, @NotNull EnumSet<Feature> features) {
            if (typeEvalContext == null) {
                HtmlRenderer.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                HtmlRenderer.$$$reportNull$$$0(1);
            }
            if (features == null) {
                HtmlRenderer.$$$reportNull$$$0(2);
            }
            super(typeEvalContext, features);
            this.myAnchor = anchor;
        }

        @Override
        @NotNull
        protected HtmlChunk styled(@Nls String text, @NotNull TextAttributesKey style) {
            if (style == null) {
                HtmlRenderer.$$$reportNull$$$0(3);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.styledSpan(text, style);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(4);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk escaped(@Nls String text) {
            HtmlChunk htmlChunk = HtmlChunk.text((String)text);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk className(@Nls String name) {
            HtmlChunk htmlChunk = PyDocumentationLink.toPossibleClass(name, this.myAnchor, this.myTypeEvalContext);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(6);
            }
            return htmlChunk;
        }

        @Override
        @NotNull
        protected HtmlChunk styledExpression(@NotNull PyExpression expression) {
            if (expression == null) {
                HtmlRenderer.$$$reportNull$$$0(7);
            }
            HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.highlightExpressionText(expression.getText(), expression);
            if (htmlChunk == null) {
                HtmlRenderer.$$$reportNull$$$0(8);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvalContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "features";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeRenderer$HtmlRenderer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeRenderer$HtmlRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escaped";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "styledExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "styled";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "styledExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 8 -> new IllegalStateException(string);
            };
        }
    }
}

